/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import java.util.Optional;

public class RegressionTestTD
extends AbstractTramoModule
implements IPreprocessingModule {
    private static final String REGS = "Regression variables";
    private static final double DEF_MODEL_EPS = 0.01;
    private static final double DEF_CONSTRAINT_EPS = 0.03;
    private PreprocessingModel tdModel;
    private PreprocessingModel td6Model;
    private LikelihoodStatistics ntdStats;
    private LikelihoodStatistics td1Stats;
    private LikelihoodStatistics td6Stats;
    private final double pftd_;
    private final double pfwd_;
    private double pdel;
    private double pwd;
    private double ptd;
    private double sigma;
    private static final double DEF_TVAL = 1.96;
    private double tval_ = 1.96;

    public RegressionTestTD(double pftd) {
        this.pftd_ = pftd;
        this.pfwd_ = pftd;
    }

    public RegressionTestTD(double pftd, double pfwd) {
        this.pftd_ = pftd;
        this.pfwd_ = pfwd;
    }

    public double getPftd() {
        return this.pftd_;
    }

    public double getPfwd() {
        return this.pfwd_;
    }

    public double getTValue() {
        return this.tval_;
    }

    public void setTvalue(double tval) {
        this.tval_ = tval;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        if (!context.description.contains(var -> var.isCalendar() || var.isMovingHoliday())) {
            return ProcessingResult.Unprocessed;
        }
        this.td6Model = this.createModel(context, TradingDaysType.TradingDays, LengthOfPeriodType.None);
        if (this.td6Model == null) {
            return ProcessingResult.Failed;
        }
        ConcentratedLikelihood ll = this.td6Model.estimation.getLikelihood();
        this.td6Stats = this.td6Model.estimation.getStatistics();
        int nhp = this.td6Model.description.getArimaComponent().getFreeParametersCount();
        int df = ll.getN() - ll.getNx() - nhp;
        this.sigma = ll.getSsqErr() / (double)df;
        GregorianCalendarVariables vars = this.tdvars(context);
        this.td1Stats = this.check(vars, TradingDaysType.WorkingDays, LengthOfPeriodType.None);
        this.ntdStats = this.check(vars, TradingDaysType.None, LengthOfPeriodType.None);
        this.calcProb();
        TradingDaysType td = TradingDaysType.None;
        LengthOfPeriodType lp = LengthOfPeriodType.LeapYear;
        int sel = 0;
        if (this.pdel < this.pfwd_ && this.ptd < this.pftd_) {
            td = TradingDaysType.TradingDays;
            sel = 6;
        } else if (this.pwd < this.pftd_) {
            td = TradingDaysType.WorkingDays;
            sel = 1;
        } else {
            td = TradingDaysType.None;
            lp = LengthOfPeriodType.None;
        }
        this.tdModel = this.createModel(context, td, lp);
        if (td == TradingDaysType.None || !this.checkLY(this.tdModel)) {
            boolean mean = Math.abs(this.tdModel.estimation.getLikelihood().getTStats(true, 2)[0]) > 1.96;
            context.description = this.backModel(context, td, LengthOfPeriodType.None, this.checkEE(this.tdModel), mean);
        } else {
            boolean mean = Math.abs(this.tdModel.estimation.getLikelihood().getTStats(true, 2)[0]) > 1.96;
            context.description = this.backModel(context, td, LengthOfPeriodType.LeapYear, this.checkEE(this.tdModel), mean);
        }
        context.estimation = null;
        RegressionTestTD.transferLogs(this.tdModel, context);
        return ProcessingResult.Changed;
    }

    private void calcProb() {
        double fdel;
        F fstat = new F();
        this.pdel = 1.0;
        this.ptd = 1.0;
        this.pwd = 1.0;
        int nhp = this.td6Model.description.getArimaComponent().getFreeParametersCount();
        ConcentratedLikelihood ll = this.td6Model.estimation.getLikelihood();
        int df = ll.getN() - ll.getNx() - nhp;
        fstat.setDFDenom(df);
        if (this.td6Stats != null && this.td1Stats != null && (fdel = (this.td1Stats.SsqErr - this.td6Stats.SsqErr) / (5.0 * this.sigma)) > 0.0) {
            fstat.setDFNum(5);
            this.pdel = fstat.getProbability(fdel, ProbabilityType.Upper);
        }
        if (this.ntdStats == null) {
            if (this.td6Stats != null) {
                this.ptd = 0.0;
            }
            if (this.td1Stats != null) {
                this.pwd = 0.0;
            }
        } else {
            double fwd;
            double ftd;
            if (this.td6Stats != null && (ftd = (this.ntdStats.SsqErr - this.td6Stats.SsqErr) / (6.0 * this.sigma)) > 0.0) {
                fstat.setDFNum(6);
                this.ptd = fstat.getProbability(ftd, ProbabilityType.Upper);
            }
            if (this.td1Stats != null && (fwd = (this.ntdStats.SsqErr - this.td1Stats.SsqErr) / this.sigma) > 0.0) {
                fstat.setDFNum(1);
                this.pwd = fstat.getProbability(fwd, ProbabilityType.Upper);
            }
        }
    }

    private PreprocessingModel createModel(ModellingContext context, TradingDaysType td, LengthOfPeriodType lp) {
        ModelDescription model = context.description.clone();
        model.setAirline(context.hasseas);
        model.setMean(true);
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (td != TradingDaysType.None) {
            GregorianCalendarVariables vars = this.tdvars(context);
            vars.setDayOfWeek(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        ModellingContext cxt = new ModellingContext();
        cxt.description = model;
        ModelEstimation estimation = new ModelEstimation(model.buildRegArima());
        int nhp = model.getArimaComponent().getFreeParametersCount();
        estimation.compute(this.getMonitor(), nhp);
        cxt.estimation = estimation;
        return cxt.current(true);
    }

    private LikelihoodStatistics check(GregorianCalendarVariables tdvar, TradingDaysType td, LengthOfPeriodType lp) {
        ModelDescription model = this.td6Model.description.clone();
        model.removeVariable(var -> var.isCalendar());
        if (td != TradingDaysType.None) {
            tdvar.setDayOfWeek(td);
            model.addVariable(Variable.calendarVariable(tdvar, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        ModelEstimation estimation = new ModelEstimation(model.buildRegArima());
        int nhp = model.getArimaComponent().getFreeParametersCount();
        estimation.computeLikelihood(nhp);
        return estimation.getStatistics();
    }

    private ModelDescription backModel(ModellingContext context, TradingDaysType td, LengthOfPeriodType lp, boolean Ee, boolean mean) {
        ModelDescription model = context.description.clone();
        if (context.automodelling) {
            model.setMean(mean);
        }
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (!Ee) {
            model.removeVariable(var -> var.isMovingHoliday());
        } else {
            TsVariableList x = model.buildRegressionVariables();
            TsVariableSelection<ITsVariable> sel = x.selectCompatible(IMovingHolidayVariable.class);
            TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
            for (int i = 0; i < items.length; ++i) {
                Variable search = model.searchVariable((ITsVariable)items[i].variable);
                if (!search.status.needTesting()) continue;
                search.status = RegStatus.Accepted;
            }
        }
        if (td != TradingDaysType.None) {
            GregorianCalendarVariables vars = this.tdvars(context);
            vars.setDayOfWeek(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        return model;
    }

    private boolean checkLY(PreprocessingModel model) {
        boolean retval = true;
        ConcentratedLikelihood ll = model.estimation.getLikelihood();
        int start = model.description.getRegressionVariablesStartingPosition();
        TsVariableList x = model.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(ILengthOfPeriodVariable.class);
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        double[] Tstat = ll.getTStats(true, 2);
        double t = Tstat[start + items[items.length - 1].position];
        if (Math.abs(t) < this.tval_) {
            this.addLPInfo(model, t);
            retval = false;
        }
        return retval;
    }

    private boolean checkEE(PreprocessingModel model) {
        boolean retval = true;
        TsVariableList x = model.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(EasterVariable.class);
        if (sel.isEmpty()) {
            return false;
        }
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        Variable search = model.description.searchVariable((ITsVariable)items[items.length - 1].variable);
        if (search == null) {
            return false;
        }
        if (!search.status.needTesting()) {
            return true;
        }
        ConcentratedLikelihood ll = model.estimation.getLikelihood();
        int start = model.description.getRegressionVariablesStartingPosition();
        double[] Tstat = ll.getTStats(true, 2);
        double t = Tstat[start + items[items.length - 1].position];
        if (Math.abs(t) < 2.2) {
            this.addEasterInfo(model, t);
            retval = false;
        }
        return retval;
    }

    private GregorianCalendarVariables tdvars(ModellingContext context) {
        Optional<Variable> found = context.description.variables().filter(var -> var.getVariable() instanceof GregorianCalendarVariables).findAny();
        if (found.isPresent()) {
            GregorianCalendarVariables gv = (GregorianCalendarVariables)found.get().getVariable();
            return gv.clone();
        }
        return GregorianCalendarVariables.getDefault(TradingDaysType.None);
    }

    private void addLPInfo(PreprocessingModel model, double tstat) {
    }

    private void addEasterInfo(PreprocessingModel model, double tstat) {
    }

    private void addTDInfo(ModellingContext context, double pwd, double ptd, double pdel, int sel) {
    }
}

