/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.file;

import demetra.workspace.WorkspaceFamily;
import demetra.workspace.file.FamilyHandler;
import demetra.workspace.file.FileFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

final class SafeHandler {
    private final Map<WorkspaceFamily, FamilyHandler> handlerByFamily;

    SafeHandler(Map<WorkspaceFamily, FamilyHandler> handlerByFamily) {
        this.handlerByFamily = handlerByFamily;
    }

    private FamilyHandler get(WorkspaceFamily family) throws IOException {
        FamilyHandler result = this.handlerByFamily.get(family);
        if (result == null) {
            throw new IOException("Cannot handle family: " + family);
        }
        return result;
    }

    public Collection<WorkspaceFamily> getSupportedFamilies() throws IOException {
        return Collections.unmodifiableSet(this.handlerByFamily.keySet());
    }

    public Object loadValue(WorkspaceFamily family, Path rootFolder, String fileName) throws IOException {
        FamilyHandler handler = this.get(family);
        try {
            return handler.read(rootFolder, fileName);
        }
        catch (RuntimeException unexpected) {
            throw new IOException("Unexpected exception while loading " + fileName, unexpected);
        }
    }

    public void storeValue(WorkspaceFamily family, Path rootFolder, String fileName, Object value) throws IOException {
        FamilyHandler handler = this.get(family);
        try {
            handler.write(rootFolder, fileName, value);
        }
        catch (RuntimeException unexpected) {
            throw new IOException("Unexpected exception while storing " + fileName, unexpected);
        }
    }

    public void deleteValue(WorkspaceFamily family, Path rootFolder, String fileName) throws IOException {
        FamilyHandler handler = this.get(family);
        try {
            Files.delete(handler.resolveFile(rootFolder, fileName));
        }
        catch (RuntimeException unexpected) {
            throw new IOException("Unexpected exception while deleting " + fileName, unexpected);
        }
    }

    public Path resolveFile(WorkspaceFamily family, Path rootFolder, String fileName) throws IOException {
        FamilyHandler handler = this.get(family);
        try {
            return handler.resolveFile(rootFolder, fileName);
        }
        catch (RuntimeException unexpected) {
            throw new IOException("Unexpected exception while resolving file " + fileName, unexpected);
        }
    }

    public static SafeHandler create(Supplier<Iterable<FamilyHandler>> handlers, FileFormat format) throws IOException {
        try {
            HashMap<WorkspaceFamily, FamilyHandler> result = new HashMap<WorkspaceFamily, FamilyHandler>();
            handlers.get().forEach(o -> SafeHandler.pushHandler(result, format, o));
            return new SafeHandler(result);
        }
        catch (RuntimeException unexpected) {
            throw new IOException("Unexpected exception while opening workspace", unexpected);
        }
    }

    private static void pushHandler(Map<WorkspaceFamily, FamilyHandler> result, FileFormat requested, FamilyHandler o) {
        WorkspaceFamily family;
        FileFormat format = o.getFormat();
        if (format != null && requested.equals((Object)o.getFormat()) && (family = o.getFamily()) != null) {
            result.put(family, o);
        }
    }
}

