/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.io;

import demetra.workspace.io.IO;
import demetra.workspace.io.Jaxb;
import demetra.workspace.io.Xml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public final class JaxbUtil {
    @Nonnull
    public static Object unmarshal(@Nonnull Path file, @Nonnull JAXBContext context) throws JAXBException, IOException {
        try {
            return Jaxb.Parser.of(context).parsePath(file);
        }
        catch (Xml.WrappedException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw ex;
        }
    }

    @Nonnull
    public static Object unmarshal(@Nonnull Path file, @Nonnull Unmarshaller unmarshaller) throws JAXBException, IOException {
        try {
            return Jaxb.Parser.builder().factory(() -> unmarshaller).build().parsePath(file);
        }
        catch (Xml.WrappedException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw ex;
        }
    }

    public static void marshal(@Nonnull Path file, @Nonnull JAXBContext context, @Nonnull Object jaxbElement, boolean formatted) throws JAXBException, IOException {
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)formatted);
        JaxbUtil.marshal(file, marshaller, jaxbElement);
    }

    public static void marshal(@Nonnull Path file, @Nonnull Marshaller marshaller, @Nonnull Object jaxbElement) throws JAXBException, IOException {
        Optional<File> localFile = IO.getFile(file);
        if (localFile.isPresent()) {
            marshaller.marshal(jaxbElement, localFile.get());
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                marshaller.marshal(jaxbElement, (Writer)writer);
            }
        }
    }

    @Nonnull
    public static JAXBContext createContext(@Nonnull Class<?> type) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type});
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <X> void forSingle(@Nullable X item, @Nonnull Consumer<? super X> action) {
        Objects.requireNonNull(action, "action");
        if (item != null) {
            action.accept(item);
        }
    }

    public static <X> void forEach(@Nullable X[] array, @Nonnull Consumer<? super X> action) {
        Objects.requireNonNull(action, "action");
        if (array != null) {
            for (X o : array) {
                action.accept(o);
            }
        }
    }

    private JaxbUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

