% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x13_spec.R
\name{x13_spec_def}
\alias{x13_spec_def}
\alias{x13_spec}
\title{X-13ARIMA-SEATS model specification, SA/X13}
\usage{
x13_spec_def(spec = c("RSA5c", "RSA0", "RSA1", "RSA2c", "RSA3", "RSA4c",
  "X11"), estimate.from = NA_character_, estimate.to = NA_character_,
  estimate.first = NA_integer_, estimate.last = NA_integer_,
  estimate.exclFirst = NA_integer_, estimate.exclLast = NA_integer_,
  estimate.tol = NA_integer_, transform.function = c(NA, "Auto",
  "None", "Log"), transform.adjust = c(NA, "None", "LeapYear",
  "LengthOfPeriod"), transform.aicdiff = NA_integer_,
  usrdef.outliersEnabled = NA, usrdef.outliersType = NA,
  usrdef.outliersDate = NA, usrdef.outliersCoef = NA,
  usrdef.varEnabled = NA, usrdef.var = NA, usrdef.varType = NA,
  usrdef.varCoef = NA, tradingdays.option = c(NA, "TradingDays",
  "WorkingDays", "UserDefined", "None"), tradingdays.autoadjust = NA,
  tradingdays.leapyear = c(NA, "LeapYear", "LengthOfPeriod", "None"),
  tradingdays.stocktd = NA_integer_, tradingdays.test = c(NA, "Remove",
  "Add", "None"), easter.enabled = NA, easter.julian = NA,
  easter.duration = NA_integer_, easter.test = c(NA, "Add", "Remove",
  "None"), outlier.enabled = NA, outlier.from = NA_character_,
  outlier.to = NA_character_, outlier.first = NA_integer_,
  outlier.last = NA_integer_, outlier.exclFirst = NA_integer_,
  outlier.exclLast = NA_integer_, outlier.ao = NA, outlier.tc = NA,
  outlier.ls = NA, outlier.so = NA, outlier.usedefcv = NA,
  outlier.cv = NA_integer_, outlier.method = c(NA, "AddOne", "AddAll"),
  outlier.tcrate = NA_integer_, automdl.enabled = NA,
  automdl.acceptdefault = NA, automdl.cancel = NA_integer_,
  automdl.ub1 = NA_integer_, automdl.ub2 = NA_integer_,
  automdl.mixed = NA, automdl.balanced = NA,
  automdl.armalimit = NA_integer_, automdl.reducecv = NA_integer_,
  automdl.ljungboxlimit = NA_integer_, automdl.ubfinal = NA_integer_,
  arima.mu = NA, arima.p = NA_integer_, arima.d = NA_integer_,
  arima.q = NA_integer_, arima.bp = NA_integer_,
  arima.bd = NA_integer_, arima.bq = NA_integer_,
  arima.coefEnabled = NA, arima.coef = NA, arima.coefType = NA,
  fcst.horizon = NA_integer_, x11.mode = c(NA, "Undefined", "Additive",
  "Multiplicative", "LogAdditive", "PseudoAdditive"),
  x11.seasonalComp = NA, x11.lsigma = NA_integer_,
  x11.usigma = NA_integer_, x11.trendAuto = NA,
  x11.trendma = NA_integer_, x11.seasonalma = NA_character_,
  x11.fcasts = NA_integer_, x11.bcasts = NA_integer_,
  x11.excludeFcasts = NA)

x13_spec(object, estimate.from = NA_character_,
  estimate.to = NA_character_, estimate.first = NA_integer_,
  estimate.last = NA_integer_, estimate.exclFirst = NA_integer_,
  estimate.exclLast = NA_integer_, estimate.tol = NA_integer_,
  transform.function = c(NA, "Auto", "None", "Log"),
  transform.adjust = c(NA, "None", "LeapYear", "LengthOfPeriod"),
  transform.aicdiff = NA_integer_, usrdef.outliersEnabled = NA,
  usrdef.outliersType = NA, usrdef.outliersDate = NA,
  usrdef.outliersCoef = NA, usrdef.varEnabled = NA, usrdef.var = NA,
  usrdef.varType = NA, usrdef.varCoef = NA,
  tradingdays.option = c(NA, "TradingDays", "WorkingDays", "UserDefined",
  "None"), tradingdays.autoadjust = NA, tradingdays.leapyear = c(NA,
  "LeapYear", "LengthOfPeriod", "None"),
  tradingdays.stocktd = NA_integer_, tradingdays.test = c(NA, "Remove",
  "Add", "None"), easter.enabled = NA, easter.julian = NA,
  easter.duration = NA_integer_, easter.test = c(NA, "Add", "Remove",
  "None"), outlier.enabled = NA, outlier.from = NA_character_,
  outlier.to = NA_character_, outlier.first = NA_integer_,
  outlier.last = NA_integer_, outlier.exclFirst = NA_integer_,
  outlier.exclLast = NA_integer_, outlier.ao = NA, outlier.tc = NA,
  outlier.ls = NA, outlier.so = NA, outlier.usedefcv = NA,
  outlier.cv = NA_integer_, outlier.method = c(NA, "AddOne", "AddAll"),
  outlier.tcrate = NA_integer_, automdl.enabled = NA,
  automdl.acceptdefault = NA, automdl.cancel = NA_integer_,
  automdl.ub1 = NA_integer_, automdl.ub2 = NA_integer_,
  automdl.mixed = NA, automdl.balanced = NA,
  automdl.armalimit = NA_integer_, automdl.reducecv = NA_integer_,
  automdl.ljungboxlimit = NA_integer_, automdl.ubfinal = NA_integer_,
  arima.mu = NA, arima.p = NA_integer_, arima.d = NA_integer_,
  arima.q = NA_integer_, arima.bp = NA_integer_,
  arima.bd = NA_integer_, arima.bq = NA_integer_,
  arima.coefEnabled = NA, arima.coef = NA, arima.coefType = NA,
  fcst.horizon = NA_integer_, x11.mode = c(NA, "Undefined", "Additive",
  "Multiplicative", "LogAdditive", "PseudoAdditive"),
  x11.seasonalComp = NA, x11.lsigma = NA_integer_,
  x11.usigma = NA_integer_, x11.trendAuto = NA,
  x11.trendma = NA_integer_, x11.seasonalma = NA_character_,
  x11.fcasts = NA_integer_, x11.bcasts = NA_integer_,
  x11.excludeFcasts = NA)
}
\arguments{
\item{spec}{predefined 'JDemetra+' model specification (see Details). The default is "RSA5c".

The time span of the series to be used for the estimation of the RegArima model coefficients (default from 1900-01-01 to 2020-12-31) is controlled by the following six variables: \code{estimate.from, estimate.to, estimate.first, estimate.last, estimate.exclFirst} and \code{estimate.exclLast}; where \code{estimate.from} and \code{estimate.to} have priority over remaining span control variables, \code{estimate.last} and \code{estimate.first} have priority over \code{estimate.exclFirst} and \code{estimate.exclLast}, and \code{estimate.last} has priority over \code{estimate.first}.}

\item{estimate.from}{character in format "YYYY-MM-DD" indicating the start of the time span (e.g. "1900-01-01"). Can be combined with \code{estimate.to}.}

\item{estimate.to}{character in format "YYYY-MM-DD" indicating the end of the time span (e.g. "2020-12-31"). Can be combined with \code{estimate.from}.}

\item{estimate.first}{numeric specifying the number of periods considered at the beginning of the series.}

\item{estimate.last}{numeric specifying the number of periods considered at the end of the series.}

\item{estimate.exclFirst}{numeric specifying the number of periods excluded at the beginning of the series. Can be combined with \code{estimate.exclLast}.}

\item{estimate.exclLast}{numeric specifying the number of periods excluded at the end of the series. Can be combined with \code{estimate.exclFirst}.}

\item{estimate.tol}{numeric, convergence tolerance. The absolute changes in the log-likelihood function are compared to this value to check for the convergence of the estimation iterations.}

\item{transform.function}{transformation of the input series: \code{"None"} - no transformation of the series; \code{"Log"} - takes the log of the series; \code{"Auto"} - the program tests for the log-level specification.}

\item{transform.adjust}{pre-adjustment of the input series for length of period or leap year effects: \code{"None"} - no adjustment; \code{"LeapYear"} - leap year effect; \code{"LengthOfPeriod"} - length of period. Modifications of this variable are taken into account only when \code{transform.function} is set to \code{"Log"}.}

\item{transform.aicdiff}{numeric defining the difference in AICC needed to accept no transformation when the automatic transformation selection is chosen (considered only when \code{transform.function} is set to \code{"Auto"}).

Control variables for the pre-specified outliers. The pre-specified outliers are used in the model only if they are enabled (\code{usrdef.outliersEnabled=TRUE}) and the outliers' type (\code{usrdef.outliersType}) and date (\code{usrdef.outliersDate}) are provided.}

\item{usrdef.outliersEnabled}{logicals. If \code{TRUE} the program uses the pre-specified outliers.}

\item{usrdef.outliersType}{vector defining the outliers' type. Possible types are: \code{("AO")} - additive, \code{("LS")} - level shift, \code{("TC")} - transitory change, \code{("SO")} -  seasonal outlier. E.g.: \code{ usrdef.outliersType =c("AO","AO","LS")}.}

\item{usrdef.outliersDate}{vector defining the outliers' date. The dates should be characters in format "YYYY-MM-DD". E.g.: \code{usrdef.outliersDate=c("2009-10-01","2005-02-01","2003-04-01")}.}

\item{usrdef.outliersCoef}{vector providing fixed coefficients for the outliers. The coefficients can't be fixed if  \code{ transform.function} is set to \code{"Auto"} - the series transformation need to be pre-defined. E.g.: \code{ usrdef.outliersCoef=c(200,170,20)}.

Control variables for the user-defined variables:}

\item{usrdef.varEnabled}{logicals. If \code{TRUE} the program uses the user-defined variables.}

\item{usrdef.var}{time series (\code{ts}) or matrix of time series (\code{mts}) with the user-defined variables.}

\item{usrdef.varType}{vector of character(s) defining the user-defined variables component type. Possible types are: \code{"Undefined", "Series", "Trend", "Seasonal", "SeasonallyAdjusted", "Irregular"}. If not specified, the program will assign the \code{"Undefined"} type.}

\item{usrdef.varCoef}{vector providing fixed coefficients for the user-defined variables. The coefficients can't be fixed if  \code{ transform.function} is set to \code{"Auto"} - the series transformation need to be pre-defined.}

\item{tradingdays.option}{defines the type of the trading days regression variables: \code{"TradingDays"} -  six day-of-the-week regression variables; \code{"WorkingDays"} - one working/non-working day contrast variable; \code{"None"} - no correction for trading days and working days effects; \code{"UserDefined"} - user-defined trading days regressors (currently not working). \code{"None"} has also to be chosen for the "day-of-week effects" correction (\code{tradingdays.stocktd} to be modified accordingly).}

\item{tradingdays.autoadjust}{logicals. If \code{TRUE} the program corrects automatically for the leap year effect. Modifications of this variable are taken into account only when \code{transform.function} is set to \code{"Auto"}.}

\item{tradingdays.leapyear}{option for including the leap-year effect in the model: \code{"LeapYear"} - leap year effect; \code{"LengthOfPeriod"} - length of period, \code{"None"} - no effect included. The leap-year effect can be pre-specified in the model only if the input series was not pre-adjusted (\code{transform.adjust} set to \code{"None"}) and the automatic correction for the leap-year effect was not selected (\code{tradingdays.autoadjust} set to \code{FALSE}).}

\item{tradingdays.stocktd}{numeric indicating the day of the month when inventories and other stock are reported (to denote the last day of the month set the variable to 31). Modifications of this variable are taken into account only when \code{tradingdays.option} is set to \code{"None"}.}

\item{tradingdays.test}{defines the pre-tests for the significance of the trading day regression variables based on the AICC statistics: \code{"Add"} - the trading day variables are not included in the initial regression model but can be added to the RegARIMA model after the test; \code{"Remove"} - the trading day variables belong to the initial regression model but can be removed from the RegARIMA model after the test; \code{"None"} - the trading day variables are not pre-tested and are included in the model.}

\item{easter.enabled}{logicals. If \code{TRUE} the program considers the Easter effect in the model.}

\item{easter.julian}{logicals. If \code{TRUE} the program uses the Julian Easter (expressed in Gregorian calendar).}

\item{easter.duration}{numeric indicating the duration of the Easter effect (length in days, between 1 and 20).}

\item{easter.test}{defines the pre-tests for the significance of the Easter effect based on the t-statistic (Easter effect is considered as significant if the t-statistic is greater than 1.96): \code{"Add"} - the Easter effect variable is not included in the initial regression model but can be added to the RegARIMA model after the test; \code{"Remove"} - the Easter effect variable belong to the initial regression model but can be removed from the RegARIMA model after the test; \code{"None"} - the Easter effect variable is not pre-tested and is included in the model.}

\item{outlier.enabled}{logicals. If \code{TRUE} the automatic detection of outliers is enabled in the defined time span.

The time span of the series to be searched for outliers (default from 1900-01-01 to 2020-12-31) is controlled by the following six variables: \code{outlier.from, outlier.to, outlier.first, outlier.last, outlier.exclFirst} and \code{outlier.exclLast}; where \code{outlier.from} and \code{outlier.to} have priority over remaining span control variables, \code{outlier.last} and \code{outlier.first} have priority over \code{outlier.exclFirst} and \code{outlier.exclLast}, and \code{outlier.last} has priority over \code{outlier.first}.}

\item{outlier.from}{character in format "YYYY-MM-DD" indicating the start of the time span (e.g. "1900-01-01"). Can be combined with \code{outlier.to}.}

\item{outlier.to}{character in format "YYYY-MM-DD" indicating the end of the time span (e.g. "2020-12-31"). Can be combined with \code{outlier.from}.}

\item{outlier.first}{numeric specifying the number of periods considered at the beginning of the series.}

\item{outlier.last}{numeric specifying the number of periods considered at the end of the series.}

\item{outlier.exclFirst}{numeric specifying the number of periods excluded at the beginning of the series. Can be combined with \code{outlier.exclLast}.}

\item{outlier.exclLast}{numeric specifying the number of periods excluded at the end of the series. Can be combined with \code{outlier.exclFirst}.}

\item{outlier.ao}{logicals. If \code{TRUE} the automatic detection of additive outliers is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.tc}{logicals. If \code{TRUE} the automatic detection of transitory changes is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.ls}{logicals. If \code{TRUE} the automatic detection of level shifts is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.so}{logicals. If \code{TRUE} the automatic detection of seasonal outliers is enabled (\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.usedefcv}{logicals. If \code{TRUE} the critical value for the outliers' detection procedure is automatically determined by the number of observations in the outlier detection time span. If \code{FALSE} the procedure uses the inputted critical value (\code{outlier.cv}).}

\item{outlier.cv}{numeric. Inputted critical value for the outliers' detection procedure. The modification of this variable is taken into account only when \code{outlier.usedefcv} is set to \code{FALSE}.}

\item{outlier.method}{determines how the program successively adds detected outliers to the model. At present only the \code{AddOne} method is supported.}

\item{outlier.tcrate}{numeric. The rate of decay for the transitory change outlier.}

\item{automdl.enabled}{logicals. If \code{TRUE} the automatic modelling of the ARIMA model is enabled. If \code{FALSE} the parameters of the ARIMA model can be specified.

Control variables for the automatic modelling of the ARIMA model (\code{automdl.enabled} is set to \code{TRUE}):}

\item{automdl.acceptdefault}{logicals. If \code{TRUE} the default model (ARIMA(0,1,1)(0,1,1)) may be chosen in the first step of the automatic model identification. If the Ljung-Box Q statistics for the residuals is acceptable, the default model is accepted and no further attempt will be made to identify any other.}

\item{automdl.cancel}{numeric, cancelation limit. If the difference in moduli of an AR and an MA roots (when estimating ARIMA(1,0,1)(1,0,1) models in the second step of the automatic identification of the differencing orders) is smaller than cancelation limit, the two roots are assumed equal and cancel out.}

\item{automdl.ub1}{numeric, first unit root limit. It is the threshold value for the initial unit root test in the automatic differencing procedure. When one of the roots in the estimation of the ARIMA(2,0,0)(1,0,0) plus mean model, performed in the first step of the automatic model identification procedure, is larger than first unit root limit in modulus, it is set equal to unity.}

\item{automdl.ub2}{numeric, second unit root limit. When one of the roots in the estimation of the ARIMA(1,0,1)(1,0,1) plus mean model, which is performed in the second step of the automatic model identification procedure, is larger than second unit root limit in modulus, it is checked if there is a common factor in the corresponding AR and MA polynomials of the ARMA model that can be cancelled (see \code{automdl.cancel}). If there is no cancellation, the AR root is set equal to unity (i.e. the differencing order changes).}

\item{automdl.mixed}{logicals. The variable controls whether ARIMA models with non-seasonal AR and MA terms or seasonal AR and MA terms will be considered in the automatic model identification procedure. If \code{FALSE} a model with AR and MA terms in both the seasonal and non-seasonal parts of the model can be acceptable, provided there are not AR and MA terms in either the seasonal or non-seasonal.}

\item{automdl.balanced}{logicals. If \code{TRUE}, the automatic model identification procedure will have a preference for balanced models (i.e. models for which the order of the combined AR and differencing operator is equal to the order of the combined MA operator).}

\item{automdl.armalimit}{numeric, arma limit. It is the threshold value for t-statistics of ARMA coefficients and constant term used for the final test of model parsimony. If the highest order ARMA coefficient has a t-value less than this value in magnitude, the order of the model is reduced. Also if the constant term has a t-value less than arma limit in magnitude, it is removed from the set of regressors.}

\item{automdl.reducecv}{numeric, ReduceCV.  The percentage by which the outlier's critical value will be reduced when an identified model is found to have a Ljung-Box statistic with an unacceptable confidence coefficient. The parameter should be between 0 and 1, and will only be active when automatic outlier identification is enabled. The reduced critical value will be set to (1-ReduceCV)xCV, where CV is the original critical value.}

\item{automdl.ljungboxlimit}{numeric, Ljung Box limit. Acceptance criterion for the confidence intervals of the Ljung-Box Q statistic. If the LjungBox Q statistics for the residuals of a final model is greater than Ljung Box limit, the model is rejected, the outlier critical value is reduced, and model and outlier identification (if specified) is redone with a reduced value.}

\item{automdl.ubfinal}{numeric, final unit root limit. The threshold value for the final unit root test. If the magnitude of an AR root for the final model is less than the final unit root limit, a unit root is assumed, the order of the AR polynomial is reduced by one, and the appropriate order of the differencing (non-seasonal, seasonal) is increased. The parameter value should be greater than one.

Control variables for the non-automatic modelling of the ARIMA model (\code{automdl.enabled} is set to \code{FALSE}):}

\item{arima.mu}{logicals. If \code{TRUE}, the mean is considered as part of the ARIMA model.}

\item{arima.p}{numeric. The order of the non-seasonal autoregressive (AR) polynomial.}

\item{arima.d}{numeric. Regular differencing order.}

\item{arima.q}{numeric. The order of the non-seasonal moving average (MA) polynomial.}

\item{arima.bp}{numeric. The order of the seasonal autoregressive (AR) polynomial.}

\item{arima.bd}{numeric. Seasonal differencing order.}

\item{arima.bq}{numeric. The order of the seasonal moving average (MA) polynomial.

Control variables for the user-defined ARMA coefficients. Coefficients can be defined for the regular and seasonal autoregressive (AR) polynomials and moving average (MA) polynomials. The model considers the coefficients only if the procedure for their estimation (\code{arima.coefType}) is provided, and the number of provided coefficients matches the sum of (regular and seasonal) AR and MA orders (\code{p,q,bp,bq}).}

\item{arima.coefEnabled}{logicals. If \code{TRUE} the program uses the user-defined ARMA coefficients.}

\item{arima.coef}{vector providing the coefficients for the regular and seasonal AR and MA polynominals. The length of the vector must equal the sum of the regular and seasonal AR and MA orders. The coefficients shall be provided in the order: regular AR (\emph{Phi} - \code{p} elements), regular MA  (\emph{Theta} - \code{q} elements), seasonal AR (\emph{BPhi} - \code{bp} elements) and seasonal MA (\emph{BTheta} - \code{bq} elements). E.g.: \code{arima.coef=c(0.6,0.7)} with \code{arima.p=1, arima.q=0,arima.bp=1} and \code{arima.bq=0}.}

\item{arima.coefType}{vector defining ARMA coefficients estimation procedure. Possible procedures are: \code{"Undefined"} - no use of user-defined input (i.e. coefficients are estimated), \code{"Fixed"} - fixes the coefficients at the value provided by the user, \code{"Initial"} - the value defined by the user is used as initial condition. For orders for which the coefficients shall not be defined, the \code{arima.coef} can be set to \code{NA} or \code{0} or the \code{arima.coefType} can be set to \code{"Undefined"}.
E.g.: \code{arima.coef = c(-0.8,-0.6,NA)}, \code{arima.coefType = c("Fixed","Fixed","Undefined")}.}

\item{fcst.horizon}{numeric, forecasts horizon. Length of the forecasts generated by the RegARIMA model in periods (positive values) or years (negative values). By default the program generates two years forecasts (\code{fcst.horizon} set to \code{-2}).}

\item{x11.mode}{character, decomposition mode. Determines the mode of the seasonal adjustment decomposition to be performed: \code{"Undefined"} - no assumption concerning the relationship between the time series components is made; \code{"Additive"} - assumes an additive relationship; \code{"Multiplicative"} - assumes a multiplicative relationship; \code{"LogAdditive"} - performs an additive decomposition of the logarithms of the series being adjusted; \code{"PseudoAdditive"} - assumes an pseudo-additive relationship. Could be changed by the program, if needed.}

\item{x11.seasonalComp}{logicals. If \code{TRUE} the program computes a seasonal component. Otherwise, the seasonal component is not estimated and its values are all set to 0 (additive decomposition) or 1 (multiplicative decomposition).}

\item{x11.lsigma}{numeric, lower sigma boundary for the detection of extreme values.}

\item{x11.usigma}{numeric, upper sigma boundary for the detection of extreme values.}

\item{x11.trendAuto}{logicals, automatic Henderson filter. If \code{TRUE} an automatic selection of the Henderson filter's length for the trend estimation is enabled.}

\item{x11.trendma}{numeric, length of the Henderson filter. The user-defined length of the Henderson filter. The option is available when the automatic Henderson filter selection is disabled (\code{x11.trendAuto=FALSE}). Should be an odd number in the range (1, 101].}

\item{x11.seasonalma}{vector of character(s) specifying which seasonal moving average (i.e. seasonal filter) will be used to estimate the seasonal factors for the entire series. The vector can be of length: 1 - same seasonal filters for all periods (e.g.: \code{seasonalma=c("Msr")}); or period's number - a seasonal filer is defined for each period (e.g. for quarterly series: \code{seasonalma=c("S3X3","Msr","S3X3","Msr")}). Possible filters are: \code{"Msr", "Stable", "X11Default", "S3X1", "S3X3", "S3X5", "S3X9", "S3X15"}. \code{"Msr"} - the program chooses the final seasonal filter automatically.}

\item{x11.fcasts}{numeric, RegARIMA forecast. Length of the forecasts generated by the RegARIMA model in periods (positive values) or years (negative values).}

\item{x11.bcasts}{numeric, backcast. Length of the backcasts used in X11. Negative figures are translated in years of backcasts.}

\item{x11.excludeFcasts}{logicals, exclude forecats and backcasts. If \code{TRUE} forecasts and backcasts from the RegARIMA model are not used in the generation of extreme values in the seasonal adjustment routines.}

\item{object}{model specification, object of class \code{c("SA_spec","X13")} or \code{c("SA","X13")}.}
}
\value{
A two-elements list of class \code{c("SA_spec", "X13")}: (1) object of class \code{c("regarima_spec", "X13")} with the RegARIMA model specification, (2) object of class \code{c("X11_spec", "data.frame")} with the X11 algorithm specification.
Each component refers to different part of the SA model specification, mirroring the arguments of the function (for details see arguments description).
Each of the lowest-level component (except span, pre-specified outliers, user-defined variables and pre-specified ARMA coefficients) is structured within a data frame with columns denoting different variables of the model specification and rows referring to: first row - base specification, as provided within the argument \code{spec} or \code{object}; second row - user modifications as specified by the remaining arguments of the function (e.g.: \code{arima.d}); and third row - final model specification.
The final specification (third row) shall include user modifications (row two) unless they were wrongly specified. The pre-specified outliers, user-defined variables and pre-specified ARMA coefficients consist of a list with the \code{Predefined} (base model specification) and \code{Final} values.

\item{regarima}{object of class \code{c("regarima_spec", "x13")}. See \emph{Value} of the function \code{\link{regarima_spec_x13}}}

\item{x11}{data.frame of class \code{c("X11_spec", "data.frame")}, containing the \emph{x11} variables in line with the names of the arguments variables. The final values can be also accessed with the function \code{\link{s_x11}}.}
}
\description{
\code{x13_spec_def} creates (and modifies), from a predefined 'JDemetra+' model specification, a \code{c("SA_spec", "X13")} class object with the SA model specification for the X13 method.

\code{x13_spec} creates (and/or modifies) a \code{c("SA_spec", "X13")} class object with the SA model specification for the X13 method. The object is created from a \code{c("SA", "X13")} or \code{c("SA_spec", "X13")} class object.
}
\details{
The available predefined 'JDemetra+' model specifications (for the function \code{x13_spec_def}) are described in the table below.

\tabular{rrrrrrr}{
\strong{Identifier} |\tab \strong{Log/level detection} |\tab \strong{Outliers detection} |\tab \strong{Calender effects} |\tab \strong{ARIMA}\cr
RSA0 |\tab \emph{NA} |\tab \emph{NA} |\tab \emph{NA} |\tab Airline(+mean)\cr
RSA1 |\tab automatic |\tab AO/LS/TC  |\tab \emph{NA} |\tab Airline(+mean)\cr
RSA2c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab Airline(+mean)\cr
RSA3 |\tab automatic |\tab AO/LS/TC |\tab \emph{NA} |\tab automatic\cr
RSA4c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab automatic\cr
RSA5c |\tab automatic |\tab AO/LS/TC |\tab 7 td vars + Easter |\tab automatic
}
}
\examples{
\donttest{
myseries <- ipi_c_eu[, "FR"]
myspec1 <- x13_spec_def(spec = "RSA5c")
myreg1 <- x13(myseries, spec = myspec1)

# Modify a pre-specified model specification
myspec2 <- x13_spec_def(spec = "RSA5c", tradingdays.option = "WorkingDays")
myreg2 <- x13(myseries, spec = myspec2)

# Modify the model specification from a "X13" object
 myspec3 <- x13_spec(myreg1, tradingdays.option = "WorkingDays")
 myreg3 <- x13(myseries, myspec3)

# Modify the model specification from a "X13_spec" object
 myspec4 <- x13_spec(myspec1, tradingdays.option = "WorkingDays")
 myreg4 <- x13(myseries, myspec4)

# Pre-specified outliers
 myspec1 <- x13_spec_def(spec = "RSA5c", usrdef.outliersEnabled = TRUE,
             usrdef.outliersType = c("LS", "AO"),
             usrdef.outliersDate = c("2008-10-01", "2002-01-01"),
             usrdef.outliersCoef = c(36, 14),
             transform.function = "None")

 myreg1 <- x13(myseries, myspec1)
 myreg1
 s_preOut(myreg1)


# User-defined variables
 var1 <- ts(rnorm(length(myseries))*10, start = start(myseries), frequency = 12)
 var2 <- ts(rnorm(length(myseries))*100, start = start(myseries), frequency = 12)
 var <- ts.union(var1, var2)
 myspec1 <- x13_spec_def(spec = "RSA5c", usrdef.varEnabled = TRUE,
                         usrdef.var = var)
 myreg1 <- x13(myseries, myspec1)
 myreg1

 myspec2 <- x13_spec_def(spec = "RSA5c", usrdef.varEnabled = TRUE,
             usrdef.var = var1, usrdef.varCoef = c(2),
             transform.function = "None")
 myreg2 <- x13(myseries, myspec2)
 s_preVar(myreg2)

# Pre-specified ARMA coefficients
 myspec1 <- x13_spec_def(spec = "RSA5c", automdl.enabled = FALSE,
             arima.p = 1, arima.q = 1, arima.bp = 0, arima.bq = 1,
             arima.coefEnabled = TRUE,
             arima.coef = c(-0.8, -0.6, 0),
             arima.coefType = c(rep("Fixed", 2), "Undefined"))

 s_arimaCoef(myspec1)
 myreg1 <- x13(myseries, myspec1)
 myreg1

# Defined seasonal filters
 myspec1 <- x13_spec_def("RSA5c", x11.seasonalma = rep("S3X1", 12))
 mysa1 <- x13(myseries, myspec1)
}
}
\references{
Info on 'JDemetra+', usage and functions:
\url{https://ec.europa.eu/eurostat/cros/content/documentation_en}
BOX G.E.P. and JENKINS G.M. (1970), "Time Series Analysis: Forecasting and Control", Holden-Day, San Francisco.

BOX G.E.P., JENKINS G.M., REINSEL G.C. and LJUNG G.M. (2015), "Time Series Analysis: Forecasting and Control", John Wiley & Sons, Hoboken, N. J., 5th edition.
}
\seealso{
\code{\link{x13}}
}
