/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace;

import demetra.workspace.WorkspaceFamily;
import demetra.workspace.WorkspaceItem;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;

public interface Workspace
extends Closeable {
    @Nonnull
    public String getName() throws IOException;

    public void setName(@Nonnull String var1) throws IOException;

    @Nonnull
    public Collection<WorkspaceFamily> getSupportedFamilies() throws IOException;

    @Nonnull
    public Collection<WorkspaceItem> getItems() throws IOException;

    @Nonnull
    public Object load(@Nonnull WorkspaceItem var1) throws IOException;

    public void store(@Nonnull WorkspaceItem var1, @Nonnull Object var2) throws IOException;

    public void delete(@Nonnull WorkspaceItem var1) throws IOException;

    default public void copyTo(@Nonnull Workspace target) throws IOException {
        target.setName(this.getName());
        Collection<WorkspaceFamily> families = target.getSupportedFamilies();
        for (WorkspaceItem o : this.getItems()) {
            if (!families.contains(o.getFamily())) continue;
            target.store(o, this.load(o));
        }
    }
}

