/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.modelling.arima.AbstractModelController;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.ModelComparator;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class SeasonalUnderDifferencingTest
extends AbstractModelController {
    private static final double DEF_SBOUND = 0.91;

    @Override
    public ProcessingResult process(ModellingContext context) {
        if (context.description.getFrequency() == 1) {
            return ProcessingResult.Unprocessed;
        }
        if (this.fixSeasonalRoots(context)) {
            return ProcessingResult.Changed;
        }
        if (!this.isUnderDiff(context)) {
            return ProcessingResult.Unchanged;
        }
        ModellingContext scontext = this.buildNewModel(context);
        PreprocessingModel smodel = scontext.tmpModel();
        if (smodel == null) {
            return ProcessingResult.Failed;
        }
        if (new ModelComparator().compare(smodel, context.tmpModel()) < 0) {
            this.transferInformation(scontext, context);
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    private boolean isUnderDiff(ModellingContext context) {
        SeasonalityTests tests = SeasonalityTests.residualSeasonalityTest(context.estimation.getLikelihood().getResiduals(), TsFrequency.valueOf(context.description.getFrequency()));
        return tests.getScore() > 1 || tests.getScore() == 1 && context.hasseas;
    }

    private ModellingContext buildNewModel(ModellingContext context) {
        ModellingContext ncontext = new ModellingContext();
        ModelDescription ndesc = context.description.clone();
        SarimaSpecification spec = ndesc.getSpecification();
        spec.setBP(0);
        spec.setBD(1);
        spec.setBQ(1);
        ndesc.setSpecification(spec);
        ndesc.setMean(false);
        ncontext.description = ndesc;
        if (!this.estimate(ncontext, false)) {
            return null;
        }
        return ncontext;
    }

    private boolean fixSeasonalRoots(ModellingContext context) {
        SarimaModel model = context.estimation.getRegArima().getArima();
        SarimaSpecification spec = model.getSpecification();
        if (spec.getBD() != 0 || spec.getBP() != 1 || model.bphi(1) >= -0.91) {
            return false;
        }
        spec.setBP(0);
        spec.setBD(1);
        spec.setBQ(1);
        ModellingContext ncontext = new ModellingContext();
        ModelDescription ndesc = context.description.clone();
        ndesc.setSpecification(spec);
        ndesc.setMean(false);
        ncontext.description = ndesc;
        if (!this.estimate(ncontext, false)) {
            return false;
        }
        this.transferInformation(ncontext, context);
        return true;
    }
}

