/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.IEasterVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class JulianEasterVariable
extends AbstractSingleTsVariable
implements IEasterVariable {
    private static final int CYCLE = 532;
    private static final int[] C_MAR = new int[]{0, 0, 0, 4, 16, 36, 68, 116, 180, 264, 364, 480, 616, 768, 936, 1124, 1328, 1552, 1796, 2056, 2336, 2632, 2944, 3276, 3624, 3988, 4372, 4772};
    private static final int[] C_APR = new int[]{452, 924, 1412, 1908, 2408, 2908, 3404, 3888, 4356, 4804, 5236, 5652, 6048, 6428, 6792, 7136, 7464, 7772, 8060, 8332, 8584, 8820, 9040, 9240, 9424, 9592, 9740, 9872};
    private static final int[] C_MAY = new int[]{80, 140, 184, 216, 236, 248, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252};
    private static final int TWOCYCLE = 1064;
    private static final int[] C_MAR2 = new int[]{1, 3, 8, 22, 51, 91, 145, 226, 343, 488, 657, 858, 1099, 1379, 1692, 2036, 2414, 2828, 3284, 3779, 4307, 4866, 5458, 6092, 6764, 7469, 8204, 8971};
    private static final int[] C_APR2 = new int[]{878, 1784, 2713, 3664, 4633, 5613, 6586, 7547, 8484, 9400, 10293, 11155, 11978, 12762, 13513, 14233, 14919, 15569, 16177, 16746, 17282, 17787, 18259, 18689, 19081, 19440, 19769, 20066};
    private static final int[] C_MAY2 = new int[]{185, 341, 471, 570, 636, 680, 717, 739, 749, 752, 754, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755};
    private int dur_ = 6;
    private boolean m_gc = true;

    @Override
    public int getDuration() {
        return this.dur_;
    }

    @Override
    public void setDuration(int value) {
        if (value <= 0 || value >= 29) {
            throw new IllegalArgumentException();
        }
        this.dur_ = value;
    }

    public boolean isGregorianDate() {
        return this.m_gc;
    }

    public void setGregorianDate(boolean gc) {
        this.m_gc = gc;
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Julian Easter [").append(this.dur_).append(']');
        return builder.toString();
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        data.set(0.0);
        int freq = start.getFrequency().intValue();
        if (freq < 3) {
            return;
        }
        double q = 1064 * this.dur_;
        int n = data.getLength();
        int y = start.getYear();
        TsPeriod march = new TsPeriod(TsFrequency.Monthly, y, 2);
        TsPeriod april = new TsPeriod(TsFrequency.Monthly, y, 3);
        TsPeriod may = new TsPeriod(TsFrequency.Monthly, y, 4);
        Day beg = start.firstday();
        Day end = start.plus(n).lastday();
        while (true) {
            Day easter;
            if (beg.isBefore(easter = Utilities.julianEaster3(y, this.m_gc))) {
                int n2;
                Day pbeg = easter.minus(this.dur_);
                int n0 = march.lastday().difference(pbeg) + 1;
                if (n0 < 0) {
                    n0 = 0;
                }
                if ((n2 = easter.difference(may.firstday())) < 0) {
                    n2 = 0;
                } else if (n2 > this.dur_) {
                    n2 = this.dur_;
                }
                int n1 = this.dur_ - n0 - n2;
                double dur = this.dur_;
                TsPeriod cur = new TsPeriod(start.getFrequency(), march);
                int ipos = cur.minus(start);
                if (ipos >= 0 && ipos < n) {
                    data.add(ipos, (double)n0 / dur - (double)C_MAR2[this.dur_ - 1] / q);
                }
                if ((ipos = (cur = new TsPeriod(start.getFrequency(), april)).minus(start)) >= 0 && ipos < n) {
                    data.add(ipos, (double)n1 / dur - (double)C_APR2[this.dur_ - 1] / q);
                }
                if ((ipos = (cur = new TsPeriod(start.getFrequency(), may)).minus(start)) >= 0 && ipos < n) {
                    data.add(ipos, (double)n2 / dur - (double)C_MAY2[this.dur_ - 1] / q);
                }
            }
            march.move(12);
            if (march.isAfter(end)) break;
            april.move(12);
            may.move(12);
            ++y;
        }
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return domain.getFrequency().intValue() > 2;
    }
}

