/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.algorithm.implementation;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.GenericSaProcessingFactory;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.benchmarking.SaBenchmarkingResults;
import ec.satoolkit.benchmarking.SaBenchmarkingSpec;
import ec.satoolkit.special.StmDecomposition;
import ec.satoolkit.special.StmEstimation;
import ec.satoolkit.special.StmSpecification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DeterministicComponent;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.Method;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.structural.BsmMonitor;
import ec.tstoolkit.structural.BsmSpecification;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@Deprecated
public class StmProcessingFactory
extends GenericSaProcessingFactory
implements IProcessingFactory<StmSpecification, TsData, CompositeResults> {
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Seasonal adjustment", "Structural model", null);
    public static final String ESTIMATION = "estimation";
    public static final String DETERMINISTIC = "deterministic";
    public static final StmProcessingFactory instance = new StmProcessingFactory();

    private static SequentialProcessing<TsData> create(StmSpecification xspec, ProcessingContext context) {
        SequentialProcessing<TsData> processing = new SequentialProcessing<TsData>();
        if (xspec.getPreprocessingSpec().method != Method.None) {
            StmProcessingFactory.addPreprocessingStep(xspec.buildPreprocessor(context), processing);
        }
        StmProcessingFactory.addEstimationStep(xspec.getDecompositionSpec(), processing);
        StmProcessingFactory.addDeterministicStep(processing);
        StmProcessingFactory.addDecompositionStep(processing);
        StmProcessingFactory.addFinalStep(processing);
        SaBenchmarkingSpec bspec = xspec.getBenchmarkingSpec();
        if (bspec != null && bspec.isEnabled()) {
            StmProcessingFactory.addBenchmarkingStep(bspec, processing);
        }
        return processing;
    }

    protected static void addPreprocessingStep(IPreprocessor preprocessor, SequentialProcessing sproc) {
        sproc.add(StmProcessingFactory.createPreprocessingStep(preprocessor, -2, "preprocessing", "preprocessing"));
    }

    protected StmProcessingFactory() {
    }

    public static CompositeResults process(TsData s, StmSpecification xspec) {
        SequentialProcessing<TsData> processing = StmProcessingFactory.create(xspec, null);
        return processing.process((Object)s);
    }

    public SequentialProcessing<TsData> generateProcessing(StmSpecification xspec, ProcessingContext context) {
        return StmProcessingFactory.create(xspec, context);
    }

    public SequentialProcessing<TsData> generateProcessing(StmSpecification xspec) {
        return StmProcessingFactory.create(xspec, null);
    }

    @Override
    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof StmSpecification;
    }

    @Override
    public Map<String, Class> getSpecificationDictionary(Class<StmSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        StmSpecification.fillDictionary(null, dic);
        return dic;
    }

    @Override
    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        PreprocessingModel.fillDictionary(null, dic, compact);
        DefaultSeriesDecomposition.fillDictionary(null, dic, compact);
        SaBenchmarkingResults.fillDictionary("benchmarking", dic, compact);
        return dic;
    }

    private static void addEstimationStep(BsmSpecification decompositionSpec, SequentialProcessing processing) {
        processing.add(StmProcessingFactory.createEstimationStep(decompositionSpec));
    }

    protected static <S extends IProcSpecification> IProcessingNode<TsData> createEstimationStep(final BsmSpecification decompositionSpec) {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return StmProcessingFactory.ESTIMATION;
            }

            @Override
            public String getPrefix() {
                return StmProcessingFactory.ESTIMATION;
            }

            @Override
            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                PreprocessingModel model = StmProcessingFactory.model(results);
                StmEstimation estimation = null;
                BsmMonitor monitor = new BsmMonitor();
                monitor.setSpecification(decompositionSpec);
                if (model == null) {
                    if (monitor.process(input.internalStorage(), input.getFrequency().intValue())) {
                        estimation = new StmEstimation(input, new TsVariableList(), monitor);
                    }
                } else {
                    TsData y = model.description.transformedOriginal();
                    TsVariableList x = model.description.buildRegressionVariables();
                    if (x.isEmpty()) {
                        if (monitor.process(y.internalStorage(), input.getFrequency().intValue())) {
                            estimation = new StmEstimation(y, x, monitor);
                        }
                    } else {
                        Matrix mx = x.all().matrix(y.getDomain());
                        if (monitor.process(y.internalStorage(), mx.subMatrix(), y.getFrequency().intValue())) {
                            estimation = new StmEstimation(y, x, monitor);
                        }
                    }
                }
                if (estimation == null) {
                    return IProcessing.Status.Invalid;
                }
                results.put(StmProcessingFactory.ESTIMATION, estimation);
                return IProcessing.Status.Valid;
            }
        };
    }

    private static void addDeterministicStep(SequentialProcessing processing) {
        processing.add(StmProcessingFactory.createDeterministicStep());
    }

    protected static <S extends IProcSpecification> IProcessingNode<TsData> createDeterministicStep() {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return StmProcessingFactory.DETERMINISTIC;
            }

            @Override
            public String getPrefix() {
                return null;
            }

            @Override
            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                PreprocessingModel model = StmProcessingFactory.model(results);
                if (model == null) {
                    return IProcessing.Status.Unprocessed;
                }
                StmEstimation estimation = StmProcessingFactory.estimation(results);
                if (estimation == null) {
                    return IProcessing.Status.Invalid;
                }
                DeterministicComponent det = model.getDeterministicComponent();
                det.setCoefficients(new ReadDataBlock(estimation.getLikelihood().getB()));
                results.put(StmProcessingFactory.DETERMINISTIC, det);
                return IProcessing.Status.Valid;
            }
        };
    }

    private static void addDecompositionStep(SequentialProcessing processing) {
        processing.add(StmProcessingFactory.createDecompositionStep());
    }

    protected static <S extends IProcSpecification> IProcessingNode<TsData> createDecompositionStep() {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return "decomposition";
            }

            @Override
            public String getPrefix() {
                return "decomposition";
            }

            @Override
            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                boolean mul;
                TsData y;
                StmEstimation e = StmProcessingFactory.estimation(results);
                if (e == null) {
                    return IProcessing.Status.Unprocessed;
                }
                DeterministicComponent det = StmProcessingFactory.deterministic(results);
                if (det == null) {
                    y = input;
                    mul = false;
                } else {
                    y = det.linearizedSeries();
                    mul = det.isMultiplicative();
                }
                StmDecomposition decomposition = new StmDecomposition(y, e.getModel(), mul);
                results.put("decomposition", decomposition);
                return IProcessing.Status.Valid;
            }
        };
    }

    private static void addFinalStep(SequentialProcessing processing) {
        processing.add(StmProcessingFactory.createFinalStep());
    }

    protected static <S extends IProcSpecification> IProcessingNode<TsData> createFinalStep() {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return "final";
            }

            @Override
            public String getPrefix() {
                return null;
            }

            @Override
            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                TsData detY;
                TsData detI;
                ISaResults decomp = StmProcessingFactory.decomposition(results);
                ISeriesDecomposition ldecomp = decomp.getSeriesDecomposition();
                DeterministicComponent det = StmProcessingFactory.deterministic(results);
                if (det == null) {
                    DefaultSeriesDecomposition finals = new DefaultSeriesDecomposition(decomp.getSeriesDecomposition().getMode());
                    TsDomain domain = input.getDomain();
                    TsData fy = ldecomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
                    TsDomain fdomain = fy == null ? null : fy.getDomain();
                    finals.add(input, ComponentType.Series);
                    TsData t = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Value);
                    if (t != null && !domain.equals(t.getDomain())) {
                        t = t.fittoDomain(domain);
                    }
                    finals.add(t, ComponentType.Trend);
                    TsData s = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
                    if (s != null && !domain.equals(s.getDomain())) {
                        s = s.fittoDomain(domain);
                    }
                    finals.add(s, ComponentType.Seasonal);
                    TsData i = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Value);
                    if (i != null && !domain.equals(i.getDomain())) {
                        i = i.fittoDomain(domain);
                    }
                    finals.add(i, ComponentType.Irregular);
                    TsData sa = ldecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
                    if (sa != null && !domain.equals(sa.getDomain())) {
                        sa = sa.fittoDomain(domain);
                    }
                    finals.add(sa, ComponentType.SeasonallyAdjusted);
                    if (fdomain != null) {
                        TsData fsa;
                        TsData fs;
                        finals.add(fy, ComponentType.Series, ComponentInformation.Forecast);
                        TsData ft = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast);
                        if (ft != null) {
                            if (!fdomain.equals(ft.getDomain())) {
                                ft = ft.fittoDomain(fdomain);
                            }
                            finals.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
                        }
                        if ((fs = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast)) != null) {
                            if (!fdomain.equals(fs.getDomain())) {
                                fs = fs.fittoDomain(fdomain);
                            }
                            finals.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
                        }
                        if ((fsa = ldecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast)) != null) {
                            if (!fdomain.equals(fsa.getDomain())) {
                                fsa = fsa.fittoDomain(fdomain);
                            }
                            finals.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
                        }
                    }
                    results.put("final", finals);
                    return IProcessing.Status.Valid;
                }
                boolean mul = ldecomp.getMode() != DecompositionMode.Additive;
                TsDomain domain = input.getDomain();
                TsData fdata = ldecomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
                TsDomain fdomain = fdata == null ? null : fdata.getDomain();
                TsDomain cdomain = fdomain == null ? domain : domain.union(fdomain);
                TsData detT = det.deterministicEffect(cdomain, ComponentType.Trend);
                if (detT != null) {
                    det.backTransform(detT, true, false);
                }
                TsData detS = det.deterministicEffect(cdomain, ComponentType.Seasonal);
                TsData detC = det.deterministicEffect(cdomain, ComponentType.CalendarEffect);
                if (detS != null || detC != null) {
                    detS = StmProcessingFactory.op(false, detS, detC);
                    det.backTransform(detS, false, true);
                }
                if ((detI = det.deterministicEffect(cdomain, ComponentType.Irregular)) != null) {
                    det.backTransform(detI, false, false);
                }
                if ((detY = det.deterministicEffect(cdomain, ComponentType.Series)) != null) {
                    det.backTransform(detY, false, false);
                }
                DefaultSeriesDecomposition finals = new DefaultSeriesDecomposition(ldecomp.getMode());
                TsData y = StmProcessingFactory.inv_op(mul, input, detY);
                finals.add(y, ComponentType.Series);
                TsData t = StmProcessingFactory.op(mul, detT, ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Value));
                if (t != null && !domain.equals(t.getDomain())) {
                    t = t.fittoDomain(domain);
                }
                finals.add(t, ComponentType.Trend);
                TsData s = StmProcessingFactory.op(mul, detS, ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
                if (s != null && !domain.equals(s.getDomain())) {
                    s = s.fittoDomain(domain);
                }
                finals.add(s, ComponentType.Seasonal);
                TsData i = StmProcessingFactory.op(mul, detI, ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Value));
                if (i != null && !domain.equals(i.getDomain())) {
                    i = i.fittoDomain(domain);
                }
                finals.add(i, ComponentType.Irregular);
                finals.add(StmProcessingFactory.inv_op(mul, y, s), ComponentType.SeasonallyAdjusted);
                TsData ndet = StmProcessingFactory.op(mul, detT, detS);
                ndet = StmProcessingFactory.op(mul, ndet, detI);
                if (fdomain != null) {
                    TsData fsa;
                    TsData fil;
                    TsData fy = StmProcessingFactory.op(mul, fdata, ndet);
                    finals.add(fy, ComponentType.Series, ComponentInformation.Forecast);
                    TsData ftl = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast);
                    if (ftl != null) {
                        TsData ft = StmProcessingFactory.op(mul, detT, ftl);
                        if (!fdomain.equals(ft.getDomain())) {
                            ft = ft.fittoDomain(fdomain);
                        }
                        finals.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
                    }
                    TsData fsl = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast);
                    TsData fs = null;
                    if (fsl != null) {
                        fs = StmProcessingFactory.op(mul, detS, fsl);
                        if (!fdomain.equals(fs.getDomain())) {
                            fs = fs.fittoDomain(fdomain);
                        }
                        finals.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
                    }
                    if ((fil = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Forecast)) != null) {
                        TsData fi = StmProcessingFactory.op(mul, detI, fil);
                        if (!fdomain.equals(fi.getDomain())) {
                            fi = fi.fittoDomain(fdomain);
                        }
                        finals.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
                    }
                    if ((fsa = StmProcessingFactory.inv_op(mul, fy, fs)) != null) {
                        if (!fdomain.equals(fsa.getDomain())) {
                            fsa = fsa.fittoDomain(fdomain);
                        }
                        finals.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
                    }
                }
                results.put("final", finals);
                return IProcessing.Status.Valid;
            }
        };
    }

    protected static StmEstimation estimation(Map<String, IProcResults> results) {
        IProcResults imodel = results.get(ESTIMATION);
        if (imodel == null || !(imodel instanceof StmEstimation)) {
            return null;
        }
        return (StmEstimation)imodel;
    }

    protected static DeterministicComponent deterministic(Map<String, IProcResults> results) {
        IProcResults imodel = results.get(DETERMINISTIC);
        if (imodel == null || !(imodel instanceof DeterministicComponent)) {
            return null;
        }
        return (DeterministicComponent)imodel;
    }
}

