/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.IRationalFilter;
import ec.tstoolkit.maths.linearfilters.RationalForeFilter;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;

public class RationalBackFilter
implements IRationalFilter {
    private final RationalFunction m_rfe;

    public RationalBackFilter() {
        this.m_rfe = new RationalFunction();
    }

    public RationalBackFilter(BackFilter num, BackFilter denom) {
        this.m_rfe = new RationalFunction(num.getPolynomial(), denom.getPolynomial());
    }

    RationalBackFilter(RationalFunction rfe) {
        this.m_rfe = rfe;
    }

    public RationalBackFilter drop(int nterms) {
        RationalFunction rfe = this.m_rfe.drop(nterms);
        return new RationalBackFilter(rfe);
    }

    @Override
    public Complex frequencyResponse(double freq) {
        Complex n = Utilities.frequencyResponse(this.m_rfe.getNumerator().getCoefficients(), 0, -freq);
        Complex d = Utilities.frequencyResponse(this.m_rfe.getDenominator().getCoefficients(), 0, -freq);
        return n.div(d);
    }

    @Override
    public BackFilter getDenominator() {
        Polynomial p = this.m_rfe.getDenominator();
        return new BackFilter(p);
    }

    public int getLBound() {
        if (this.m_rfe.isFinite()) {
            return -this.m_rfe.getNumerator().getDegree();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public BackFilter getNumerator() {
        Polynomial p = this.m_rfe.getNumerator();
        return new BackFilter(p);
    }

    public RationalFunction getRationalFunction() {
        return this.m_rfe;
    }

    public int getUBound() {
        return 0;
    }

    @Override
    public double getWeight(int pos) {
        return this.m_rfe.get(-pos);
    }

    public double[] getWeights(int n) {
        return this.m_rfe.coefficients(n);
    }

    @Override
    public boolean hasLowerBound() {
        return this.m_rfe.isFinite();
    }

    @Override
    public boolean hasUpperBound() {
        return true;
    }

    public RationalForeFilter mirror() {
        return new RationalForeFilter(this.m_rfe);
    }

    public void prepare(int n) {
        this.m_rfe.prepare(n);
    }

    public RationalBackFilter times(RationalBackFilter r) {
        Polynomial ln = this.m_rfe.getNumerator();
        Polynomial rn = r.m_rfe.getNumerator();
        Polynomial ld = this.m_rfe.getDenominator();
        Polynomial.SimplifyingTool psmp = new Polynomial.SimplifyingTool();
        Polynomial rd = r.m_rfe.getDenominator();
        if (psmp.simplify(ln, rd)) {
            ln = (Polynomial)psmp.getLeft();
            rd = (Polynomial)psmp.getRight();
        }
        if (psmp.simplify(rn, ld)) {
            rn = (Polynomial)psmp.getLeft();
            ld = (Polynomial)psmp.getRight();
        }
        Polynomial n = ln.times(rn);
        Polynomial d = ld.times(rd);
        RationalFunction rfe = new RationalFunction(n, d);
        return new RationalBackFilter(rfe);
    }
}

