/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.BaseSmoother;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.VarianceFilter;

public class BaseDiffuseSmoother
extends BaseSmoother {
    DiffuseFilteringResults m_frslts;
    int m_ndiffuse;
    int m_enddiffuse;
    DataBlock m_Ri;
    DataBlock m_Ki;
    DataBlock m_Z;
    DataBlock m_tmp0;
    DataBlock m_tmp1;
    double m_fi;
    Matrix m_N2;
    Matrix m_V;
    Matrix m_N1;

    protected BaseDiffuseSmoother() {
    }

    @Override
    protected void clear() {
        super.clear();
        this.m_frslts = null;
        this.m_Ri = null;
        this.m_Ki = null;
        this.m_Z = null;
        this.m_tmp0 = null;
        this.m_tmp1 = null;
        this.m_N2 = null;
        this.m_V = null;
        this.m_N1 = null;
    }

    public int getDiffuseCount() {
        return this.m_ndiffuse;
    }

    public int getEndDiffusePosition() {
        return this.m_enddiffuse;
    }

    @Override
    protected FilteredData getFilteredData() {
        return this.m_frslts.getFilteredData();
    }

    public DiffuseFilteringResults getFilteringResults() {
        return this.m_frslts;
    }

    @Override
    protected VarianceFilter getVarianceFilter() {
        return this.m_frslts.getVarianceFilter();
    }

    @Override
    protected void initSmoother() {
        super.initSmoother();
        this.m_ndiffuse = this.m_frslts.getDiffuseCount();
        this.m_enddiffuse = this.m_frslts.getEndDiffusePosition();
        this.m_tmp0 = new DataBlock(this.m_r);
        if (this.m_bCalcVar) {
            this.m_V = new Matrix(this.m_r, this.m_r);
        }
        if (this.m_enddiffuse > 0) {
            this.m_Ki = new DataBlock(this.m_r);
            if (this.m_data.hasData()) {
                this.m_Ri = new DataBlock(this.m_r);
            }
            if (this.m_bCalcVar) {
                this.m_N1 = new Matrix(this.m_r, this.m_r);
                this.m_N2 = new Matrix(this.m_r, this.m_r);
                this.m_Z = new DataBlock(this.m_r);
                this.m_tmp1 = new DataBlock(this.m_r);
            }
        }
    }

    protected void iterateInitialMissing() {
        SubMatrix t = this.m_T.all();
        SubMatrix tt = t.transpose();
        this.m_N2.all().xmy(tt, t);
        this.m_N1.all().xmy(tt, t);
        this.m_Nf.all().xmy(tt, t);
    }

    protected void iterateInitialN() {
        if (this.m_bMissing || this.m_fi == 0.0 && this.m_ff == 0.0) {
            this.iterateInitialMissing();
        } else if (this.m_fi != 0.0) {
            this.iterateInitialN0();
        } else {
            this.iterateInitialN1();
        }
    }

    protected void iterateInitialN0() {
        double lj;
        double li;
        double zj;
        double zi;
        double x;
        int j;
        int i;
        this.m_L.set(0.0);
        this.m_ssf.L(this.m_pos, this.m_Ki, this.m_L.all());
        double c = SymmetricMatrix.quadraticForm(this.m_Nf, this.m_Kf) - this.m_ff / (this.m_fi * this.m_fi);
        this.m_N2 = SymmetricMatrix.quadraticForm(this.m_N2, this.m_L);
        this.m_tmp0.product(this.m_N1.rows(), this.m_Kf);
        this.m_tmp1.product(this.m_tmp0, this.m_L.columns());
        for (i = 0; i < this.m_r; ++i) {
            for (j = 0; j <= i; ++j) {
                x = 0.0;
                zi = this.m_Z.get(i);
                zj = this.m_Z.get(j);
                li = this.m_tmp1.get(i);
                lj = this.m_tmp1.get(j);
                if (zi != 0.0 && zj != 0.0) {
                    x = c * zi * zj - zi * lj - zj * li;
                } else if (zi != 0.0) {
                    x = -zi * lj;
                } else if (zj != 0.0) {
                    x = -zj * li;
                }
                if (x == 0.0) continue;
                this.m_N2.add(i, j, x);
                if (i == j) continue;
                this.m_N2.add(j, i, x);
            }
        }
        this.m_N1.all().xmy(this.m_L.all().transpose(), this.m_L.all());
        this.m_tmp0.product(this.m_Kf, this.m_Nf.columns());
        this.m_tmp1.product(this.m_tmp0, this.m_L.columns());
        for (i = 0; i < this.m_r; ++i) {
            for (j = 0; j <= i; ++j) {
                x = 0.0;
                zi = this.m_Z.get(i);
                zj = this.m_Z.get(j);
                li = this.m_tmp1.get(i);
                lj = this.m_tmp1.get(j);
                if (zi != 0.0 && zj != 0.0) {
                    x = zi * zj / this.m_fi - zi * lj - zj * li;
                } else if (zi != 0.0) {
                    x = -zi * lj;
                } else if (zj != 0.0) {
                    x = -zj * li;
                }
                if (x == 0.0) continue;
                this.m_N1.add(i, j, x);
                if (i == j) continue;
                this.m_N1.add(j, i, x);
            }
        }
        this.m_Nf = SymmetricMatrix.quadraticForm(this.m_Nf, this.m_L);
        SymmetricMatrix.reinforceSymmetry(this.m_Nf);
        this.m_cvar = 0.0;
    }

    protected void iterateInitialN1() {
        this.m_L.set(0.0);
        SubMatrix l = this.m_L.all();
        SubMatrix t = this.m_T.all();
        SubMatrix tt = t.transpose();
        SubMatrix lt = l.transpose();
        this.m_ssf.L(this.m_pos, this.m_Kf, l);
        this.m_Nf.all().xmy(lt, l);
        this.m_ssf.VpZdZ(this.m_pos, this.m_Nf.all(), 1.0 / this.m_ff);
        SymmetricMatrix.reinforceSymmetry(this.m_Nf);
        this.m_N2.all().xmy(tt, t);
        this.m_N1.all().xmy(tt, l);
    }

    protected void iterateInitialR() {
        if (this.m_fi != 0.0) {
            if (!this.m_bMissing) {
                double c = (this.m_v - this.m_fi * (this.m_Ri.dot(this.m_Ki) + this.m_Rf.dot(this.m_Kf))) / this.m_fi;
                this.m_ssf.XT(this.m_pos, this.m_Ri);
                this.m_ssf.XpZd(this.m_pos, this.m_Ri, c);
            } else {
                this.m_ssf.XT(this.m_pos, this.m_Ri);
            }
            if (!this.m_bMissing) {
                this.m_c = -this.m_Rf.dot(this.m_Ki);
                this.m_ssf.XT(this.m_pos, this.m_Rf);
                this.m_ssf.XpZd(this.m_pos, this.m_Rf, this.m_c);
            } else {
                this.m_c = 0.0;
                this.m_ssf.XT(this.m_pos, this.m_Rf);
            }
        } else {
            this.m_ssf.XT(this.m_pos, this.m_Ri);
            this.iterateR();
        }
    }

    @Override
    protected void loadInfo() {
        this.m_bMissing = this.getVarianceFilter().isMissing(this.m_pos);
        this.m_ff = this.getVarianceFilter().F(this.m_pos);
        if (!this.m_bMissing) {
            this.m_v = this.getFilteredData().E(this.m_pos);
            this.m_Kf.copy(this.getVarianceFilter().C(this.m_pos));
            if (this.m_pos >= this.m_enddiffuse) {
                if (this.m_ff != 0.0) {
                    this.m_Kf.mul(1.0 / this.m_ff);
                }
            } else {
                this.m_fi = this.m_frslts.getVarianceFilter().Fi(this.m_pos);
                if (this.m_fi == 0.0) {
                    if (this.m_ff != 0.0) {
                        this.m_Kf.mul(1.0 / this.m_ff);
                    }
                } else {
                    this.m_Ki.copy(this.m_frslts.getVarianceFilter().Ci(this.m_pos));
                    this.m_Ki.mul(1.0 / this.m_fi);
                    this.m_Kf.addAY(-this.m_ff, this.m_Ki);
                    this.m_Kf.mul(1.0 / this.m_fi);
                }
            }
        } else {
            this.m_v = 0.0;
        }
    }

    @Override
    protected void loadModelInfo() {
        super.loadModelInfo();
        if (this.m_pos < this.m_enddiffuse && this.m_Z != null) {
            this.m_Z.set(0.0);
            this.m_ssf.Z(this.m_pos, this.m_Z);
        }
    }
}

