/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml.sa;

import demetra.datatypes.Ts;
import demetra.datatypes.sa.SaItemType;
import demetra.datatypes.sa.SaProcessingType;
import demetra.xml.IXmlConverter;
import demetra.xml.XmlMetaData;
import demetra.xml.XmlTs;
import demetra.xml.sa.AbstractXmlSaSpecification;
import demetra.xml.sa.XmlSaItem;
import demetra.xml.sa.tramoseats.XmlTramoSeatsSpecification;
import demetra.xml.sa.x13.XmlX13Specification;
import ec.satoolkit.ISaSpecification;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="saProcessing")
@XmlType(name="saProcessingType")
public class XmlSaProcessing
implements IXmlConverter<SaProcessingType> {
    static final String NAME = "saProcessingType";
    static final String RNAME = "saProcessing";
    @XmlAttribute
    public Date timeStamp;
    @XmlElement
    public XmlMetaData metadata;
    @XmlElements(value={@XmlElement(name="trsSpec", type=XmlTramoSeatsSpecification.class), @XmlElement(name="x13Spec", type=XmlX13Specification.class)})
    public AbstractXmlSaSpecification[] defaultMethods;
    @XmlElementWrapper(name="items")
    @XmlElement(name="saItem")
    public XmlSaItem[] items;

    @Override
    public SaProcessingType create() {
        SaProcessingType processing = new SaProcessingType();
        if (this.metadata != null) {
            processing.getMetaData().putAll((Map<String, String>)this.metadata.create());
        }
        HashMap<String, ISaSpecification> dic = new HashMap<String, ISaSpecification>();
        if (this.defaultMethods != null) {
            for (AbstractXmlSaSpecification xspec : this.defaultMethods) {
                dic.put(xspec.name, xspec.convert(true));
            }
        }
        if (this.items != null) {
            for (XmlSaItem xitem : this.items) {
                Ts s = xitem.series.create();
                ISaSpecification spec = null;
                if (xitem.spec != null) {
                    spec = xitem.spec.convert(false);
                }
                ISaSpecification espec = null;
                if (xitem.espec != null) {
                    espec = xitem.espec.convert(false);
                }
                ISaSpecification defspec = (ISaSpecification)dic.get(xitem.defaultMethod);
                SaItemType item = SaItemType.builder().ts(s).domainSpec(defspec).estimationSpec(espec).pointSpec(spec).status(xitem.status).quality(xitem.quality).estimationPolicy(xitem.policy).name(xitem.id).priority(xitem.priority).build();
                processing.getItems().add(item);
            }
        }
        if (this.timeStamp != null) {
            processing.getMetaData().put("TimeStamp", this.timeStamp.toString());
        }
        return processing;
    }

    @Override
    public void copy(SaProcessingType t) {
        this.timeStamp = new Date();
        List<SaItemType> pitems = t.getItems();
        int n = pitems.size();
        if (n > 0) {
            HashMap<ISaSpecification, String> dic = new HashMap<ISaSpecification, String>();
            XmlSaItem[] xitems = new XmlSaItem[n];
            ArrayList<AbstractXmlSaSpecification> xdspecs = new ArrayList<AbstractXmlSaSpecification>();
            int i = 0;
            int ispec = 1;
            for (SaItemType item : pitems) {
                XmlSaItem xitem = new XmlSaItem();
                xitem.series = new XmlTs();
                xitem.series.copy(item.getTs());
                xitem.priority = item.getPriority();
                xitem.quality = item.getQuality();
                xitem.policy = item.getEstimationPolicy();
                xitem.status = item.getStatus();
                ISaSpecification rspec = item.getPointSpec();
                ISaSpecification dspec = item.getDomainSpec();
                if (rspec != null) {
                    xitem.spec = AbstractXmlSaSpecification.create(rspec);
                }
                if (item.getEstimationSpec() != item.getDomainSpec()) {
                    xitem.espec = AbstractXmlSaSpecification.create(item.getEstimationSpec());
                }
                if (!dic.containsKey(dspec)) {
                    String name = "spec" + Integer.toString(ispec++);
                    dic.put(dspec, name);
                    AbstractXmlSaSpecification xdspec = AbstractXmlSaSpecification.create(dspec);
                    xdspec.name = name;
                    xdspecs.add(xdspec);
                    xitem.defaultMethod = name;
                }
                xitems[i++] = xitem;
            }
            this.items = xitems;
            this.defaultMethods = (AbstractXmlSaSpecification[])xdspecs.stream().toArray(AbstractXmlSaSpecification[]::new);
        }
    }
}

