/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.RegressionTestSpec;
import ec.tstoolkit.modelling.TsVariableDescriptor;
import ec.tstoolkit.modelling.arima.x13.MovingHolidaySpec;
import ec.tstoolkit.modelling.arima.x13.TradingDaysSpec;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RegressionSpec
implements Cloneable,
InformationSetSerializable {
    public static final double DEF_AICCDIFF = 0.0;
    public static final String AICDIFF = "aicdiff";
    public static final String TD = "tradingdays";
    public static final String MH = "mh";
    public static final String MHS = "mh*";
    public static final String OUTLIER = "outlier";
    public static final String OUTLIERS = "outliers";
    public static final String RAMP = "ramp";
    public static final String RAMPS = "ramps";
    public static final String USER = "user";
    public static final String USERS = "user*";
    public static final String INTERVENTION = "intervention";
    public static final String INTERVENTIONS = "intervention*";
    public static final String COEFF = "coefficients";
    public static final String FCOEFF = "fixedcoefficients";
    private double aicdiff_ = 0.0;
    private TradingDaysSpec td_ = new TradingDaysSpec();
    private ArrayList<MovingHolidaySpec> mh_ = new ArrayList();
    private ArrayList<OutlierDefinition> outliers_ = new ArrayList();
    private ArrayList<TsVariableDescriptor> users_ = new ArrayList();
    private ArrayList<InterventionVariable> interventions_ = new ArrayList();
    private ArrayList<Ramp> ramps_ = new ArrayList();
    private Map<String, double[]> fcoeff = new LinkedHashMap<String, double[]>();
    private Map<String, double[]> coeff = new LinkedHashMap<String, double[]>();

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, AICDIFF), Double.class);
        dic.put(InformationSet.item(prefix, OUTLIERS), String[].class);
        dic.put(InformationSet.item(prefix, RAMPS), String[].class);
        TsVariableDescriptor.fillDictionary(InformationSet.item(prefix, USERS), dic);
        MovingHolidaySpec.fillDictionary(InformationSet.item(prefix, MHS), dic);
        TradingDaysSpec.fillDictionary(InformationSet.item(prefix, TD), dic);
        InterventionVariable.fillDictionary(InformationSet.item(prefix, INTERVENTIONS), dic);
    }

    public void reset() {
        this.mh_.clear();
        this.outliers_.clear();
        this.users_.clear();
        this.interventions_.clear();
        this.ramps_.clear();
        this.fcoeff.clear();
        this.coeff.clear();
        this.aicdiff_ = 0.0;
    }

    public boolean isUsed() {
        return this.td_.isUsed() || !this.mh_.isEmpty() || !this.outliers_.isEmpty() || !this.users_.isEmpty() || !this.ramps_.isEmpty() || !this.interventions_.isEmpty();
    }

    public double getAICCDiff() {
        return this.aicdiff_;
    }

    public void setAICCDiff(double value) {
        this.aicdiff_ = value;
    }

    public TradingDaysSpec getTradingDays() {
        return this.td_;
    }

    public void setTradingDays(TradingDaysSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(TD);
        }
        this.td_ = value;
    }

    public MovingHolidaySpec getEaster() {
        for (MovingHolidaySpec mh : this.mh_) {
            if (mh.getType() != MovingHolidaySpec.Type.Easter && mh.getType() != MovingHolidaySpec.Type.JulianEaster) continue;
            return mh;
        }
        return null;
    }

    public MovingHolidaySpec[] getMovingHolidays() {
        return Jdk6.Collections.toArray(this.mh_, MovingHolidaySpec.class);
    }

    public void setMovingHolidays(MovingHolidaySpec[] value) {
        this.mh_.clear();
        if (value != null) {
            Collections.addAll(this.mh_, value);
        }
    }

    public void clearMovingHolidays() {
        this.mh_.clear();
    }

    public void removeMovingHolidays(MovingHolidaySpec espec) {
        this.mh_.remove(espec);
    }

    public MovingHolidaySpec search(MovingHolidaySpec.Type type) {
        for (MovingHolidaySpec mh : this.mh_) {
            if (mh.getType() != type) continue;
            return mh;
        }
        return null;
    }

    public void add(MovingHolidaySpec spec) {
        this.mh_.add(spec);
    }

    public int getOutliersCount() {
        return this.outliers_.size();
    }

    public OutlierDefinition[] getOutliers() {
        return Jdk6.Collections.toArray(this.outliers_, OutlierDefinition.class);
    }

    public void setOutliers(OutlierDefinition[] value) {
        this.outliers_.clear();
        if (value != null) {
            Collections.addAll(this.outliers_, value);
        }
    }

    public void clearOutliers() {
        this.outliers_.clear();
    }

    public OutlierDefinition[] search(OutlierType type) {
        ArrayList<OutlierDefinition> desc = new ArrayList<OutlierDefinition>();
        for (OutlierDefinition o : this.outliers_) {
            if (o.getType() != type) continue;
            desc.add(o);
        }
        return Jdk6.Collections.toArray(desc, OutlierDefinition.class);
    }

    public void add(OutlierDefinition o) {
        this.outliers_.add(o);
    }

    public void add(IOutlierVariable item) {
        this.outliers_.add(new OutlierDefinition(item.getPosition(), item.getCode()));
    }

    public boolean contains(OutlierDefinition outlier) {
        for (OutlierDefinition def : this.outliers_) {
            if (!def.equals((Object)outlier)) continue;
            return true;
        }
        return false;
    }

    public TsVariableDescriptor[] getUserDefinedVariables() {
        return Jdk6.Collections.toArray(this.users_, TsVariableDescriptor.class);
    }

    public void setUserDefinedVariables(TsVariableDescriptor[] value) {
        this.users_.clear();
        if (value != null) {
            Collections.addAll(this.users_, value);
        }
    }

    public int getUserDefinedVariablesCount() {
        return this.users_.size();
    }

    public void clearUserDefinedVariables() {
        this.users_.clear();
    }

    public void add(TsVariableDescriptor spec) {
        this.users_.add(spec);
    }

    public InterventionVariable[] getInterventionVariables() {
        return Jdk6.Collections.toArray(this.interventions_, InterventionVariable.class);
    }

    public void setInterventionVariables(InterventionVariable[] value) {
        this.interventions_.clear();
        if (value != null) {
            Collections.addAll(this.interventions_, value);
        }
    }

    public void add(InterventionVariable ivar) {
        this.interventions_.add(ivar);
    }

    public void clearInterventionVariables() {
        this.interventions_.clear();
    }

    public int getInterventionVariablesCount() {
        return this.interventions_.size();
    }

    public String[] getRegressionVariableNames(TsFrequency freq) {
        return this.getRegressionVariableNames(freq, false);
    }

    public String[] getRegressionVariableShortNames(TsFrequency freq) {
        return this.getRegressionVariableNames(freq, true);
    }

    private String[] getRegressionVariableNames(TsFrequency freq, boolean shortname) {
        MovingHolidaySpec easter;
        ArrayList<String> names = new ArrayList<String>();
        if (this.td_.isDefined()) {
            if (this.td_.isStockTradingDays()) {
                if (shortname) {
                    names.add("td");
                } else {
                    names.add("td#6");
                }
            } else {
                String[] user = this.td_.getUserVariables();
                if (user != null) {
                    for (String username : user) {
                        if (!username.startsWith("td|")) {
                            username = "td|" + username;
                        }
                        names.add(ITsVariable.validName(username));
                    }
                } else {
                    if (this.td_.getTradingDaysType() == TradingDaysType.WorkingDays || shortname) {
                        names.add("td");
                    } else {
                        names.add("td#6");
                    }
                    if (this.td_.getLengthOfPeriod() != LengthOfPeriodType.None) {
                        names.add("lp");
                    }
                }
            }
        }
        if ((easter = this.getEaster()) != null && easter.getTest() == RegressionTestSpec.None) {
            names.add("easter");
        }
        this.outliers_.stream().map(def -> {
            StringBuilder builder = new StringBuilder();
            builder.append(def.getCode()).append(" (");
            if (freq == TsFrequency.Undefined) {
                builder.append(def.getPosition());
            } else {
                TsPeriod p = new TsPeriod(freq, def.getPosition());
                builder.append(p);
            }
            return builder.append(')');
        }).forEach(builder -> names.add(builder.toString()));
        this.ramps_.forEach(rp -> names.add(rp.getName()));
        this.interventions_.forEach(iv -> {
            String n = iv.getName();
            if (names.contains(n)) {
                n = n + '*';
            }
            names.add(n);
        });
        this.users_.forEach(uv -> {
            int n = uv.getLastLag() - uv.getFirstLag() + 1;
            if (n == 1 || shortname) {
                names.add(RegressionSpec.validName(uv.getName()));
            } else {
                names.add(RegressionSpec.validName(uv.getName()) + '#' + n);
            }
        });
        String[] all = new String[names.size()];
        return names.toArray(all);
    }

    private static String validName(String name) {
        return name.replace('.', '@');
    }

    public double[] getCoefficients(String name) {
        return this.coeff.get(name);
    }

    public void setCoefficients(String name, double[] c) {
        this.coeff.put(name, c);
    }

    public void clearAllCoefficients() {
        this.coeff.clear();
    }

    public void clearCoefficients(String name) {
        this.coeff.remove(name);
    }

    public double[] getFixedCoefficients(String name) {
        return this.fcoeff.get(name);
    }

    public void setAllFixedCoefficients(Map<String, double[]> coeffs) {
        this.clearAllFixedCoefficients();
        this.fcoeff.putAll(coeffs);
    }

    public Map<String, double[]> getAllFixedCoefficients() {
        this.checkFixedCoefficients();
        return Collections.unmodifiableMap(this.fcoeff);
    }

    public Map<String, double[]> getAllCoefficients() {
        return Collections.unmodifiableMap(this.coeff);
    }

    public void setFixedCoefficients(String name, double[] c) {
        this.fcoeff.put(name, c);
    }

    public void clearAllFixedCoefficients() {
        this.fcoeff.clear();
    }

    public void clearFixedCoefficients(String name) {
        this.fcoeff.remove(name);
    }

    public void clearRamps() {
        this.ramps_.clear();
    }

    public int getRampsCount() {
        return this.ramps_.size();
    }

    public void add(Ramp rp) {
        this.ramps_.add(rp);
    }

    public Ramp[] getRamps() {
        return Jdk6.Collections.toArray(this.ramps_, Ramp.class);
    }

    public void setRamps(Ramp[] value) {
        this.ramps_.clear();
        if (value != null) {
            Collections.addAll(this.ramps_, value);
        }
    }

    public RegressionSpec clone() {
        try {
            RegressionSpec spec = (RegressionSpec)super.clone();
            spec.interventions_ = new ArrayList();
            for (InterventionVariable ii : this.interventions_) {
                spec.interventions_.add(ii.clone());
            }
            spec.mh_ = new ArrayList();
            for (MovingHolidaySpec mh : this.mh_) {
                spec.mh_.add(mh.clone());
            }
            spec.outliers_ = Jdk6.newArrayList(this.outliers_);
            spec.ramps_ = new ArrayList();
            for (Ramp r : this.ramps_) {
                spec.ramps_.add(r.clone());
            }
            spec.td_ = this.td_.clone();
            spec.users_ = new ArrayList();
            this.users_.forEach(var -> spec.users_.add(var.clone()));
            spec.fcoeff = new LinkedHashMap<String, double[]>();
            this.fcoeff.forEach((name, c) -> spec.fcoeff.put((String)name, (double[])c));
            spec.coeff = new LinkedHashMap<String, double[]>();
            this.coeff.forEach((name, c) -> spec.coeff.put((String)name, (double[])c));
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RegressionSpec && this.equals((RegressionSpec)obj);
    }

    private boolean equals(RegressionSpec other) {
        return this.aicdiff_ == other.aicdiff_ && Objects.equals(this.td_, other.td_) && Comparator.equals(this.users_, other.users_) && Comparator.equals(this.ramps_, other.ramps_) && Comparator.equals(this.outliers_, other.outliers_) && Comparator.equals(this.mh_, other.mh_) && Comparator.equals(this.interventions_, other.interventions_) && this.compare(this.fcoeff, other.fcoeff);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Jdk6.Double.hashCode(this.aicdiff_);
        hash = 89 * hash + this.td_.hashCode();
        hash = 89 * hash + this.mh_.hashCode();
        hash = 89 * hash + this.outliers_.hashCode();
        hash = 89 * hash + this.users_.hashCode();
        hash = 89 * hash + this.interventions_.hashCode();
        hash = 89 * hash + this.ramps_.hashCode();
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet icoeff;
        InformationSet cur;
        InformationSet tdinfo;
        if (!this.isUsed()) {
            return null;
        }
        InformationSet specInfo = new InformationSet();
        if (verbose || this.aicdiff_ != 0.0) {
            specInfo.add(AICDIFF, Double.valueOf(this.aicdiff_));
        }
        if ((verbose || this.td_.isUsed()) && (tdinfo = this.td_.write(verbose)) != null) {
            specInfo.add(TD, tdinfo);
        }
        int idx = 1;
        for (MovingHolidaySpec spec : this.mh_) {
            InformationSet cmh = spec.write(verbose);
            if (cmh == null) continue;
            specInfo.add(MH + Integer.toString(idx++), cmh);
        }
        if (!this.outliers_.isEmpty()) {
            String[] outliers = new String[this.outliers_.size()];
            for (int i = 0; i < outliers.length; ++i) {
                outliers[i] = this.outliers_.get(i).toString();
            }
            specInfo.add(OUTLIERS, outliers);
        }
        if (!this.ramps_.isEmpty()) {
            String[] ramps = new String[this.ramps_.size()];
            for (int i = 0; i < ramps.length; ++i) {
                ramps[i] = this.ramps_.get(i).toString();
            }
            specInfo.add(RAMPS, ramps);
        }
        idx = 1;
        for (TsVariableDescriptor desc : this.users_) {
            cur = desc.write(verbose);
            if (cur == null) continue;
            specInfo.add(USER + Integer.toString(idx++), cur);
        }
        idx = 1;
        for (InterventionVariable ivar : this.interventions_) {
            cur = ivar.write(verbose);
            if (cur == null) continue;
            specInfo.add(INTERVENTION + Integer.toString(idx++), cur);
        }
        if (!this.fcoeff.isEmpty()) {
            icoeff = specInfo.subSet(FCOEFF);
            this.fcoeff.forEach((s, c) -> icoeff.set((String)s, ((double[])c).length == 1 ? (Object)c[0] : c));
        }
        if (!this.coeff.isEmpty()) {
            icoeff = specInfo.subSet(COEFF);
            this.coeff.forEach((s, c) -> icoeff.set((String)s, ((double[])c).length == 1 ? (Object)c[0] : c));
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            InformationSet informationSet;
            String[] ramps;
            InformationSet tdinfo;
            this.reset();
            Double aic = info.get(AICDIFF, Double.class);
            if (aic != null) {
                this.aicdiff_ = aic;
            }
            if ((tdinfo = info.getSubSet(TD)) != null) {
                this.td_ = new TradingDaysSpec();
                if (!this.td_.read(tdinfo)) {
                    return false;
                }
            }
            List<Information<InformationSet>> sel = info.select(MHS, InformationSet.class);
            for (Information<InformationSet> item : sel) {
                MovingHolidaySpec cmh = new MovingHolidaySpec();
                if (!cmh.read((InformationSet)item.value)) continue;
                this.mh_.add(cmh);
            }
            String[] outliers = info.get(OUTLIERS, String[].class);
            if (outliers != null) {
                for (int i = 0; i < outliers.length; ++i) {
                    OutlierDefinition o = OutlierDefinition.fromString(outliers[i]);
                    if (o == null) {
                        return false;
                    }
                    this.outliers_.add(o);
                }
            }
            if ((ramps = info.get(RAMPS, String[].class)) != null) {
                for (int i = 0; i < ramps.length; ++i) {
                    Ramp r = Ramp.fromString(ramps[i]);
                    if (r == null) {
                        return false;
                    }
                    this.ramps_.add(r);
                }
            }
            List<Information<InformationSet>> usel = info.select(USERS, InformationSet.class);
            for (Information information : usel) {
                TsVariableDescriptor tsVariableDescriptor = new TsVariableDescriptor();
                if (!tsVariableDescriptor.read((InformationSet)information.value)) continue;
                this.users_.add(tsVariableDescriptor);
            }
            List<Information<InformationSet>> isel = info.select(INTERVENTIONS, InformationSet.class);
            for (Information<InformationSet> information : isel) {
                InterventionVariable cur = new InterventionVariable();
                if (!cur.read((InformationSet)information.value)) continue;
                this.interventions_.add(cur);
            }
            InformationSet informationSet2 = info.getSubSet(FCOEFF);
            if (informationSet2 != null) {
                List<Information<double[]>> list = informationSet2.select(double[].class);
                for (int i = 0; i < list.size(); ++i) {
                    Information<double[]> item = list.get(i);
                    if (this.td_ != null && this.td_.getUserVariables() != null && "td".equals(item.name) && ((double[])item.value).length == this.td_.getUserVariables().length) {
                        for (int j = 0; j < ((double[])item.value).length; ++j) {
                            this.fcoeff.put(ITsVariable.validName("td|" + this.td_.getUserVariables()[j]), new double[]{((double[])item.value)[j]});
                        }
                        continue;
                    }
                    this.fcoeff.put(item.name, (double[])item.value);
                }
                List<Information<Double>> sall = informationSet2.select(Double.class);
                for (int i = 0; i < sall.size(); ++i) {
                    Information<Double> item = sall.get(i);
                    if (this.td_ != null && this.td_.getUserVariables() != null && "td".equals(item.name) && 1 == this.td_.getUserVariables().length) {
                        this.fcoeff.put(ITsVariable.validName("td|" + this.td_.getUserVariables()[0]), new double[]{(Double)item.value});
                        continue;
                    }
                    this.fcoeff.put(item.name, new double[]{(Double)item.value});
                }
            }
            if ((informationSet = info.getSubSet(COEFF)) != null) {
                List<Information<double[]>> all = informationSet.select(double[].class);
                all.stream().forEach(reg -> this.coeff.put(reg.name, (double[])reg.value));
                List<Information<Double>> sall = informationSet.select(Double.class);
                sall.stream().forEach(reg -> this.coeff.put(reg.name, new double[]{(Double)reg.value}));
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    private boolean compare(Map<String, double[]> cl, Map<String, double[]> cr) {
        if (cl.size() != cr.size()) {
            return false;
        }
        Optional<Map.Entry> any = cl.entrySet().stream().filter(entry -> {
            if (!cr.containsKey(entry.getKey())) {
                return true;
            }
            return !Arrays.equals((double[])entry.getValue(), (double[])cr.get(entry.getKey()));
        }).findAny();
        return !any.isPresent();
    }

    public boolean hasFixedCoefficients() {
        return !this.fcoeff.isEmpty();
    }

    public boolean hasFixedCoefficients(String shortname) {
        Optional<String> any = this.fcoeff.keySet().stream().filter(x -> shortname.equals(ITsVariable.shortName(x))).findAny();
        return any.isPresent();
    }

    private void checkFixedCoefficients() {
        Object[] names = this.getRegressionVariableShortNames(TsFrequency.Undefined);
        Arrays.sort(names);
        List<String> toremove = this.fcoeff.keySet().stream().filter(arg_0 -> RegressionSpec.lambda$checkFixedCoefficients$386((String[])names, arg_0)).collect(Collectors.toList());
        int i = 0;
        for (int j = 0; j < names.length; ++j) {
            if (!((String)names[j]).startsWith("td|")) continue;
            ++i;
        }
        if (toremove.contains("td") && this.fcoeff.get("td").length != i) {
            toremove.remove("td");
        }
        toremove.forEach(s -> this.fcoeff.remove(s));
    }

    private static /* synthetic */ boolean lambda$checkFixedCoefficients$386(String[] names, String s) {
        return Arrays.binarySearch(names, s) < 0;
    }
}

