/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.AutoCorrelations;
import ec.tstoolkit.stats.StatisticalTest;

public class BoxPierceTest
extends StatisticalTest {
    AutoCorrelations ac;
    private int m_lag = 1;
    private boolean m_pos;
    private int m_k = 12;
    private int m_hp;

    public int getHyperParametersCount() {
        return this.m_hp;
    }

    public int getK() {
        return this.m_k;
    }

    public int getLag() {
        return this.m_lag;
    }

    @Override
    public boolean isValid() {
        if (!this.m_computed) {
            this.test();
        }
        return this.m_dist != null;
    }

    public void setHyperParametersCount(int value) {
        if (this.m_hp != value) {
            this.m_hp = value;
            this.clear();
        }
    }

    public void setK(int value) {
        if (this.m_k != value) {
            this.m_k = value;
            this.clear();
        }
    }

    public void setLag(int value) {
        if (this.m_lag != value) {
            this.m_lag = value;
            this.m_pos = this.m_lag > 1;
            this.clear();
        }
    }

    public void usePositiveAc(boolean pos) {
        this.m_pos = pos;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        try {
            this.ac.setKMax(this.m_k * this.m_lag);
            if (this.ac.getKMax() < this.m_k * this.m_lag) {
                this.m_dist = null;
                return;
            }
            double[] a = this.ac.getAC();
            int n = this.ac.stats.getDataCount();
            double res = 0.0;
            for (int i = 1; i <= this.m_k; ++i) {
                double ai = a[i * this.m_lag - 1];
                if (this.m_pos && ai < 0.0) break;
                res += ai * ai;
            }
            this.m_val = res * (double)n;
            Chi2 chi = new Chi2();
            chi.setDegreesofFreedom(this.m_lag == 1 ? this.m_k - this.m_hp : this.m_k);
            this.m_dist = chi;
            this.m_type = TestType.Upper;
            this.m_asympt = true;
        }
        catch (Exception err) {
            this.m_dist = null;
        }
        finally {
            this.m_computed = true;
        }
    }

    public void test(AutoCorrelations ac) {
        this.ac = ac;
        this.test();
    }

    public void test(IReadDataBlock data) {
        this.ac = new AutoCorrelations(data);
        this.test();
    }
}

