/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.DayClustering;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.List;

public class GenericTradingDays {
    private final DayClustering clustering;
    private final int contrastGroup;
    private final boolean normalized;

    public static GenericTradingDays contrasts(DayClustering clustering) {
        return new GenericTradingDays(clustering, 0);
    }

    public static GenericTradingDays of(DayClustering clustering) {
        return new GenericTradingDays(clustering, false);
    }

    public static GenericTradingDays normalized(DayClustering clustering) {
        return new GenericTradingDays(clustering, true);
    }

    private GenericTradingDays(DayClustering clustering, int contrastGroup) {
        this.clustering = clustering;
        this.contrastGroup = contrastGroup;
        this.normalized = true;
    }

    private GenericTradingDays(DayClustering clustering, boolean normalized) {
        this.clustering = clustering;
        this.contrastGroup = -1;
        this.normalized = normalized;
    }

    public DayClustering getClustering() {
        return this.clustering;
    }

    public void data(TsDomain domain, List<DataBlock> buffer) {
        if (this.contrastGroup >= 0) {
            this.dataContrasts(domain, buffer);
        } else {
            this.dataNoContrast(domain, buffer);
        }
    }

    private void dataNoContrast(TsDomain domain, List<DataBlock> buffer) {
        int n = domain.getLength();
        int[][] days = Utilities.tdCount(domain);
        this.adjust(days);
        int[][] groups = this.clustering.allPositions();
        int ng = groups.length;
        for (int i = 0; i < n; ++i) {
            for (int ig = 0; ig < ng; ++ig) {
                int[] group = groups[ig];
                int sum = days[group[0]][i];
                int np = group.length;
                for (int ip = 1; ip < np; ++ip) {
                    sum += days[group[ip]][i];
                }
                double dsum = sum;
                if (this.normalized) {
                    dsum /= (double)np;
                }
                buffer.get(ig).set(i, dsum);
            }
        }
    }

    private void dataContrasts(TsDomain domain, List<DataBlock> buffer) {
        int n = domain.getLength();
        int[][] days = Utilities.tdCount(domain);
        this.adjust(days);
        int[][] groups = this.clustering.allPositions();
        this.rotate(groups);
        int ng = groups.length - 1;
        int[] cgroup = groups[ng];
        for (int i = 0; i < n; ++i) {
            int csum = days[cgroup[0]][i];
            int cnp = cgroup.length;
            for (int ip = 1; ip < cnp; ++ip) {
                csum += days[cgroup[ip]][i];
            }
            double dcsum = csum;
            dcsum /= (double)cnp;
            for (int ig = 0; ig < ng; ++ig) {
                int[] group = groups[ig];
                int sum = days[group[0]][i];
                int np = group.length;
                for (int ip = 1; ip < np; ++ip) {
                    sum += days[group[ip]][i];
                }
                double dsum = sum;
                buffer.get(ig).set(i, dsum - (double)np * dcsum);
            }
        }
    }

    public int getCount() {
        int n = this.clustering.getGroupsCount();
        return this.contrastGroup >= 0 ? n - 1 : n;
    }

    public String getDescription(int idx) {
        return this.clustering.toString(idx);
    }

    public int getContrastGroup() {
        return this.contrastGroup;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    private void rotate(int[][] groups) {
        if (this.contrastGroup >= 0) {
            int[] cgroup = groups[this.contrastGroup];
            for (int i = this.contrastGroup + 1; i < groups.length; ++i) {
                groups[i - 1] = groups[i];
            }
            groups[groups.length - 1] = cgroup;
        }
    }

    private void adjust(int[][] days) {
        int[] sun = days[0];
        for (int i = 1; i < days.length; ++i) {
            days[i - 1] = days[i];
        }
        days[6] = sun;
    }
}

