/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.diagnostics.CochranTest;
import ec.satoolkit.diagnostics.CombinedSeasonalityTest;
import ec.satoolkit.x11.MsrTable;
import ec.satoolkit.x11.SeriesEvolution;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.stats.AutoCorrelations;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class Mstatistics
implements IProcResults {
    private TsData O;
    private TsData P;
    private TsData TD;
    private TsData Ome;
    private TsData Oc;
    private TsData CIc;
    private TsData Cc;
    private TsData Sc;
    private TsData Ic;
    private TsData Omod;
    private TsData CImod;
    private TsData Imod;
    private TsData Snorm;
    private TsData Pt;
    private TsData Ps;
    private TsData Pi;
    private TsData SI;
    private TsData MCD;
    private TsData stO;
    private TsData stC;
    private double varC;
    private double varS;
    private double varI;
    private double varP;
    private double varTD;
    private Double icr;
    private double[] gP;
    private double[] gTD;
    private double[] gOmod;
    private double[] gCImod;
    private double[] gImod;
    private double[] gMCD;
    private boolean[] valid;
    private double[] gOc;
    private double[] gCc;
    private double[] gIc;
    private double[] gCIc;
    private double[] gSc;
    private double[] m = new double[11];
    private boolean s3x5;
    private boolean bShort;
    private DecompositionMode mode;
    private static double[] wtFull = new double[]{10.0, 11.0, 10.0, 8.0, 11.0, 10.0, 18.0, 7.0, 7.0, 4.0, 4.0};
    private static double[] wtShort = new double[]{14.0, 15.0, 10.0, 8.0, 11.0, 10.0, 32.0};
    private MsrTable rms;
    private double testvalue = 0.0;
    private double criticalvalue = 0.0;
    private boolean cochranTestResult = true;
    private int minNumberOfYears = 0;
    public static final String M1 = "m1";
    public static final String M2 = "m2";
    public static final String M3 = "m3";
    public static final String M4 = "m4";
    public static final String M5 = "m5";
    public static final String M6 = "m6";
    public static final String M7 = "m7";
    public static final String M8 = "m8";
    public static final String M9 = "m9";
    public static final String M10 = "m10";
    public static final String M11 = "m11";
    public static final String Q = "q";
    public static final String Q2 = "q-m2";
    private static final InformationMapping<Mstatistics> MAPPING = new InformationMapping<Mstatistics>(Mstatistics.class);

    public static Mstatistics computeFromX11(DecompositionMode mode, InformationSet info) {
        InformationSet dtables = info.getSubSet("d-tables");
        InformationSet atables = info.getSubSet("a-tables");
        InformationSet btables = info.getSubSet("b-tables");
        InformationSet etables = info.getSubSet("e-tables");
        InformationSet ctables = info.getSubSet("c-tables");
        if (dtables == null) {
            return null;
        }
        try {
            DescriptiveStatistics td;
            TsData s;
            Mstatistics mstats = new Mstatistics(mode);
            mstats.O = s = atables.get("a1", TsData.class);
            mstats.Oc = btables.get("b1", TsData.class).fittoDomain(s.getDomain());
            mstats.Cc = dtables.get("d12_lin", TsData.class);
            mstats.CIc = dtables.get("d11_lin", TsData.class);
            mstats.Sc = dtables.get("d10_lin", TsData.class);
            mstats.Ic = dtables.get("d13_lin", TsData.class);
            if (mode != DecompositionMode.PseudoAdditive) {
                mstats.TD = dtables.get("d18", TsData.class);
                mstats.P = atables.get("a8", TsData.class);
                mstats.Pt = atables.get("a8t", TsData.class);
                mstats.Ps = atables.get("a8s", TsData.class);
                mstats.Pi = atables.get("a8i", TsData.class);
            }
            mstats.SI = dtables.get("d8", TsData.class);
            mstats.Ome = etables.get("e1", TsData.class);
            mstats.CImod = etables.get("e2", TsData.class);
            mstats.Imod = etables.get("e3", TsData.class);
            mstats.Omod = mstats.op(mstats.Ome, mstats.Pt);
            mstats.Omod = mstats.op(mstats.Omod, mstats.Ps);
            mstats.CImod = mstats.op(mstats.CImod, mstats.Pt);
            mstats.checkSeries();
            if (mstats.TD != null && (td = new DescriptiveStatistics(mstats.TD)).isConstant()) {
                mstats.TD = null;
            }
            mstats.rms = dtables.get("finalRMS", MsrTable.class);
            if (mstats.rms != null) {
                mstats.m[5] = 0.4 * Math.abs(mstats.rms.getGlobalMsr() - 4.0);
            }
            Integer slen = dtables.get("slen", Integer.class);
            Boolean sdef = dtables.get("s3x5default", Boolean.class);
            if (slen != null) {
                boolean bl = mstats.s3x5 = slen == 7;
            }
            if (sdef != null && sdef.booleanValue()) {
                mstats.s3x5 = false;
            }
            mstats.icr = dtables.get("d12-IC ratio", Double.class);
            if (mstats.icr != null) {
                mstats.m[2] = 0.5 * (mstats.icr - 1.0);
            }
            if (mstats.O.getLength() / mstats.O.getFrequency().intValue() < 6) {
                mstats.bShort = true;
            }
            mstats.calcStationaryVariances();
            mstats.calcSNorm();
            mstats.calcEvolutions();
            mstats.calcM();
            mstats.calcCochran(ctables.get("c13", TsData.class), mode, mstats);
            return mstats;
        }
        catch (RuntimeException err) {
            return null;
        }
    }

    public void checkSeries() {
        if (this.mode == DecompositionMode.PseudoAdditive) {
            this.valid = new boolean[this.Oc.getLength()];
            for (int i = 0; i < this.valid.length; ++i) {
                this.valid[i] = this.Oc.get(i) > 0.0 && this.CIc.get(i) > 0.0;
            }
        }
    }

    public boolean[] validObservations() {
        return this.valid;
    }

    public TsData getO() {
        return this.O;
    }

    public TsData getP() {
        return this.P;
    }

    public TsData getOc() {
        return this.Oc;
    }

    public TsData getIc() {
        return this.Ic;
    }

    public TsData getCIc() {
        return this.CIc;
    }

    public TsData getCc() {
        return this.Cc;
    }

    public TsData getSc() {
        return this.Sc;
    }

    public TsData getMCD() {
        return this.MCD;
    }

    public TsData getstationaryC() {
        return this.stC;
    }

    public TsData getstationaryO() {
        return this.stO;
    }

    public double[] getOcChanges() {
        return this.gOc;
    }

    public double[] getOmodChanges() {
        return this.gOmod;
    }

    public double[] getIcChanges() {
        return this.gIc;
    }

    public double[] getImodChanges() {
        return this.gImod;
    }

    public double[] getCIcChanges() {
        return this.gCIc;
    }

    public double[] getCImodChanges() {
        return this.gCImod;
    }

    public double[] getCcChanges() {
        return this.gCc;
    }

    public double[] getScChanges() {
        return this.gSc;
    }

    public double[] getPChanges() {
        return this.gP;
    }

    public double[] getTDChanges() {
        return this.gTD;
    }

    public double[] getMCDChanges() {
        return this.gMCD;
    }

    public double getVarI() {
        return this.varI;
    }

    public double getVarS() {
        return this.varS;
    }

    public double getVarC() {
        return this.varC;
    }

    public double getVarP() {
        return this.varP;
    }

    public double getVarTD() {
        return this.varTD;
    }

    public double getCriticalValue() {
        return this.criticalvalue;
    }

    public double getTestValue() {
        return this.testvalue;
    }

    public boolean getCochranResult() {
        return this.cochranTestResult;
    }

    public int getminNumberOfYears() {
        return this.minNumberOfYears;
    }

    public double getAdrOfCI() {
        return SeriesEvolution.Adr(this.CIc, this.mode.isMultiplicative());
    }

    public double getAdrOfI() {
        return SeriesEvolution.Adr(this.Ic, this.mode.isMultiplicative());
    }

    public double getAdrOfC() {
        return SeriesEvolution.Adr(this.Cc, this.mode.isMultiplicative());
    }

    public double[] getAutoCorrelationsOfIrregular() {
        TsData irr = this.Ic;
        if (this.mode.isMultiplicative()) {
            irr = irr.minus(1.0);
        }
        AutoCorrelations ac = new AutoCorrelations(irr);
        ac.setCorrectedForMean(false);
        int ifreq = irr.getFrequency().intValue();
        double[] c = new double[ifreq + 2];
        for (int i = 0; i < c.length; ++i) {
            c[i] = ac.autoCorrelation(i + 1);
        }
        return c;
    }

    private Mstatistics(DecompositionMode mode) {
        this.mode = mode;
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i] = -1.0;
        }
    }

    private void calcEvolutions() {
        boolean mul = this.mode != DecompositionMode.Additive;
        this.gOmod = SeriesEvolution.calcAbsMeanVariations(this.Omod, null, mul, this.valid);
        this.gCImod = SeriesEvolution.calcAbsMeanVariations(this.CImod, null, mul, this.valid);
        this.gImod = SeriesEvolution.calcAbsMeanVariations(this.Imod, null, mul, this.valid);
        this.gOc = SeriesEvolution.calcAbsMeanVariations(this.Oc, null, mul, this.valid);
        this.gCIc = SeriesEvolution.calcAbsMeanVariations(this.CIc, null, mul, this.valid);
        this.gCc = SeriesEvolution.calcAbsMeanVariations(this.Cc, null, mul, this.valid);
        this.gSc = SeriesEvolution.calcAbsMeanVariations(this.Sc, null, mul, this.valid);
        this.gIc = SeriesEvolution.calcAbsMeanVariations(this.Ic, null, mul, this.valid);
        if (this.P != null) {
            this.gP = SeriesEvolution.calcAbsMeanVariations(this.P, null, mul, this.valid);
        }
        if (this.TD != null) {
            this.gTD = SeriesEvolution.calcAbsMeanVariations(this.TD, null, mul, this.valid);
        }
    }

    private void calcM() {
        int del = 1;
        int p = this.O.getFrequency().intValue();
        if (p == 12) {
            del = 3;
        }
        this.calcM1(del);
        this.calcM2();
        this.calcM4();
        this.calcM5();
        this.calcM6();
        this.calcM7();
        this.calcM8();
        this.calcM9();
        this.calcM10();
        this.calcM11();
    }

    private void calcM1(int del) {
        boolean mul = this.mode != DecompositionMode.Additive;
        double mt = SeriesEvolution.calcAbsMeanVariations(this.Cc, null, del, mul, this.valid);
        mt *= mt;
        double mi = SeriesEvolution.calcAbsMeanVariations(this.Imod, null, del, mul, this.valid);
        mi *= mi;
        double ms = SeriesEvolution.calcAbsMeanVariations(this.Sc, null, del, mul, this.valid);
        ms *= ms;
        double mp = 0.0;
        if (this.P != null) {
            mp = SeriesEvolution.calcAbsMeanVariations(this.P, null, del, mul, this.valid);
            mp *= mp;
        }
        double mtd = 0.0;
        if (this.TD != null) {
            mtd = SeriesEvolution.calcAbsMeanVariations(this.TD, null, del, mul, this.valid);
            mtd *= mtd;
        }
        double mo = mt + mi + ms + mp + mtd;
        this.m[0] = 10.0 * (mi / mo) / (1.0 - mp / mo);
    }

    private void calcM10() {
        if (this.bShort) {
            return;
        }
        PeriodIterator iter = new PeriodIterator(this.Snorm);
        int ifreq = this.Snorm.getFrequency().intValue();
        double ds = 0.0;
        int nn = ifreq * 3;
        while (iter.hasMoreElements()) {
            DataBlock db = iter.nextElement().data;
            int n = db.getLength();
            if (n < 5) {
                return;
            }
            for (int i = n - 5; i < n - 2; ++i) {
                ds += Math.abs(db.get(i) - db.get(i - 1));
            }
        }
        this.m[9] = ds / (double)nn * 10.0;
    }

    private void calcM11() {
        if (this.bShort) {
            return;
        }
        int ifreq = this.Snorm.getFrequency().intValue();
        PeriodIterator iter = new PeriodIterator(this.Snorm);
        double ds = 0.0;
        int nn = ifreq * 3;
        while (iter.hasMoreElements()) {
            DataBlock db = iter.nextElement().data;
            int n = db.getLength();
            if (n < 6) {
                return;
            }
            ds += Math.abs(db.get(n - 3) - db.get(n - 6));
        }
        this.m[10] = ds / (double)nn * 10.0;
    }

    private void calcM2() {
        this.m[1] = this.varP >= 1.0 ? 3.0 : 10.0 * this.varI / (1.0 - this.varP);
    }

    private void calcM4() {
        double adr = SeriesEvolution.Adr(this.Ic, this.mode != DecompositionMode.Additive);
        int n = this.Ic.getLength();
        double lv = Math.sqrt(1.6 * (double)n - 2.9) * 2.577;
        double uv = Math.abs((double)(3 * (n - 1)) / adr - (double)(2 * n - 1));
        this.m[3] = uv / lv;
    }

    private void calcM5() {
        double rmcd;
        int mcd;
        int ifreq = this.O.getFrequency().intValue();
        int c = 12 / ifreq;
        for (mcd = ifreq; mcd > 0 && this.smic(mcd) < 1.0; --mcd) {
        }
        if (mcd < ifreq) {
            ++mcd;
        }
        if (mcd == 1) {
            rmcd = 1.0 + (this.smic(1) - 1.0) / (this.smic(1) - this.smic(2));
            if (rmcd < 0.5) {
                rmcd = 0.5;
            }
            if (rmcd > 1.0) {
                rmcd = 1.0;
            }
        } else {
            double dsmic = this.smic(mcd - 1) - this.smic(mcd);
            rmcd = dsmic <= 0.0 && mcd == ifreq ? (double)c * 15.5 : (double)mcd + (this.smic(mcd) - 1.0) / dsmic;
        }
        this.m[4] = (rmcd * (double)c - 0.5) / 5.0;
    }

    private void calcM6() {
    }

    private void calcM7() {
        CombinedSeasonalityTest test;
        switch (this.mode) {
            case LogAdditive: {
                test = new CombinedSeasonalityTest(this.SI.log(), false);
                break;
            }
            case Additive: {
                test = new CombinedSeasonalityTest(this.SI, false);
                break;
            }
            default: {
                test = new CombinedSeasonalityTest(this.SI, true);
            }
        }
        this.m[6] = test.mvalue();
    }

    private void calcM8() {
        if (this.bShort) {
            return;
        }
        int ifreq = this.O.getFrequency().intValue();
        TsData s = this.Snorm.delta(ifreq);
        s.applyOnFinite(x -> Math.abs(x));
        DescriptiveStatistics stats = new DescriptiveStatistics(s);
        this.m[7] = 10.0 * stats.getSum() / (double)s.getLength();
    }

    private void calcM9() {
        if (this.bShort) {
            return;
        }
        int ifreq = this.Snorm.getFrequency().intValue();
        PeriodIterator iter = new PeriodIterator(this.Snorm);
        double ds = 0.0;
        while (iter.hasMoreElements()) {
            DataBlock db = iter.nextElement().data;
            int n = db.getLength() - 1;
            ds += Math.abs(db.get(n) - db.get(0)) / (double)n;
        }
        this.m[8] = ds / (double)ifreq * 10.0;
    }

    private void calcSNorm() {
        double stde = 0.0;
        if (this.mode != DecompositionMode.Additive) {
            DescriptiveStatistics stat = new DescriptiveStatistics(this.Sc.minus(1.0));
            stde = Math.sqrt(stat.getSumSquare() / (double)stat.getObservationsCount());
        } else {
            DescriptiveStatistics stat = new DescriptiveStatistics(this.Sc);
            stde = Math.sqrt(stat.getSumSquare() / (double)stat.getObservationsCount());
        }
        this.Snorm = this.Sc.div(stde);
    }

    private double variance(TsData s, boolean log, boolean zero) {
        double x;
        int i;
        if (log) {
            s = s.log();
        }
        int n = s.getLength();
        int m = 0;
        double z = 0.0;
        double mu = 0.0;
        if (!zero) {
            for (i = 0; i < n; ++i) {
                x = s.get(i);
                if (this.valid != null && !this.valid[i] || !Double.isFinite(x)) continue;
                ++m;
                z += x;
            }
            mu = z / (double)m;
        }
        z = 0.0;
        for (i = 0; i < n; ++i) {
            x = s.get(i);
            if (this.valid != null && !this.valid[i] || !Double.isFinite(x)) continue;
            z += (x -= mu) * x;
        }
        return z;
    }

    private void calcStationaryVariances() {
        Ols ols;
        this.stC = this.Cc.clone();
        this.stO = this.Ome.clone();
        double[] line = new double[this.Cc.getLength()];
        for (int i = 0; i < line.length; ++i) {
            line[i] = i;
        }
        if (this.mode != DecompositionMode.Additive) {
            ols = new Ols();
            RegModel model = new RegModel();
            this.stC.applyOnFinite(x -> Math.log(x));
            model.setY(new DataBlock(this.stC.internalStorage()));
            model.setMeanCorrection(true);
            model.addX(new DataBlock(line));
            if (!ols.process(model)) {
                return;
            }
            double[] b = ols.getLikelihood().getB();
            TsData lt = new TsData(this.stC.getStart(), line, false);
            lt.applyOnFinite(x -> x * b[1] + b[0]);
            this.stC = this.stC.minus(lt);
            this.stO.applyOnFinite(x -> Math.log(x));
            this.stO = this.stO.minus(lt);
        } else {
            ols = new Ols();
            RegModel model = new RegModel();
            model.setY(new DataBlock(this.stC.internalStorage()));
            model.setMeanCorrection(true);
            model.addX(new DataBlock(line));
            if (!ols.process(model)) {
                return;
            }
            double[] b = ols.getLikelihood().getB();
            TsData lt = new TsData(this.stC.getStart(), line, false);
            lt.applyOnFinite(x -> x * b[1] + b[0]);
            this.stC = this.stC.minus(lt);
            this.stO = this.stO.minus(lt);
        }
        double varO = this.variance(this.stO, false, false);
        this.varC = this.variance(this.stC, false, false);
        this.varS = this.variance(this.Sc, this.mode != DecompositionMode.Additive, true);
        this.varI = this.variance(this.Imod, this.mode != DecompositionMode.Additive, true);
        if (this.P != null) {
            this.varP = this.variance(this.P, this.mode != DecompositionMode.Additive, false);
        }
        if (this.TD != null) {
            this.varTD = this.variance(this.TD, this.mode != DecompositionMode.Additive, true);
        }
        this.varP /= varO;
        this.varTD /= varO;
        this.varS /= varO;
        this.varC /= varO;
        this.varI /= varO;
    }

    private void calcCochran(TsData ts, DecompositionMode mode, Mstatistics mstats) {
        CochranTest cochranTest = new CochranTest(ts, mode.isMultiplicative());
        cochranTest.calcCochranTest();
        mstats.criticalvalue = cochranTest.getCriticalValue();
        mstats.testvalue = cochranTest.getTestValue();
        mstats.cochranTestResult = cochranTest.getTestResult();
        mstats.minNumberOfYears = cochranTest.getMinNumberOfYearsPerPeriod();
    }

    public DecompositionMode getMode() {
        return this.mode;
    }

    public double getM(int q) {
        double x = this.m[q - 1];
        if (x > 3.0) {
            return 3.0;
        }
        if (x < 0.0) {
            return 0.0;
        }
        return x;
    }

    public int getMCount() {
        return this.m.length;
    }

    public double getQ() {
        double q = 0.0;
        double wtot = 0.0;
        double[] wt = this.bShort ? wtShort : wtFull;
        for (int i = 0; i < wt.length; ++i) {
            if (this.m[i] == -1.0 || i == 5 && !this.s3x5) continue;
            wtot += wt[i];
            if (this.m[i] > 3.0) {
                q += 3.0 * wt[i];
                continue;
            }
            if (!(this.m[i] > 0.0)) continue;
            q += this.m[i] * wt[i];
        }
        return q / wtot;
    }

    public double getQm2() {
        double q = 0.0;
        double wtot = 0.0;
        double[] wt = this.bShort ? wtShort : wtFull;
        for (int i = 0; i < wt.length; ++i) {
            if (i == 1 || this.m[i] == -1.0 || i == 5 && !this.s3x5) continue;
            wtot += wt[i];
            if (this.m[i] > 3.0) {
                q += 3.0 * wt[i];
                continue;
            }
            if (!(this.m[i] > 0.0)) continue;
            q += this.m[i] * wt[i];
        }
        return q / wtot;
    }

    public Double getIcr() {
        return this.icr;
    }

    public MsrTable getRms() {
        return this.rms;
    }

    public double getVarTotal() {
        return this.varC + this.varS + this.varI + this.varP + this.varTD;
    }

    public boolean isUsedM(int q) {
        return this.m[q - 1] != -1.0;
    }

    private TsData op(TsData l, TsData r) {
        if (this.mode != DecompositionMode.Additive) {
            return TsData.divide(l, r);
        }
        return TsData.subtract(l, r);
    }

    private double smic(int m) {
        int i = m - 1;
        return this.gIc[i] / this.gCc[i];
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dictionary = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, dictionary, false);
        return dictionary;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        return null;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    public static InformationMapping<Mstatistics> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<Mstatistics, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<Mstatistics, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set(M1, Double.class, source -> source.getM(1));
        MAPPING.set(M2, Double.class, source -> source.getM(2));
        MAPPING.set(M3, Double.class, source -> source.getM(3));
        MAPPING.set(M4, Double.class, source -> source.getM(4));
        MAPPING.set(M5, Double.class, source -> source.getM(5));
        MAPPING.set(M6, Double.class, source -> source.getM(6));
        MAPPING.set(M7, Double.class, source -> source.getM(7));
        MAPPING.set(M8, Double.class, source -> source.getM(8));
        MAPPING.set(M9, Double.class, source -> source.getM(9));
        MAPPING.set(M10, Double.class, source -> source.getM(10));
        MAPPING.set(M11, Double.class, source -> source.getM(11));
        MAPPING.set(Q, Double.class, source -> source.getQ());
        MAPPING.set(Q2, Double.class, source -> source.getQm2());
    }
}

