/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.realfunctions.RealFunction;
import java.util.function.DoubleFunction;

public interface IFilter {
    public Complex frequencyResponse(double var1);

    public double getWeight(int var1);

    public boolean hasLowerBound();

    public boolean hasUpperBound();

    default public DoubleFunction<Complex> frequencyResponse() {
        return x -> this.frequencyResponse(x);
    }

    default public RealFunction gainFunction() {
        return x -> this.frequencyResponse(x).abs();
    }

    default public RealFunction squaredGainFunction() {
        return x -> this.frequencyResponse(x).absSquare();
    }

    default public RealFunction phaseFunction() {
        return x -> {
            Complex c = this.frequencyResponse(x);
            if (c.getIm() == 0.0) {
                return 0.0;
            }
            return c.arg();
        };
    }
}

