/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.maths.matrices.LuDecomposition;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class Gauss
extends LuDecomposition {
    @Override
    public void decompose(Matrix m) {
        this.init(m, true);
        this.gauss();
    }

    @Override
    public void decompose(SubMatrix m) {
        this.init(new Matrix(m), false);
        this.gauss();
    }

    private void gauss() {
        int k = 0;
        int kn = 0;
        while (k < this.n_) {
            int i;
            double kk;
            int p = k;
            double pmax = Math.abs(this.lu_[kn + k]);
            int i2 = k + 1;
            int idx = i2 + k * this.n_;
            while (i2 < this.n_) {
                double cur = Math.abs(this.lu_[idx]);
                if (cur > pmax) {
                    p = i2;
                    pmax = cur;
                }
                ++i2;
                ++idx;
            }
            if (p != k) {
                int j = 0;
                int pj = p;
                int kj = k;
                while (j < this.n_) {
                    double tmp = this.lu_[pj];
                    this.lu_[pj] = this.lu_[kj];
                    this.lu_[kj] = tmp;
                    ++j;
                    pj += this.n_;
                    kj += this.n_;
                }
                int t = this.piv_[p];
                this.piv_[p] = this.piv_[k];
                this.piv_[k] = t;
                this.pivsign_ = -this.pivsign_;
            }
            if (Math.abs(kk = this.lu_[kn + k * this.n_]) < this.getEpsilon()) {
                throw new MatrixException("LU decomposition: Singular matrix");
            }
            int idx2 = i = k + 1;
            while (i < this.n_) {
                int n = idx2 + k * this.n_;
                this.lu_[n] = this.lu_[n] / kk;
                for (int j = k + 1; j < this.n_; ++j) {
                    int n2 = idx2 + j * this.n_;
                    this.lu_[n2] = this.lu_[n2] - this.lu_[idx2 + k * this.n_] * this.lu_[kn + j * this.n_];
                }
                ++i;
                ++idx2;
            }
            ++k;
            ++kn;
        }
    }
}

