/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.SarmaSpecification;
import ec.tstoolkit.sarima.estimation.DefaultSarimaInitializer;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import ec.tstoolkit.sarima.estimation.IarimaInitializer;
import ec.tstoolkit.sarima.estimation.SarimaMapping;

public class SarimaInitializer
implements IarimaInitializer {
    private static double EPS = 1.0E-9;
    private boolean failhr_;
    private boolean usedefault_ = true;
    private boolean stabilize_ = true;
    private DataBlock dy_;
    private static final DefaultSarimaInitializer defInitializer = new DefaultSarimaInitializer();

    public boolean isfailHR() {
        return this.failhr_;
    }

    public boolean isStabilizing() {
        return this.stabilize_;
    }

    public boolean isUsingDefaultIfFailed() {
        return this.usedefault_;
    }

    public void useDefaultIfFailed(boolean usedef) {
        this.usedefault_ = usedef;
    }

    public void setFailHR(boolean value) {
        this.failhr_ = value;
    }

    public void setStabilizing(boolean value) {
        this.stabilize_ = value;
    }

    public DataBlock differencedResiduals() {
        return this.dy_;
    }

    @Override
    public SarimaModel initialize(RegArimaModel<SarimaModel> regs) {
        SarimaModel sarima = regs.getArima();
        SarimaSpecification spec = sarima.getSpecification();
        SarmaSpecification dspec = spec.doStationary();
        try {
            if (spec.getParametersCount() == 0) {
                return new SarimaModel(dspec);
            }
            this.dy_ = null;
            HannanRissanen hr = new HannanRissanen();
            if (regs.getDModel().getVarsCount() > 0) {
                Ols ols = new Ols();
                if (!ols.process(regs.getDModel())) {
                    return (SarimaModel)sarima.stationaryTransformation().stationaryModel;
                }
                this.dy_ = ols.getResiduals();
            } else {
                this.dy_ = regs.getDModel().getY();
            }
            if (Math.sqrt(this.dy_.ssq() / (double)this.dy_.getLength()) < EPS) {
                SarimaModel rslt = new SarimaModel(dspec);
                rslt.setDefault(0.0, 0.0);
                return rslt;
            }
            if (!hr.process(this.dy_, dspec)) {
                if (this.failhr_) {
                    return null;
                }
                if (this.usedefault_) {
                    return defInitializer.doDefaultModel(dspec);
                }
            }
            SarimaModel m = hr.getModel();
            if (!this.stabilize_) {
                return m;
            }
            if (SarimaMapping.stabilize(m) && this.failhr_) {
                return null;
            }
            return m;
        }
        catch (BaseException ex) {
            if (this.failhr_) {
                return null;
            }
            SarimaModel arma = (SarimaModel)sarima.stationaryTransformation().stationaryModel;
            if (this.usedefault_) {
                arma.setDefault();
            }
            return arma;
        }
    }
}

