/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.ssf.BaseOrdinaryState;
import ec.tstoolkit.ssf.DiffuseState;
import ec.tstoolkit.utilities.Arrays2;
import java.util.Arrays;

public class FilteredData {
    DataBlockStorage m_A;
    double[] m_std;
    double[] m_e;
    boolean m_bA = false;
    private int m_n;

    public FilteredData() {
        this.m_bA = false;
    }

    public FilteredData(boolean hasA) {
        this.m_bA = hasA;
    }

    public DataBlock A(int t) {
        return this.m_A == null ? null : this.m_A.block(t);
    }

    public void checkSize(int n) {
        if (n <= this.m_e.length) {
            return;
        }
        n = DataBlockStorage.calcSize(n);
        double[] tmp = new double[n];
        Arrays.fill(tmp, this.m_e.length, n, Double.NaN);
        Arrays2.copy(this.m_e, tmp, this.m_e.length);
        this.m_e = tmp;
        tmp = new double[n];
        Arrays2.copy(this.m_std, tmp, this.m_std.length);
        this.m_std = tmp;
        if (this.m_bA) {
            this.m_A.resize(n);
        }
    }

    public void clear() {
        this.m_e = null;
        this.m_A = null;
        this.m_std = null;
        this.m_n = 0;
    }

    public void close() {
    }

    public double[] data(boolean studentized, boolean clean) {
        int nobs;
        if (this.m_e == null) {
            return null;
        }
        int n = this.getCount();
        if (n == (nobs = this.obsCount()) || !clean) {
            if (!studentized) {
                return (double[])this.m_e.clone();
            }
            double[] rslt = new double[n];
            for (int i = 0; i < n; ++i) {
                rslt[i] = !Double.isNaN(this.m_e[i]) && !Double.isInfinite(this.m_std[i]) && !Double.isNaN(this.m_std[i]) ? this.m_e[i] / this.m_std[i] : Double.NaN;
            }
            return rslt;
        }
        double[] rslt = new double[nobs];
        if (!studentized) {
            int i = 0;
            int j = 0;
            while (j < nobs) {
                if (!(Double.isNaN(this.m_e[i]) || Double.isInfinite(this.m_std[i]) || Double.isNaN(this.m_std[i]))) {
                    rslt[j++] = this.m_e[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            int j = 0;
            while (j < nobs) {
                if (!(Double.isNaN(this.m_e[i]) || Double.isInfinite(this.m_std[i]) || Double.isNaN(this.m_std[i]))) {
                    rslt[j++] = this.m_e[i] / this.m_std[i];
                }
                ++i;
            }
        }
        return rslt;
    }

    public double E(int t) {
        return this.m_e[t];
    }

    public int getCount() {
        return this.m_n;
    }

    public void init(int dim, int n) {
        n = DataBlockStorage.calcSize(n);
        this.clear();
        this.m_e = new double[n];
        Arrays.fill(this.m_e, Double.NaN);
        this.m_std = new double[n];
        if (this.m_bA) {
            this.m_A = new DataBlockStorage(dim, n);
        }
    }

    public boolean isSavingA() {
        return this.m_bA;
    }

    public int obsCount() {
        if (this.m_e == null) {
            return 0;
        }
        int nobs = 0;
        for (int i = 0; i < this.m_n; ++i) {
            if (Double.isNaN(this.m_e[i]) || Double.isInfinite(this.m_std[i]) || Double.isNaN(this.m_std[i])) continue;
            ++nobs;
        }
        return nobs;
    }

    public void save(int t, BaseOrdinaryState state) {
        if (state.isMissing()) {
            this.m_e[t] = Double.NaN;
            this.m_std[t] = Double.NaN;
        } else {
            this.m_e[t] = state.e;
            this.m_std[t] = state.f != 0.0 ? Math.sqrt(state.f) : 0.0;
        }
        if (this.m_bA) {
            this.m_A.save(t, state.A);
        }
        if (this.m_n <= t) {
            this.m_n = t + 1;
        }
    }

    public void save(int t, DiffuseState state) {
        if (state.isMissing()) {
            this.m_e[t] = Double.NaN;
            this.m_std[t] = Double.NaN;
        } else {
            this.m_e[t] = state.e;
            this.m_std[t] = state.fi == 0.0 ? Math.sqrt(state.f) : Double.POSITIVE_INFINITY;
        }
        if (this.m_bA) {
            this.m_A.save(t, state.A);
        }
        if (this.m_n <= t) {
            this.m_n = t + 1;
        }
    }

    public void setSavingA(boolean value) {
        this.m_bA = value;
    }

    public double std(int t) {
        return this.m_std[t];
    }
}

