/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml.sa.uscb;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.satoolkit.x11.X11Specification;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlType;
import jd2.xml.IXmlConverter;

@XmlType(name="x11SpecType")
public class XmlX11Spec
implements IXmlConverter<X11Specification> {
    static final String NAME = "x11SpecType";
    @XmlElement
    public DecompositionMode mode = DecompositionMode.Undefined;
    @XmlElement
    public boolean useForecasts = true;
    @XmlElement(name="seasonalma")
    @XmlList
    public SeasonalFilterOption[] seasonalma;
    @XmlElement
    public Double lsigma = 1.5;
    @XmlElement
    public Double usigma = 2.5;
    @XmlElement
    public Integer trendma;

    public boolean isLsigmaSpecified() {
        return this.lsigma != null;
    }

    public boolean isUsigmaSpecified() {
        return this.usigma != null;
    }

    public boolean isTrendmaSpecified() {
        return this.trendma != null;
    }

    public static XmlX11Spec create(X11Specification spec) {
        if (spec == null) {
            return null;
        }
        XmlX11Spec x = new XmlX11Spec();
        x.copy(spec);
        return x;
    }

    public void copyTo(X11Specification spec) {
        spec.setMode(this.mode);
        if (this.isLsigmaSpecified()) {
            spec.setLowerSigma(this.lsigma.doubleValue());
        }
        if (this.isUsigmaSpecified()) {
            spec.setUpperSigma(this.usigma.doubleValue());
        }
        if (this.isTrendmaSpecified()) {
            spec.setHendersonFilterLength(this.trendma.intValue());
        }
        if (this.seasonalma != null) {
            spec.setSeasonalFilters(this.seasonalma);
        }
        spec.setForecastHorizon(this.useForecasts ? -1 : 0);
    }

    @Override
    public X11Specification create() {
        X11Specification spec = new X11Specification();
        this.copyTo(spec);
        return spec;
    }

    @Override
    public void copy(X11Specification t) {
        this.mode = t.getMode();
        this.lsigma = t.getLowerSigma();
        this.usigma = t.getUpperSigma();
        this.trendma = t.getHendersonFilterLength();
        this.seasonalma = t.getSeasonalFilters();
        this.useForecasts = t.getForecastHorizon() != 0;
    }
}

