/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.MaLjungBoxFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class UscbForecasts {
    private final IArimaModel arima;
    private final Polynomial ar;
    private final Polynomial ma;
    private final double mean;

    public UscbForecasts(IArimaModel model) {
        this.arima = model;
        this.ar = this.arima.getAR().getPolynomial();
        this.ma = this.arima.getMA().getPolynomial();
        this.mean = 0.0;
    }

    public UscbForecasts(IArimaModel model, double mu) {
        this.arima = model;
        this.ar = this.arima.getAR().getPolynomial();
        this.ma = this.arima.getMA().getPolynomial();
        if (model.getStationaryARCount() > 0) {
            Polynomial c = model.getStationaryAR().getPolynomial();
            double s = 0.0;
            for (int i = 0; i <= c.getDegree(); ++i) {
                s += c.get(i);
            }
            this.mean = mu * s;
        } else {
            this.mean = mu;
        }
    }

    public double[] forecasts(IReadDataBlock data, int nf) {
        try {
            int i;
            DataBlock res = this.residuals(data);
            double[] fcasts = new double[nf];
            int p = this.ar.getDegree();
            double[] y = new double[p];
            int last = data.getLength() - 1;
            for (int i2 = 0; i2 < p; ++i2) {
                y[i2] = data.get(last - i2);
            }
            int q = this.ma.getDegree();
            double[] e = new double[q];
            last = res.getLength() - 1;
            for (i = 0; i < q; ++i) {
                e[i] = res.get(last - i);
            }
            for (i = 0; i < nf; ++i) {
                int j;
                double s = this.mean;
                for (j = 0; j < p; ++j) {
                    s -= this.ar.get(j + 1) * y[j];
                }
                for (j = i; j < q; ++j) {
                    s += this.ma.get(j + 1) * e[j - i];
                }
                for (j = p - 1; j > 0; --j) {
                    y[j] = y[j - 1];
                }
                if (p > 0) {
                    y[0] = s;
                }
                fcasts[i] = s;
            }
            return fcasts;
        }
        catch (Exception err) {
            return null;
        }
    }

    private DataBlock residuals(IReadDataBlock data) {
        DataBlock w = new DataBlock(data);
        try {
            DataBlock z = w;
            int p = this.ar.getDegree();
            int q = this.ma.getDegree();
            if (p > 0) {
                z = new DataBlock(w.getLength() - p);
                DataBlock x = w.drop(p, 0);
                z.copy(x);
                for (int i = 1; i <= p; ++i) {
                    x.move(-1);
                    z.addAY(this.ar.get(i), x);
                }
            }
            if (this.mean != 0.0) {
                z.sub(this.mean);
            }
            if (q > 0) {
                MaLjungBoxFilter malb = new MaLjungBoxFilter();
                int nwl = malb.initialize((IArimaModel)this.arima.stationaryTransformation().stationaryModel, z.getLength());
                DataBlock wl = new DataBlock(nwl);
                malb.filter(z, wl);
                return wl;
            }
            return z;
        }
        catch (Exception err) {
            return w;
        }
    }
}

