% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_workspace.R
\name{save_workspace}
\alias{save_workspace}
\title{Save a workspace}
\usage{
save_workspace(workspace, file)
}
\arguments{
\item{workspace}{the workspace object to export}

\item{file}{the path where to export the 'JDemetra+' workspace (.xml file).
By default, if not specified, a dialog box opens.}
}
\value{
A boolean indicating whether the export is successful.
}
\description{
Function to save a \code{workspace} object into a 'JDemetra+' workspace.
}
\examples{
\donttest{
dir <- tempdir()
# Creation and export of an empty 'JDemetra+' workspace
wk <- new_workspace()
new_multiprocessing(wk, "sa1")
save_workspace(wk, file.path(dir, "workspace.xml"))
}

}
\seealso{
\code{\link{load_workspace}}
}
