/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.DiffuseLikelihood;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.BaseDiffuseSmoother;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.LikelihoodEvaluation;
import ec.tstoolkit.ssf.SmoothingResults;

public class Smoother
extends BaseDiffuseSmoother {
    private DataBlock m_a;
    private SubMatrix m_Pf;
    private SubMatrix m_Pi;
    private Matrix m_Vtmp0;
    private Matrix m_Vtmp1;
    private SmoothingResults m_srslts;
    private int m_stop = 0;

    public void setStopPosition(int stop) {
        this.m_stop = stop;
    }

    public int getStopPosition() {
        return this.m_stop;
    }

    @Override
    protected void clear() {
        super.clear();
        this.m_a = null;
        this.m_Pf = null;
        this.m_Pi = null;
        this.m_Vtmp0 = null;
        this.m_Vtmp1 = null;
        this.m_srslts = null;
    }

    @Override
    protected void initSmoother() {
        super.initSmoother();
        this.m_srslts.prepare(this.m_data.getCount(), this.m_r);
        this.m_a = this.m_data.hasData() ? new DataBlock(this.m_r) : DataBlock.EMPTY;
        if (this.m_bCalcVar) {
            this.m_Vtmp0 = new Matrix(this.m_r, this.m_r);
            this.m_Vtmp1 = new Matrix(this.m_r, this.m_r);
        }
    }

    protected void iterateSmoother() {
        if (this.m_pos >= this.m_enddiffuse) {
            if (this.m_a.getLength() > 0) {
                this.iterateR();
                this.m_tmp0.product(this.m_Rf, this.m_Pf.columns());
                this.m_a.add(this.m_tmp0);
            }
            if (this.m_bCalcVar) {
                this.iterateN();
                SymmetricMatrix.quadraticForm(this.m_Nf.subMatrix(), this.m_Pf, this.m_V.subMatrix());
                this.m_V.chs();
                this.m_V.subMatrix().add(this.m_Pf);
            }
        } else {
            if (this.m_a.getLength() > 0) {
                this.iterateInitialR();
                this.m_tmp0.product(this.m_Rf, this.m_Pf.columns());
                this.m_a.add(this.m_tmp0);
                this.m_tmp0.product(this.m_Ri, this.m_Pi.columns());
                this.m_a.add(this.m_tmp0);
            }
            if (this.m_bCalcVar) {
                this.iterateInitialN();
                SymmetricMatrix.quadraticForm(this.m_Nf.all(), this.m_Pf, this.m_V.all());
                SymmetricMatrix.quadraticForm(this.m_N2.all(), this.m_Pi, this.m_Vtmp0.all());
                this.m_V.add(this.m_Vtmp0);
                this.m_Vtmp0.all().product(this.m_Pf, this.m_N1.all());
                this.m_Vtmp1.all().product(this.m_Vtmp0.all(), this.m_Pi);
                this.m_V.add(this.m_Vtmp1);
                this.m_V.add(this.m_Vtmp1.transpose());
                this.m_V.chs();
                this.m_V.all().add(this.m_Pf);
            }
        }
    }

    @Override
    protected void loadInfo() {
        super.loadInfo();
        this.m_Pf = this.m_frslts.getVarianceFilter().P(this.m_pos);
        if (this.m_pos < this.m_enddiffuse) {
            this.m_Pi = this.m_frslts.getVarianceFilter().Pi(this.m_pos);
        }
        if (this.m_a.getLength() != 0) {
            this.m_a.copy(this.m_frslts.getFilteredData().A(this.m_pos));
        }
    }

    public boolean process(ISsfData data, DiffuseFilteringResults frslts, SmoothingResults rslts) {
        this.clear();
        if (this.m_ssf == null) {
            return false;
        }
        this.m_data = data;
        this.m_frslts = frslts;
        this.m_srslts = rslts;
        this.m_srslts.setSaveP(this.m_bCalcVar);
        this.initSmoother();
        if (this.m_ssf.isTimeInvariant()) {
            this.loadModelInfo();
        }
        while (this.m_pos >= this.m_stop) {
            if (!this.m_ssf.isTimeInvariant() || this.m_pos == this.m_enddiffuse - 1) {
                this.loadModelInfo();
            }
            this.loadInfo();
            this.iterateSmoother();
            this.m_srslts.save(this.m_pos, this.m_a, this.m_V, this.m_c, this.m_cvar);
            --this.m_pos;
        }
        if (this.m_bCalcVar) {
            DiffuseLikelihood ll = new DiffuseLikelihood();
            LikelihoodEvaluation.evaluate(frslts, ll);
            double ser = ll.getSer();
            this.m_srslts.setStandardError(ser);
        }
        return true;
    }

    public boolean process(ISsfData data, SmoothingResults rslts) {
        if (this.m_ssf == null) {
            return false;
        }
        DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
        frslts.getVarianceFilter().setSavingP(true);
        frslts.getFilteredData().setSavingA(data.hasData());
        Filter<ISsf> filter = new Filter<ISsf>();
        filter.setSsf(this.m_ssf);
        if (!filter.process(data, frslts)) {
            return false;
        }
        return this.process(data, frslts, rslts);
    }
}

