/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.api;

import it.bankitalia.reri.sia.sdmx.api.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataFlowStructure {
    private String id;
    private String name;
    private String agency;
    private String version;
    private String timeDimension;
    private Map<String, Dimension> dimensions = new HashMap<String, Dimension>();

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String string) {
        this.agency = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public List<Dimension> getDimensions() {
        Dimension[] dimensionArray = null;
        Collection<Dimension> collection = this.dimensions.values();
        dimensionArray = new Dimension[collection.size()];
        Iterator<Dimension> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Dimension dimension;
            dimensionArray[dimension.getPosition() - 1] = dimension = iterator.next();
        }
        return Arrays.asList(dimensionArray);
    }

    public void setDimension(Dimension dimension) {
        this.dimensions.put(dimension.getId(), dimension);
    }

    public Dimension getDimension(String string) {
        return this.dimensions.get(string);
    }

    public void setTimeDimension(String string) {
        this.timeDimension = string;
    }

    public boolean isDimension(String string) {
        return this.dimensions.containsKey(string);
    }

    public int getDimensionPosition(String string) {
        return this.dimensions.get(string).getPosition();
    }

    public String getTimeDimension() {
        return this.timeDimension;
    }

    public String getFullIdentifier() {
        String string = this.id;
        if (this.agency != null) {
            string = this.agency + "/" + string;
        }
        if (this.version != null) {
            string = string + "/" + this.version;
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DSD [id=").append(this.getFullIdentifier()).append(",\n name=").append(this.name).append(",\n dimensions=").append(this.dimensions).append("]");
        return stringBuilder.toString();
    }

    public String getObsStatus() {
        return "OBS_STATUS";
    }

    public String getMeasure() {
        return "OBS_VALUE";
    }
}

