/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class Provider {
    private final String name;
    private final URI endpoint;
    private final SDMXVersion sdmxVersion;
    private final boolean needsURLEncoding;
    private final boolean supportsCompression;
    private String description;
    private boolean needsCredentials;
    private boolean full = false;
    private Map<String, Dataflow> flows;
    private Map<String, DataFlowStructure> dsdNameToStructureCache = null;

    public Provider(String string, URI uRI, boolean bl, boolean bl2, boolean bl3, String string2, SDMXVersion sDMXVersion) throws SdmxException {
        this.name = string;
        this.endpoint = uRI;
        this.description = string2;
        this.flows = new HashMap<String, Dataflow>();
        this.dsdNameToStructureCache = new HashMap<String, DataFlowStructure>();
        this.needsCredentials = bl;
        this.needsURLEncoding = bl2;
        this.supportsCompression = bl3;
        this.sdmxVersion = sDMXVersion;
    }

    public String getName() {
        return this.name;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setFlows(Map<String, Dataflow> map) {
        this.flows = map;
    }

    public void setFlow(Dataflow dataflow) {
        this.flows.put(dataflow.getFullIdentifier(), dataflow);
    }

    public Dataflow getFlow(String string) {
        if (this.flows.containsKey(string)) {
            return this.flows.get(string);
        }
        return this.flows.values().stream().filter(dataflow -> dataflow.getId().equals(string)).max(Comparator.comparing(SDMXReference::getVersion)).orElse(null);
    }

    public Map<String, Dataflow> getFlows() {
        return this.flows;
    }

    public SDMXReference getDSDIdentifier(String string) {
        Dataflow dataflow = this.getFlow(string);
        return dataflow != null ? dataflow.getDsdIdentifier() : null;
    }

    public DataFlowStructure getDSD(String string) {
        return this.dsdNameToStructureCache.get(string);
    }

    public void setDSD(String string, DataFlowStructure dataFlowStructure) {
        this.dsdNameToStructureCache.put(string, dataFlowStructure);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isNeedsCredentials() {
        return this.needsCredentials;
    }

    public void setNeedsCredentials(boolean bl) {
        this.needsCredentials = bl;
    }

    public void setFull(boolean bl) {
        this.full = bl;
    }

    public boolean isFull() {
        return this.full;
    }

    public boolean isNeedsURLEncoding() {
        return this.needsURLEncoding;
    }

    public boolean isSupportsCompression() {
        return this.supportsCompression;
    }

    public SDMXVersion getSdmxVersion() {
        return this.sdmxVersion;
    }
}

