/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.api.SdmxMetaElement;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.SDMXClientFactory;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxResponseException;
import it.bancaditalia.oss.sdmx.helper.AboutContentFrame;
import it.bancaditalia.oss.sdmx.helper.CheckboxListTableModel;
import it.bancaditalia.oss.sdmx.helper.DataflowsModel;
import it.bancaditalia.oss.sdmx.helper.DoFilterListener;
import it.bancaditalia.oss.sdmx.helper.EnumedListTableModel;
import it.bancaditalia.oss.sdmx.helper.HelperHandler;
import it.bancaditalia.oss.sdmx.helper.NewProviderDialog;
import it.bancaditalia.oss.sdmx.helper.ProgressViewer;
import it.bancaditalia.oss.sdmx.helper.ResultsFrame;
import it.bancaditalia.oss.sdmx.helper.ToolCommandsFrame;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultEditorKit;

public class SDMXHelper
extends JFrame {
    private static final String TOOLTIP_FORMAT = "<html><p style='text-align: center'>%1$tF<br />%1$tT.%1$tL</p></html>";
    public static final Action COPY_ACTION = new DefaultEditorKit.CopyAction();
    static final Image ICON_MIN;
    static final Image ICON_MAX;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER;
    private static final String[] HELP;
    private final JLabel lblQuery = new JLabel();
    private final JTextField tfSdmxQuery = new JTextField();
    private final JTextField tfCodesFilter = new JTextField();
    private final JTextField tfDataflowFilter = new JTextField();
    private final JTable tblDataflows = new JTable();
    private final JLabel lblCodelist = new JLabel();
    private final JTable tblDimensions = new JTable();
    private final JTable tblCodes = new JTable();
    private final JButton btnCheckQuery = new JButton();
    private final JButton btnPrintQuery = new JButton();
    private final ButtonGroup selectedProviderGroup = new ButtonGroup();
    private final DataflowsModel dataflowsTableModel = new DataflowsModel();
    private final EnumedListTableModel<Dimension> dimsTableModel = new EnumedListTableModel();
    private final HashMap<String, TableRowSorter<CheckboxListTableModel<String>>> codelistSortersMap = new HashMap();
    private final JCheckBox cbRegexSearchCL = new JCheckBox();
    private final JCheckBox cbCaseSearchCL = new JCheckBox();
    private final JCheckBox cbWholeWordCL = new JCheckBox();
    private final JRadioButton rdSearchCodeCL = new JRadioButton();
    private final JRadioButton rdSearchDescCL = new JRadioButton();
    private final JRadioButton rdSearchBothCL = new JRadioButton();
    private final ButtonGroup codeSearchRadioGroup = new ButtonGroup();
    private final JRadioButton rdSearchCodeFlow = new JRadioButton();
    private final JRadioButton rdSearchDSDFlow = new JRadioButton();
    private final JRadioButton rdSearchDescFlow = new JRadioButton();
    private final JRadioButton rdSearchAllFlow = new JRadioButton();
    private final JCheckBox cbWholeWordFlow = new JCheckBox();
    private final JCheckBox cbCaseSearchFlow = new JCheckBox();
    private final JCheckBox cbRegexSearchFlow = new JCheckBox();
    private final ButtonGroup flowSearchRadioGroup = new ButtonGroup();
    private final JTextField tfDimensionFilter = new JTextField();
    private final TableRowSorter<EnumedListTableModel<Dimension>> dimTableSorter = new TableRowSorter<EnumedListTableModel<Dimension>>(this.dimsTableModel);
    private final JMenuItem mntmAddProvider = new JMenuItem();
    private final JMenuItem mntmBuildCommands = new JMenuItem();
    private final JMenuItem mntmCopySelection = new JMenuItem(COPY_ACTION);
    private final JMenu mnActions = new JMenu();
    private final JMenu mnProviders = new JMenu();
    private final JMenu mnLanguage = new JMenu();
    private final JMenu mnLogLevel = new JMenu();
    private final JMenu mnHelp = new JMenu();
    private final JMenuItem mntmAboutSdmxConnectors = new JMenuItem();
    private final JLabel lblDataflowFilter = new JLabel();
    private final JLabel lblDimension = new JLabel();
    private final JButton btnToggleVisible = new JButton();
    private final JButton btnClearSelectedDimension = new JButton();
    private final TitledBorder brdDataflowsPanel = this.createTitledBorder();
    private final TitledBorder brdFinalqueryPanel = this.createTitledBorder();
    private final TitledBorder brdDimensionsPanel = this.createTitledBorder();
    private final TitledBorder brdCodesPanel = this.createTitledBorder();
    private final JRadioButtonMenuItem[] mntmLogLevels = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem(), new JRadioButtonMenuItem(), new JRadioButtonMenuItem("", true), new JRadioButtonMenuItem(), new JRadioButtonMenuItem()};
    private String noResultsMessage;
    private String resultsCountMessage;
    private boolean isCodelistSortersMapTablesListenerActive;
    private SeriesCountPanel seriesCountPanel;

    public static void main(String[] stringArray) {
        String string = null;
        if (!(stringArray.length <= 0 || stringArray.length != 1 && stringArray.length <= 2 && "-s".equals(stringArray[0]))) {
            for (String string2 : HELP) {
                System.err.println(string2);
            }
            System.exit(1);
        } else if (stringArray.length == 2) {
            string = stringArray[1];
        }
        SDMXHelper.start(true, string);
    }

    private SDMXHelper() {
        this(false, null);
    }

    public static void start() {
        SDMXHelper.start(false);
    }

    public static void start(boolean bl) {
        SDMXHelper.start(bl, null);
    }

    public static void start(boolean bl, String string) {
        new SDMXHelper(bl, string);
    }

    public SDMXHelper(boolean bl, String string2) {
        Component component;
        Object object;
        Object object2;
        Serializable serializable;
        String string3 = Configuration.getLanguages().iterator().next().getRange();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it.bancaditalia.oss.sdmx.helper.bundles.HelperResources", Locale.forLanguageTag(string3));
        if (string2 != null) {
            if ("".equals(string2.trim())) {
                string2 = null;
            } else {
                LOGGER.info(resourceBundle.getString("SDMXHelper.28") + string2);
            }
        }
        this.setSize(1024, 768);
        this.setDefaultCloseOperation(bl ? 3 : 1);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.mnProviders);
        this.mnActions.setMnemonic(65);
        jMenuBar.add(this.mnActions);
        this.mntmCopySelection.setActionCommand(resourceBundle.getString("SDMXHelper.33"));
        this.mntmCopySelection.setMnemonic(65485);
        this.mnActions.add(this.mntmCopySelection);
        this.mntmBuildCommands.setMnemonic(66);
        this.mntmBuildCommands.addActionListener(actionEvent -> {
            try {
                if (this.selectedProviderGroup.getSelection() != null) {
                    new ToolCommandsFrame(this.getSelectedDataflow(), this.tfSdmxQuery.getText(), this.selectedProviderGroup.getSelection().getActionCommand());
                }
            }
            catch (SdmxException sdmxException) {
                LOGGER.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                LOGGER.log(Level.FINER, "", sdmxException);
            }
        });
        this.mntmAddProvider.addActionListener(actionEvent -> {
            NewProviderDialog newProviderDialog = new NewProviderDialog();
            if (newProviderDialog.getResult() == 0) {
                try {
                    String string = newProviderDialog.getName();
                    String string2 = newProviderDialog.getDescription();
                    SDMXVersion sDMXVersion = newProviderDialog.getSdmxVersion();
                    URI uRI = new URI(newProviderDialog.getURL());
                    SDMXClientFactory.addProvider(string, uRI, false, false, true, string2, sDMXVersion);
                    this.mnProviders.removeAll();
                    this.providersSetup(this.mnProviders);
                }
                catch (SdmxException | URISyntaxException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.mntmAddProvider.setMnemonic(80);
        ButtonGroup buttonGroup = new ButtonGroup();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("en");
        hashSet.add("it");
        hashSet.add("fr");
        for (Locale.LanguageRange object32 : Locale.LanguageRange.parse("en,de,fr,it")) {
            String i = object32.getRange();
            serializable = Locale.forLanguageTag(i);
            object2 = ResourceBundle.getBundle("it.bancaditalia.oss.sdmx.helper.bundles.HelperResources", (Locale)serializable);
            object = ((Locale)serializable).getDisplayLanguage((Locale)serializable).substring(0, 1).toUpperCase() + ((Locale)serializable).getDisplayLanguage((Locale)serializable).substring(1);
            component = new JRadioButtonMenuItem(String.format(((ResourceBundle)object2).getString("SDMXHelper.8"), object), i.equals(string3));
            component.addActionListener(arg_0 -> this.lambda$new$3((ResourceBundle)object2, (String)object, arg_0));
            buttonGroup.add((AbstractButton)component);
            this.mnLanguage.add((JMenuItem)component);
        }
        this.mnActions.add(this.mntmBuildCommands);
        this.mnActions.add(new JSeparator());
        this.mnActions.add(this.mntmAddProvider);
        this.mnActions.add(new JSeparator());
        this.mnActions.add(this.mnLanguage);
        Level[] levelArray = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINEST};
        ButtonGroup buttonGroup2 = new ButtonGroup();
        for (int jSplitPane = 0; jSplitPane < this.mntmLogLevels.length; ++jSplitPane) {
            serializable = this.mntmLogLevels[jSplitPane];
            object2 = levelArray[jSplitPane];
            ((AbstractButton)serializable).addActionListener(arg_0 -> SDMXHelper.lambda$new$4((Level)object2, arg_0));
            buttonGroup2.add((AbstractButton)serializable);
            this.mnLogLevel.add((JMenuItem)serializable);
        }
        this.mnActions.add(this.mnLogLevel);
        jMenuBar.add(this.mnHelp);
        this.mntmAboutSdmxConnectors.addActionListener(actionEvent -> new AboutContentFrame());
        this.mnHelp.add(this.mntmAboutSdmxConnectors);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setBorder(null);
        jSplitPane.setOrientation(0);
        serializable = new JPanel();
        ((JComponent)serializable).setMinimumSize(new java.awt.Dimension(10, 250));
        jSplitPane.setLeftComponent((Component)serializable);
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        object2 = new JPanel();
        ((JComponent)object2).setMaximumSize(new java.awt.Dimension(Short.MAX_VALUE, 70));
        ((JComponent)object2).setMinimumSize(new java.awt.Dimension(10, 70));
        ((JComponent)object2).setPreferredSize(new java.awt.Dimension(10, 60));
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        ((JComponent)object2).setBorder(new CompoundBorder(new EmptyBorder(5, 5, 0, 5), new CompoundBorder(this.brdFinalqueryPanel, new EmptyBorder(5, 5, 5, 5))));
        ((Container)serializable).add((Component)object2);
        this.lblQuery.setHorizontalAlignment(4);
        this.lblQuery.setPreferredSize(new java.awt.Dimension(150, 14));
        this.lblQuery.setMinimumSize(new java.awt.Dimension(200, 14));
        this.lblQuery.setMaximumSize(new java.awt.Dimension(200, 14));
        this.lblQuery.setSize(new java.awt.Dimension(200, 14));
        ((Container)object2).add(this.lblQuery);
        object = Box.createHorizontalStrut(10);
        ((Container)object2).add((Component)object);
        this.lblQuery.setLabelFor(this.tfSdmxQuery);
        this.tfSdmxQuery.setFont(new Font(null, 1, 16));
        this.tfSdmxQuery.setEditable(false);
        ((Container)object2).add(this.tfSdmxQuery);
        component = Box.createHorizontalStrut(10);
        ((Container)object2).add(component);
        this.btnCheckQuery.setEnabled(false);
        this.btnCheckQuery.setMinimumSize(new java.awt.Dimension(100, 23));
        this.btnCheckQuery.setMaximumSize(new java.awt.Dimension(300, 23));
        this.btnCheckQuery.addActionListener(actionEvent -> this.displayQueryResults());
        ((Container)object2).add(this.btnCheckQuery);
        Component component2 = Box.createHorizontalStrut(10);
        this.btnPrintQuery.setEnabled(false);
        this.btnPrintQuery.setPreferredSize(new java.awt.Dimension(240, 23));
        this.btnPrintQuery.setMinimumSize(new java.awt.Dimension(240, 23));
        this.btnPrintQuery.setMaximumSize(new java.awt.Dimension(240, 23));
        this.btnPrintQuery.addActionListener(actionEvent -> {
            System.out.println(this.tfSdmxQuery.getText());
            System.exit(0);
        });
        Component component3 = Box.createVerticalStrut(20);
        component3.setPreferredSize(new java.awt.Dimension(0, 10));
        component3.setMinimumSize(new java.awt.Dimension(0, 10));
        component3.setMaximumSize(new java.awt.Dimension(Short.MAX_VALUE, 10));
        ((Container)serializable).add(component3);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new java.awt.Dimension(10, 150));
        jPanel.setMinimumSize(new java.awt.Dimension(10, 150));
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(0, 5, 5, 5), new CompoundBorder(this.brdDataflowsPanel, new EmptyBorder(10, 10, 10, 10))));
        ((Container)serializable).add(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentY(0.0f);
        jPanel.add(jPanel2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.lblDataflowFilter);
        Component component4 = Box.createHorizontalStrut(10);
        jPanel2.add(component4);
        TableRowSorter<DataflowsModel> tableRowSorter = new TableRowSorter<DataflowsModel>(this.dataflowsTableModel);
        tableRowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.tfDataflowFilter.setPreferredSize(new java.awt.Dimension(6, 25));
        this.tfDataflowFilter.setMaximumSize(new java.awt.Dimension(Integer.MAX_VALUE, 25));
        this.tfDataflowFilter.setFont(new Font(null, 1, 16));
        this.tfDataflowFilter.setForeground(Color.RED);
        DoFilterListener doFilterListener = new DoFilterListener(this.tfDataflowFilter, string -> {
            String string2 = this.cbCaseSearchFlow.isSelected() ? "" : "(?i)";
            string2 = string2 + (this.cbRegexSearchFlow.isSelected() ? string : Pattern.quote(string));
            string2 = this.cbWholeWordFlow.isSelected() ? "^" + string2 + "$" : string2;
            try {
                Pattern.compile(string2);
                int[] nArray = new int[]{0};
                int[] nArray2 = new int[]{2};
                int[] nArray3 = new int[]{5};
                int[] nArray4 = new int[]{0, 2, 5};
                int[] nArray5 = this.rdSearchCodeFlow.isSelected() ? nArray : (this.rdSearchDSDFlow.isSelected() ? nArray2 : (this.rdSearchDescFlow.isSelected() ? nArray3 : nArray4));
                ((TableRowSorter)this.tblDataflows.getRowSorter()).setRowFilter(RowFilter.regexFilter(string2, nArray5));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        });
        this.tfDataflowFilter.getDocument().addDocumentListener(doFilterListener);
        jPanel2.add(this.tfDataflowFilter);
        Box box = Box.createHorizontalBox();
        box.setPreferredSize(new java.awt.Dimension(100, 200));
        box.setMinimumSize(new java.awt.Dimension(100, 200));
        box.setMaximumSize(new java.awt.Dimension(100, 200));
        this.seriesCountPanel = new SeriesCountPanel(0, 0);
        this.seriesCountPanel.setMinimumSize(new java.awt.Dimension(100, 25));
        this.seriesCountPanel.setMaximumSize(new java.awt.Dimension(Integer.MAX_VALUE, 25));
        this.seriesCountPanel.setPreferredSize(new java.awt.Dimension(400, 25));
        this.seriesCountPanel.hidePanel();
        JSplitPane jSplitPane2 = new JSplitPane();
        jSplitPane2.setOrientation(1);
        jSplitPane.setRightComponent(jSplitPane2);
        JPanel jPanel3 = new JPanel();
        jSplitPane2.setLeftComponent(jPanel3);
        jPanel3.setPreferredSize(new java.awt.Dimension(400, 200));
        jPanel3.setMinimumSize(new java.awt.Dimension(200, 150));
        jPanel3.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(this.brdDimensionsPanel, new EmptyBorder(10, 10, 10, 10))));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        Box box2 = Box.createHorizontalBox();
        box2.setPreferredSize(new java.awt.Dimension(10, 25));
        box2.setMinimumSize(new java.awt.Dimension(10, 25));
        box2.setMaximumSize(new java.awt.Dimension(32768, 25));
        jPanel3.add(box2);
        box2.add(this.lblDimension);
        Component component5 = Box.createHorizontalStrut(10);
        component5.setPreferredSize(new java.awt.Dimension(10, 20));
        component5.setMinimumSize(new java.awt.Dimension(10, 20));
        component5.setMaximumSize(new java.awt.Dimension(10, 20));
        box2.add(component5);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new java.awt.Dimension(200, 23));
        jScrollPane.setMinimumSize(new java.awt.Dimension(200, 23));
        jPanel3.add(jScrollPane);
        Box box3 = Box.createHorizontalBox();
        box2.setPreferredSize(new java.awt.Dimension(10, 25));
        box2.setMinimumSize(new java.awt.Dimension(10, 25));
        box2.setMaximumSize(new java.awt.Dimension(32768, 25));
        box3.add(this.seriesCountPanel);
        jPanel3.add(box3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setSize(new java.awt.Dimension(10, 150));
        jSplitPane2.setRightComponent(jPanel4);
        jPanel4.setPreferredSize(new java.awt.Dimension(400, 200));
        jPanel4.setMinimumSize(new java.awt.Dimension(200, 150));
        jPanel4.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(this.brdCodesPanel, new EmptyBorder(10, 10, 10, 10))));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        Box box4 = Box.createHorizontalBox();
        box4.setPreferredSize(new java.awt.Dimension(10, 25));
        box4.setMinimumSize(new java.awt.Dimension(10, 25));
        box4.setMaximumSize(new java.awt.Dimension(32768, 25));
        jPanel4.add(box4);
        box4.add(this.lblCodelist);
        Component component6 = Box.createHorizontalStrut(10);
        box4.add(component6);
        Box box5 = Box.createHorizontalBox();
        box5.setPreferredSize(new java.awt.Dimension(10, 25));
        box5.setMinimumSize(new java.awt.Dimension(10, 25));
        box5.setMaximumSize(new java.awt.Dimension(32768, 25));
        jPanel4.add(box5);
        DoFilterListener doFilterListener2 = new DoFilterListener(this.tfCodesFilter, string -> {
            String string2 = this.cbCaseSearchCL.isSelected() ? "" : "(?i)";
            string2 = string2 + (this.cbRegexSearchCL.isSelected() ? string : Pattern.quote(string));
            string2 = this.cbWholeWordCL.isSelected() ? "^" + string2 + "$" : string2;
            try {
                Pattern.compile(string2);
                int[] nArray = new int[]{1};
                int[] nArray2 = new int[]{2};
                int[] nArray3 = new int[]{1, 2};
                int[] nArray4 = this.rdSearchCodeCL.isSelected() ? nArray : (this.rdSearchDescCL.isSelected() ? nArray2 : nArray3);
                ((TableRowSorter)this.tblCodes.getRowSorter()).setRowFilter(RowFilter.regexFilter(string2, nArray4));
                this.updateCodelistCount();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        });
        this.cbRegexSearchCL.addActionListener(actionEvent -> {
            this.cbWholeWordCL.setSelected(false);
            doFilterListener2.filter();
        });
        box5.add(this.cbRegexSearchCL);
        Component component7 = Box.createHorizontalStrut(10);
        box5.add(component7);
        this.cbCaseSearchCL.addActionListener(actionEvent -> doFilterListener2.filter());
        box5.add(this.cbCaseSearchCL);
        Component component8 = Box.createHorizontalStrut(10);
        box5.add(component8);
        this.cbWholeWordCL.addActionListener(actionEvent -> {
            this.cbRegexSearchCL.setSelected(false);
            doFilterListener2.filter();
        });
        box5.add(this.cbWholeWordCL);
        Component component9 = Box.createHorizontalStrut(10);
        box5.add(component9);
        this.rdSearchCodeCL.addActionListener(actionEvent -> doFilterListener2.filter());
        this.codeSearchRadioGroup.add(this.rdSearchCodeCL);
        box5.add(this.rdSearchCodeCL);
        Component component10 = Box.createHorizontalStrut(10);
        box5.add(component10);
        this.rdSearchDescCL.addActionListener(actionEvent -> doFilterListener2.filter());
        this.codeSearchRadioGroup.add(this.rdSearchDescCL);
        box5.add(this.rdSearchDescCL);
        Component component11 = Box.createHorizontalStrut(10);
        box5.add(component11);
        this.rdSearchBothCL.addActionListener(actionEvent -> doFilterListener2.filter());
        this.codeSearchRadioGroup.add(this.rdSearchBothCL);
        this.rdSearchBothCL.setSelected(true);
        box5.add(this.rdSearchBothCL);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel4.add(jScrollPane2);
        this.tfCodesFilter.setForeground(Color.RED);
        this.tfCodesFilter.setFont(new Font("Dialog", 1, 16));
        this.tfCodesFilter.getDocument().addDocumentListener(doFilterListener2);
        box4.add(this.tfCodesFilter);
        this.btnToggleVisible.addActionListener(actionEvent -> {
            for (int i = 0; i < this.tblCodes.getRowCount(); ++i) {
                this.tblCodes.setValueAt((Boolean)this.tblCodes.getValueAt(i, this.tblCodes.convertColumnIndexToView(0)) == false, i, this.tblCodes.convertColumnIndexToView(0));
            }
            this.updateCodelistCount();
        });
        box4.add(this.btnToggleVisible);
        this.tblCodes.setAutoCreateColumnsFromModel(false);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[]{new TableColumn(0), new TableColumn(1), new TableColumn(2)};
        int[] nArray = new int[]{30, 100, 200};
        int[] nArray2 = new int[]{30, Integer.MAX_VALUE, Integer.MAX_VALUE};
        int[] nArray3 = new int[]{30, 100, 400};
        for (int box6 = 0; box6 < tableColumnArray.length; ++box6) {
            tableColumnArray[box6].setMinWidth(nArray[box6]);
            tableColumnArray[box6].setMaxWidth(nArray2[box6]);
            tableColumnArray[box6].setPreferredWidth(nArray3[box6]);
            tableColumnArray[box6].setResizable(box6 != 0);
            defaultTableColumnModel.addColumn(tableColumnArray[box6]);
        }
        this.tblCodes.setColumnModel(defaultTableColumnModel);
        this.tblCodes.getTableHeader().setReorderingAllowed(false);
        this.tblCodes.getTableHeader().setResizingAllowed(true);
        this.tblCodes.getDefaultEditor(Boolean.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                SDMXHelper.this.updateCodelistCount();
            }

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }
        });
        jScrollPane2.setViewportView(this.tblCodes);
        this.dimTableSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.tblDimensions.setModel(this.dimsTableModel);
        this.tblDimensions.getColumnModel().getColumn(0).setMinWidth(20);
        this.tblDimensions.getColumnModel().getColumn(0).setMaxWidth(20);
        this.tblDimensions.getColumnModel().getColumn(1).setMinWidth(150);
        this.tblDimensions.getColumnModel().getColumn(1).setMaxWidth(Integer.MAX_VALUE);
        this.tblDimensions.getColumnModel().getColumn(2).setMinWidth(200);
        this.tblDimensions.getColumnModel().getColumn(2).setMaxWidth(Integer.MAX_VALUE);
        this.tblDimensions.getColumnModel().getColumn(2).setPreferredWidth(400);
        this.tblDimensions.setRowSorter(this.dimTableSorter);
        this.tblDimensions.setSelectionMode(0);
        this.tblDimensions.getSelectionModel().addListSelectionListener(this::dimSelListener);
        jScrollPane.setViewportView(this.tblDimensions);
        this.tfDimensionFilter.setFont(new Font(null, 1, 16));
        this.tfDimensionFilter.setForeground(Color.RED);
        this.tfDimensionFilter.getDocument().addDocumentListener(new DoFilterListener(this.tfDimensionFilter, string -> this.dimTableSorter.setRowFilter(RowFilter.regexFilter("(?i)" + Pattern.quote(string), new int[0]))));
        box2.add(this.tfDimensionFilter);
        this.tblDataflows.setModel(this.dataflowsTableModel);
        this.tblDataflows.getColumnModel().getColumn(0).setMinWidth(120);
        this.tblDataflows.getColumnModel().getColumn(0).setMaxWidth(Integer.MAX_VALUE);
        this.tblDataflows.getColumnModel().getColumn(1).setMinWidth(60);
        this.tblDataflows.getColumnModel().getColumn(1).setMaxWidth(60);
        this.tblDataflows.getColumnModel().getColumn(2).setMinWidth(120);
        this.tblDataflows.getColumnModel().getColumn(2).setMaxWidth(Integer.MAX_VALUE);
        this.tblDataflows.getColumnModel().getColumn(3).setMinWidth(60);
        this.tblDataflows.getColumnModel().getColumn(3).setMaxWidth(60);
        this.tblDataflows.getColumnModel().getColumn(4).setMinWidth(60);
        this.tblDataflows.getColumnModel().getColumn(4).setMaxWidth(60);
        this.tblDataflows.getColumnModel().getColumn(5).setMinWidth(200);
        this.tblDataflows.getColumnModel().getColumn(5).setMaxWidth(Integer.MAX_VALUE);
        this.tblDataflows.getColumnModel().getColumn(5).setPreferredWidth(800);
        this.tblDataflows.setRowSorter(tableRowSorter);
        this.tblDataflows.setAutoCreateColumnsFromModel(false);
        this.tblDataflows.setSelectionMode(0);
        this.tblDataflows.getSelectionModel().addListSelectionListener(this::flowSelListener);
        Box box6 = Box.createHorizontalBox();
        box6.setAlignmentY(0.5f);
        box6.setPreferredSize(new java.awt.Dimension(10, 25));
        box6.setMinimumSize(new java.awt.Dimension(10, 25));
        box6.setMaximumSize(new java.awt.Dimension(32768, 25));
        jPanel.add(box6);
        this.cbRegexSearchFlow.addActionListener(actionEvent -> {
            this.cbCaseSearchFlow.setEnabled(false);
            doFilterListener.filter();
        });
        box6.add(this.cbRegexSearchFlow);
        Component component12 = Box.createHorizontalStrut(10);
        box6.add(component12);
        this.cbCaseSearchFlow.addActionListener(actionEvent -> {
            this.cbRegexSearchFlow.setEnabled(false);
            doFilterListener.filter();
        });
        box6.add(this.cbCaseSearchFlow);
        Component component13 = Box.createHorizontalStrut(10);
        box6.add(component13);
        this.cbWholeWordFlow.addActionListener(actionEvent -> doFilterListener.filter());
        box6.add(this.cbWholeWordFlow);
        Component component14 = Box.createHorizontalStrut(10);
        box6.add(component14);
        this.rdSearchCodeFlow.addActionListener(actionEvent -> doFilterListener.filter());
        this.flowSearchRadioGroup.add(this.rdSearchCodeFlow);
        box6.add(this.rdSearchCodeFlow);
        Component component15 = Box.createHorizontalStrut(10);
        box6.add(component15);
        this.rdSearchDSDFlow.addActionListener(actionEvent -> doFilterListener.filter());
        this.flowSearchRadioGroup.add(this.rdSearchDSDFlow);
        box6.add(this.rdSearchDSDFlow);
        Component component16 = Box.createHorizontalStrut(10);
        box6.add(component16);
        this.rdSearchDescFlow.addActionListener(actionEvent -> doFilterListener.filter());
        this.flowSearchRadioGroup.add(this.rdSearchDescFlow);
        box6.add(this.rdSearchDescFlow);
        Component component17 = Box.createHorizontalStrut(10);
        box6.add(component17);
        this.rdSearchAllFlow.addActionListener(actionEvent -> doFilterListener.filter());
        this.flowSearchRadioGroup.add(this.rdSearchAllFlow);
        this.rdSearchAllFlow.setSelected(true);
        box6.add(this.rdSearchAllFlow);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setAlignmentY(1.0f);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setViewportView(this.tblDataflows);
        jPanel.add(jScrollPane3);
        this.btnClearSelectedDimension.addActionListener(actionEvent -> {
            if (this.getSelectedDataflow() != null) {
                this.isCodelistSortersMapTablesListenerActive = false;
                ((CheckboxListTableModel)this.tblCodes.getModel()).uncheckAll();
                this.updateCodelistCount();
                this.isCodelistSortersMapTablesListenerActive = true;
                if (SDMXVersion.V3 == ((Provider)SDMXClientFactory.getProviders().get(this.getSelectedProvider())).getSdmxVersion()) {
                    this.updateSeriesCounts(this.getSelectedDataflow(), new ArrayList<Dimension>());
                }
            }
        });
        this.btnClearSelectedDimension.setMaximumSize(new java.awt.Dimension(151, 32768));
        box2.add(this.btnClearSelectedDimension);
        final JTextPane jTextPane = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.viewToModel(mouseEvent.getPoint());
                if (n >= 0) {
                    AttributeSet attributeSet = this.getStyledDocument().getCharacterElement(n).getAttributes();
                    return attributeSet.getAttribute("TIME") == null ? null : String.format(SDMXHelper.TOOLTIP_FORMAT, new Date());
                }
                return null;
            }
        };
        jTextPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jTextPane.setBackground(new Color(224, 224, 224));
        Font font = new Font("Monospaced", 0, 12);
        jTextPane.setFont(font);
        jTextPane.setEditable(false);
        ToolTipManager.sharedInstance().registerComponent(jTextPane);
        jTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AttributeSet attributeSet;
                Object object;
                int n = jTextPane.viewToModel(mouseEvent.getPoint());
                if (n >= 0 && (object = (attributeSet = jTextPane.getStyledDocument().getCharacterElement(n).getAttributes()).getAttribute("URL")) != null) {
                    try {
                        Desktop.getDesktop().browse(new URI(object.toString()));
                    }
                    catch (IOException | URISyntaxException exception) {
                        // empty catch block
                    }
                }
            }
        });
        LOGGER.addHandler(new HelperHandler(jTextPane));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add(jTextPane);
        JScrollPane jScrollPane4 = new JScrollPane(jPanel5);
        jScrollPane4.setBorder(new EmptyBorder(0, 0, 0, 0));
        JSplitPane jSplitPane3 = new JSplitPane();
        jSplitPane3.setBorder(null);
        jSplitPane3.setOrientation(0);
        jSplitPane3.setLeftComponent(jSplitPane);
        jSplitPane3.setRightComponent(jScrollPane4);
        this.setContentPane(jSplitPane3);
        this.providersSetup(this.mnProviders);
        if (string2 != null) {
            for (AbstractButton abstractButton : Collections.list(this.selectedProviderGroup.getElements())) {
                if (!string2.equalsIgnoreCase(abstractButton.getActionCommand())) continue;
                this.selectedProviderGroup.setSelected(abstractButton.getModel(), true);
                abstractButton.doClick();
            }
            ((Container)object2).add(component2);
            ((Container)object2).add(this.btnPrintQuery);
            this.mnProviders.setEnabled(false);
            this.mnProviders.setText(this.mnProviders.getText() + ": " + string2);
        }
        this.updateBundle(resourceBundle);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            jSplitPane.setDividerLocation(0.75);
            jSplitPane3.setDividerLocation(0.8);
        });
    }

    private void updateBundle(ResourceBundle resourceBundle) {
        this.setTitle(resourceBundle.getString("SDMXHelper.30"));
        Configuration.setLanguages(resourceBundle.getLocale().toLanguageTag() + ",en;q=0.8,*;q=0.6");
        this.brdCodesPanel.setTitle(resourceBundle.getString("SDMXHelper.60"));
        this.brdDataflowsPanel.setTitle(resourceBundle.getString("SDMXHelper.52"));
        this.brdDimensionsPanel.setTitle(resourceBundle.getString("SDMXHelper.58"));
        this.brdFinalqueryPanel.setTitle(resourceBundle.getString("SDMXHelper.48"));
        this.btnCheckQuery.putClientProperty("FORMAT", resourceBundle.getString("SDMXHelper.50"));
        this.btnCheckQuery.setText(String.format(resourceBundle.getString("SDMXHelper.50"), ""));
        this.btnClearSelectedDimension.setText(resourceBundle.getString("SDMXHelper.72"));
        this.btnPrintQuery.setText(resourceBundle.getString("SDMXHelper.51"));
        this.btnToggleVisible.setText(resourceBundle.getString("SDMXHelper.67"));
        this.cbCaseSearchCL.setText(resourceBundle.getString("SDMXHelper.14"));
        this.cbCaseSearchFlow.setText(resourceBundle.getString("SDMXHelper.24"));
        this.cbRegexSearchCL.setText(resourceBundle.getString("SDMXHelper.13"));
        this.cbRegexSearchFlow.setText(resourceBundle.getString("SDMXHelper.25"));
        this.cbWholeWordCL.setText(resourceBundle.getString("SDMXHelper.15"));
        this.cbWholeWordFlow.setText(resourceBundle.getString("SDMXHelper.23"));
        this.lblCodelist.setText(resourceBundle.getString("SDMXHelper.61"));
        this.lblDataflowFilter.setText(resourceBundle.getString("SDMXHelper.53"));
        this.lblDimension.setText(resourceBundle.getString("SDMXHelper.59"));
        this.lblQuery.setText(resourceBundle.getString("SDMXHelper.49"));
        this.mnActions.setText(resourceBundle.getString("SDMXHelper.32"));
        this.mnHelp.setText(resourceBundle.getString("SDMXHelper.46"));
        this.mnLanguage.setText(resourceBundle.getString("SDMXHelper.6"));
        this.mnLogLevel.setText(resourceBundle.getString("SDMXHelper.40"));
        this.mnProviders.setText(resourceBundle.getString("SDMXHelper.31"));
        this.mntmAddProvider.setText(resourceBundle.getString("SDMXHelper.39"));
        this.mntmAboutSdmxConnectors.setText(resourceBundle.getString("SDMXHelper.47"));
        this.mntmBuildCommands.setText(resourceBundle.getString("SDMXHelper.35"));
        this.mntmCopySelection.setText(resourceBundle.getString("SDMXHelper.34"));
        this.mntmLogLevels[0].setText(resourceBundle.getString("SDMXHelper.41"));
        this.mntmLogLevels[1].setText(resourceBundle.getString("SDMXHelper.42"));
        this.mntmLogLevels[2].setText(resourceBundle.getString("SDMXHelper.43"));
        this.mntmLogLevels[3].setText(resourceBundle.getString("SDMXHelper.44"));
        this.mntmLogLevels[4].setText(resourceBundle.getString("SDMXHelper.45"));
        this.rdSearchAllFlow.setText(resourceBundle.getString("SDMXHelper.22"));
        this.rdSearchBothCL.setText(resourceBundle.getString("SDMXHelper.18"));
        this.rdSearchCodeCL.setText(resourceBundle.getString("SDMXHelper.16"));
        this.rdSearchCodeFlow.setText(resourceBundle.getString("SDMXHelper.19"));
        this.rdSearchDescCL.setText(resourceBundle.getString("SDMXHelper.17"));
        this.rdSearchDescFlow.setText(resourceBundle.getString("SDMXHelper.21"));
        this.rdSearchDSDFlow.setText(resourceBundle.getString("SDMXHelper.20"));
        this.tblCodes.getColumnModel().getColumn(0).setHeaderValue("");
        this.tblCodes.getColumnModel().getColumn(1).setHeaderValue(resourceBundle.getString("SDMXHelper.69"));
        this.tblCodes.getColumnModel().getColumn(2).setHeaderValue(resourceBundle.getString("SDMXHelper.70"));
        this.tblDataflows.getColumnModel().getColumn(0).setHeaderValue(resourceBundle.getString("SDMXHelper.0"));
        this.tblDataflows.getColumnModel().getColumn(1).setHeaderValue(resourceBundle.getString("SDMXHelper.1"));
        this.tblDataflows.getColumnModel().getColumn(2).setHeaderValue(resourceBundle.getString("SDMXHelper.2"));
        this.tblDataflows.getColumnModel().getColumn(3).setHeaderValue(resourceBundle.getString("SDMXHelper.3"));
        this.tblDataflows.getColumnModel().getColumn(4).setHeaderValue(resourceBundle.getString("SDMXHelper.4"));
        this.tblDataflows.getColumnModel().getColumn(5).setHeaderValue(resourceBundle.getString("SDMXHelper.5"));
        this.tblDimensions.getColumnModel().getColumn(0).setHeaderValue("");
        this.tblDimensions.getColumnModel().getColumn(1).setHeaderValue(resourceBundle.getString("SDMXHelper.11"));
        this.tblDimensions.getColumnModel().getColumn(2).setHeaderValue(resourceBundle.getString("SDMXHelper.12"));
        this.noResultsMessage = resourceBundle.getString("SDMXHelper.89");
        this.resultsCountMessage = resourceBundle.getString("SDMXHelper.91");
        this.seriesCountPanel.updateBundle(resourceBundle);
    }

    private void flowSelListener(ListSelectionEvent listSelectionEvent) {
        String string = this.getSelectedDataflow();
        if (!listSelectionEvent.getValueIsAdjusting() && string != null) {
            this.updateDataflow(string);
            this.tfDimensionFilter.setText("");
            this.dimTableSorter.setRowFilter(null);
            this.btnCheckQuery.setEnabled(true);
            this.btnPrintQuery.setEnabled(true);
        }
    }

    private void dimSelListener(ListSelectionEvent listSelectionEvent) {
        String string = this.getSelectedDimension();
        String string2 = this.selectedProviderGroup.getSelection().getActionCommand();
        if (listSelectionEvent.getValueIsAdjusting() || string == null) {
            return;
        }
        List<RowSorter.SortKey> list = this.tblCodes.getRowSorter() == null ? null : this.tblCodes.getRowSorter().getSortKeys();
        final String string3 = this.getSelectedDataflow();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        new ProgressViewer<Map>(this, atomicBoolean, () -> SDMXVersion.V3 == ((Provider)SDMXClientFactory.getProviders().get(string2)).getSdmxVersion() ? SdmxClientHandler.filterCodes(string2, string3, this.createAvailabilityFilter()).get(string) : SdmxClientHandler.getCodes(string2, string3, string), map -> {
            Object object;
            CheckboxListTableModel checkboxListTableModel = new CheckboxListTableModel();
            checkboxListTableModel.addTableModelListener(tableModelEvent -> this.tfSdmxQuery.setText(this.createQuery(this.dimsTableModel.getSource())));
            checkboxListTableModel.setItems((Map<String, String>)map);
            if (this.codelistSortersMap.get(string) != null) {
                object = ((CheckboxListTableModel)this.codelistSortersMap.get(string).getModel()).getCheckedCodes();
                checkboxListTableModel.updateCheckedCodes((Collection<String>)object);
            }
            object = new TableRowSorter(checkboxListTableModel);
            this.codelistSortersMap.put(string, (TableRowSorter<CheckboxListTableModel<String>>)object);
            if (SDMXVersion.V3 == ((Provider)SDMXClientFactory.getProviders().get(string2)).getSdmxVersion()) {
                TableModelListener tableModelListener = new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        SDMXHelper.this.updateSeriesCounts(string3, SDMXHelper.this.dimsTableModel.getSource());
                    }
                };
                checkboxListTableModel.addTableModelListener(tableModelListener);
            }
        }, throwable -> {
            atomicBoolean.set(true);
            LOGGER.severe(throwable.getClass().getName() + ": " + throwable.getMessage());
            LOGGER.log(Level.FINER, "", (Throwable)throwable);
        }).start();
        SwingUtilities.invokeLater(() -> {
            if (!atomicBoolean.get()) {
                TableRowSorter<CheckboxListTableModel<String>> tableRowSorter = this.codelistSortersMap.get(string);
                this.tblCodes.setModel((TableModel)tableRowSorter.getModel());
                this.tblCodes.setRowSorter(tableRowSorter);
                if (list == null || list.isEmpty()) {
                    tableRowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(1, SortOrder.ASCENDING)));
                } else {
                    tableRowSorter.setSortKeys(list);
                }
                tableRowSorter.setSortable(this.tblCodes.convertColumnIndexToView(0), false);
                tableRowSorter.setRowFilter(null);
                this.tfCodesFilter.setText("");
                this.tblCodes.revalidate();
                this.updateCodelistCount();
            }
        });
    }

    private void updateCodelistCount() {
        int n = 0;
        for (int i = 0; i < this.tblCodes.getRowCount(); ++i) {
            n += (Boolean)this.tblCodes.getModel().getValueAt(this.tblCodes.convertRowIndexToModel(i), 0) != false ? 1 : 0;
        }
        this.lblCodelist.setText("Filter codes (" + n + "/" + this.tblCodes.getRowCount() + "):");
    }

    private void updateDataflow(String string) {
        this.isCodelistSortersMapTablesListenerActive = false;
        this.codelistSortersMap.clear();
        ((CheckboxListTableModel)this.tblCodes.getModel()).clear();
        this.seriesCountPanel.updateCounts(0, 0);
        this.dimsTableModel.clear();
        String string2 = (String)this.btnCheckQuery.getClientProperty("FORMAT");
        this.btnCheckQuery.setText(String.format(string2, ""));
        this.isCodelistSortersMapTablesListenerActive = true;
        new ProgressViewer<List>(this, new AtomicBoolean(false), () -> SdmxClientHandler.getDimensions(this.selectedProviderGroup.getSelection().getActionCommand(), string), var1_1 -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, throwable -> {
            LOGGER.severe("Exception. Class: " + throwable.getClass().getName() + " .Message: " + throwable.getMessage());
            LOGGER.log(Level.FINER, "", (Throwable)throwable);
        }).start();
    }

    private void displayQueryResults() {
        String string = this.tfSdmxQuery.getText();
        String string2 = this.getSelectedDataflow();
        String string3 = this.getSelectedProvider();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        if (string2 != null && string != null && !string.isEmpty()) {
            new ProgressViewer<AbstractMap.SimpleEntry>(this, atomicBoolean, () -> {
                try {
                    Dataflow dataflow = SdmxClientHandler.getFlow(string3, string2);
                    List<PortableTimeSeries<Double>> list = null;
                    list = SDMXVersion.V3 == ((Provider)SDMXClientFactory.getProviders().get(string3)).getSdmxVersion() ? SdmxClientHandler.getTimeSeries2(string3, dataflow.getId(), null, string, null, null, "none", "none", null, false) : SdmxClientHandler.getTimeSeries(string3, dataflow.getId() + "/" + string, null, null, true, null, false);
                    return new AbstractMap.SimpleEntry<Dataflow, List<PortableTimeSeries<Double>>>(dataflow, list);
                }
                catch (SdmxResponseException sdmxResponseException) {
                    if (sdmxResponseException.getResponseCode() != 100) {
                        throw sdmxResponseException;
                    }
                    atomicBoolean.set(true);
                    JOptionPane.showMessageDialog(null, this.noResultsMessage, "SDMX Helper", 2);
                    return new AbstractMap.SimpleEntry<Object, Object>(null, null);
                }
            }, simpleEntry -> {
                if (!atomicBoolean.get()) {
                    Dataflow dataflow = (Dataflow)simpleEntry.getKey();
                    List list = (List)simpleEntry.getValue();
                    ResultsFrame resultsFrame = new ResultsFrame(this.getSelectedProvider(), dataflow.getId(), list);
                    resultsFrame.setTitle(String.format(this.resultsCountMessage, list.size(), dataflow.getDescription()));
                    resultsFrame.setVisible(true);
                    resultsFrame.toFront();
                }
            }, throwable -> {
                LOGGER.severe("Exception. Class: " + throwable.getClass().getName() + " .Message: " + throwable.getMessage());
                LOGGER.log(Level.FINER, "", (Throwable)throwable);
            }).start();
        }
    }

    private void providersSetup(JMenu jMenu) {
        for (Map.Entry entry : SDMXClientFactory.getProviders().entrySet()) {
            String string = (String)entry.getKey();
            SDMXVersion sDMXVersion = ((Provider)entry.getValue()).getSdmxVersion();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("[" + (Object)((Object)sDMXVersion) + "] " + string + ": " + ((Provider)entry.getValue()).getDescription());
            jRadioButtonMenuItem.setActionCommand(string);
            jRadioButtonMenuItem.addActionListener(actionEvent -> {
                try {
                    jRadioButtonMenuItem.setSelected(true);
                    this.updateSource(string);
                    this.btnCheckQuery.setEnabled(false);
                    this.btnPrintQuery.setEnabled(false);
                    String string2 = (String)this.btnCheckQuery.getClientProperty("FORMAT");
                    this.btnCheckQuery.setText(String.format(string2, ""));
                    this.tfSdmxQuery.setText("");
                    this.tfDataflowFilter.setText("");
                    this.lblQuery.setText(this.lblQuery.getText().split(":")[0] + ": " + string);
                    if (SDMXVersion.V3 == ((Provider)SDMXClientFactory.getProviders().get(string)).getSdmxVersion()) {
                        this.seriesCountPanel.showPanel();
                    } else {
                        this.seriesCountPanel.hidePanel();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
            jMenu.add(jRadioButtonMenuItem);
            this.selectedProviderGroup.add(jRadioButtonMenuItem);
        }
    }

    private void updateSource(String string) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        new ProgressViewer<Map>(this, atomicBoolean, () -> SdmxClientHandler.getFlowObjects(string, null), map -> {
            if (!atomicBoolean.get()) {
                this.isCodelistSortersMapTablesListenerActive = false;
                this.codelistSortersMap.clear();
                this.tblCodes.setRowSorter(null);
                this.tblCodes.setModel(new CheckboxListTableModel());
                this.dimsTableModel.clear();
                this.dataflowsTableModel.setItems((Map<String, Dataflow>)map);
                TableRowSorter<DataflowsModel> tableRowSorter = new TableRowSorter<DataflowsModel>(this.dataflowsTableModel);
                tableRowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
                this.tblDataflows.setRowSorter(tableRowSorter);
                this.seriesCountPanel.updateCounts(0, 0);
                this.isCodelistSortersMapTablesListenerActive = true;
            }
        }, throwable -> {
            LOGGER.severe("Exception. Class: " + throwable.getClass().getName() + " .Message: " + throwable.getMessage());
            LOGGER.log(Level.FINER, "", (Throwable)throwable);
        }).start();
    }

    private String createQuery(List<Dimension> list) {
        String string2 = "";
        try {
            string2 = SDMXVersion.V3 == ((Provider)SDMXClientFactory.getProviders().get(this.getSelectedProvider())).getSdmxVersion() ? this.createAvailabilityFilter() : list.stream().map(SdmxMetaElement::getId).map(string -> this.codelistSortersMap.containsKey(string) ? String.join((CharSequence)"+", ((CheckboxListTableModel)this.codelistSortersMap.get(string).getModel()).getCheckedCodes()) : "").collect(Collectors.joining("."));
        }
        catch (SdmxException sdmxException) {
            LOGGER.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
            LOGGER.log(Level.FINER, "", sdmxException);
        }
        return string2;
    }

    private void updateSeriesCounts(String string, List<Dimension> list) {
        if (!this.isCodelistSortersMapTablesListenerActive) {
            return;
        }
        try {
            Map<String, Integer> map = SdmxClientHandler.getSeriesCount(this.getSelectedProvider(), string, this.createQuery(list));
            int n = map.getOrDefault("series_count", 0);
            int n2 = map.getOrDefault("obs_count", 0);
            this.seriesCountPanel.updateCounts(n, n2);
        }
        catch (SdmxException sdmxException) {
            sdmxException.printStackTrace();
        }
    }

    private String createAvailabilityFilter() throws SdmxException {
        List<Dimension> list = SdmxClientHandler.getDimensions(this.getSelectedProvider(), this.getSelectedDataflow());
        return list.stream().map(SdmxMetaElement::getId).filter(this.codelistSortersMap::containsKey).filter(string -> ((CheckboxListTableModel)this.codelistSortersMap.get(string).getModel()).getCheckedCodesCount() > 0).map(string -> "c[" + string + "]=" + String.join((CharSequence)",", ((CheckboxListTableModel)this.codelistSortersMap.get(string).getModel()).getCheckedCodes())).collect(Collectors.joining("&"));
    }

    private String getSelectedDataflow() {
        int n = this.tblDataflows.getSelectedRow();
        return n != -1 ? this.tblDataflows.getValueAt(n, this.tblDataflows.convertColumnIndexToView(0)).toString() : null;
    }

    private String getSelectedProvider() {
        ButtonModel buttonModel = this.selectedProviderGroup.getSelection();
        return buttonModel.getActionCommand();
    }

    private String getSelectedDimension() {
        int n = this.tblDimensions.getSelectedRow();
        return n == -1 ? null : this.tblDimensions.getValueAt(n, this.tblDimensions.convertColumnIndexToView(1)).toString();
    }

    private TitledBorder createTitledBorder() {
        return new TitledBorder(new EtchedBorder(1, null, null), "", 4, 2, null, new Color(0, 0, 0));
    }

    private static /* synthetic */ void lambda$new$4(Level level, ActionEvent actionEvent) {
        Configuration.getSdmxLogger().setLevel(level);
    }

    private /* synthetic */ void lambda$new$3(ResourceBundle resourceBundle, String string, ActionEvent actionEvent) {
        LOGGER.info(String.format(resourceBundle.getString("SDMXHelper.7"), string));
        this.updateBundle(resourceBundle);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError("Operating system must provide a valid graphic environment.");
            exceptionInInitializerError.initCause(exception);
            throw exceptionInInitializerError;
        }
        try {
            ICON_MIN = ImageIO.read(SDMXHelper.class.getResourceAsStream("min.png"));
            ICON_MAX = ImageIO.read(SDMXHelper.class.getResourceAsStream("max.png"));
        }
        catch (Exception exception) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(null, "Cannot load resources from jar file.", "SDMXHelper", 0);
                atomicBoolean.set(true);
            });
            while (!atomicBoolean.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new ExceptionInInitializerError(exception);
        }
        LOGGER = Configuration.getSdmxLogger();
        HELP = new String[]{"Opens the SDMX Helper navigation tool window.", "", "java " + SDMXHelper.class.getName() + " [-s <provider>]", "", "    -s    Enable \"print query\" button and lock SDMXHelper on the specified provider."};
    }

    class SeriesCountPanel
    extends JPanel {
        private JLabel seriesCountLabel = new JLabel();
        private JTextField seriesCount;
        private JLabel obsCountLabel;
        private JTextField obsCount;

        public SeriesCountPanel(int n, int n2) {
            this.seriesCount = new JTextField(Integer.toString(n));
            this.seriesCount.setEditable(false);
            this.seriesCount.setMinimumSize(new java.awt.Dimension(100, 33));
            this.obsCountLabel = new JLabel();
            this.obsCount = new JTextField(Integer.toString(n2));
            this.obsCount.setEditable(false);
            this.obsCount.setMinimumSize(new java.awt.Dimension(100, 33));
            this.add(this.seriesCountLabel);
            this.add(this.seriesCount);
            this.add(this.obsCountLabel);
            this.add(this.obsCount);
        }

        public void updateCounts(int n, int n2) {
            this.seriesCount.setText(Integer.toString(n));
            this.seriesCount.setCaretPosition(0);
            this.obsCount.setText(Integer.toString(n2));
            this.obsCount.setCaretPosition(0);
            if (n <= 0) {
                this.hideSeriesCount();
            } else {
                this.showSeriesCount();
            }
            if (n2 <= 0) {
                this.hideObsCount();
            } else {
                this.showObsCount();
            }
        }

        public void updateBundle(ResourceBundle resourceBundle) {
            this.seriesCountLabel.setText(resourceBundle.getString("SDMXHelper.105"));
            this.obsCountLabel.setText(resourceBundle.getString("SDMXHelper.106"));
        }

        public void hidePanel() {
            this.seriesCount.setVisible(false);
            this.seriesCountLabel.setVisible(false);
            this.obsCount.setVisible(false);
            this.obsCountLabel.setVisible(false);
            this.setVisible(false);
        }

        public void showPanel() {
            this.seriesCount.setVisible(true);
            this.seriesCountLabel.setVisible(true);
            this.obsCount.setVisible(true);
            this.obsCountLabel.setVisible(true);
            this.setVisible(true);
        }

        public void hideSeriesCount() {
            this.seriesCountLabel.setVisible(false);
            this.seriesCount.setVisible(false);
        }

        public void showSeriesCount() {
            this.seriesCountLabel.setVisible(true);
            this.seriesCount.setVisible(true);
        }

        public void hideObsCount() {
            this.obsCountLabel.setVisible(false);
            this.obsCount.setVisible(false);
        }

        public void showObsCount() {
            this.obsCountLabel.setVisible(true);
            this.obsCount.setVisible(true);
        }
    }
}

