% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfSaveDataFile.R
\name{DfSaveDataFile}
\alias{DfSaveDataFile}
\title{Save ROC data file in a different format}
\usage{
DfSaveDataFile(dataset, fileName, format = "JAFROC", 
   dataDescription = paste0(deparse(substitute(dataset)), " Data File"))
}
\arguments{
\item{dataset}{{The dataset to be saved in the specified format, 
see \link{RJafroc-package}}}

\item{fileName}{{The file name of the output data file. The extension 
of the data file must match the corresponding format, see \link{RJafroc-package}}}

\item{format}{{The format of the data file, which can be \code{"JAFROC"}, 
\code{"MRMC"} or \code{"iMRMC"}, see \link{RJafroc-package}}}

\item{dataDescription}{{An optional string variable describing the data file, the 
default value is the variable name of \code{dataset} The description appears on 
the first line of *.lrc or *imrmc data file. This parameter is not used 
when saving dataset in other formats}}
}
\description{
Save ROC data file in a different format so it can be analyzed 
   with alternate software
}
\examples{
DfSaveDataFile(dataset = dataset05, 
   fileName = "rocData2.xlsx", format = "JAFROC")
DfSaveDataFile(dataset = dataset02, 
   fileName = "rocData2.csv", format = "MRMC")
DfSaveDataFile(dataset = dataset02, 
   fileName = "rocData2.lrc", format = "MRMC", 
   dataDescription = "ExampleROCdata1")
DfSaveDataFile(dataset = dataset02, 
   fileName = "rocData2.txt", format = "MRMC", 
   dataDescription = "ExampleROCdata2")
DfSaveDataFile(dataset = dataset02, 
   fileName = "dataset05.imrmc", format = "iMRMC", 
   dataDescription = "ExampleROCdata3") 

}
