/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.shared.ReificationStyle;

public class Factory {
    public static final boolean faster = JenaRuntime.getSystemProperty("jena.faster", "yes").equals("yes");
    public static final boolean newHashing = JenaRuntime.getSystemProperty("jena.hashing", "yes").equals("yes");

    private Factory() {
    }

    public static Graph createDefaultGraph() {
        return Factory.createDefaultGraph(ReificationStyle.Standard);
    }

    public static Graph createDefaultGraph(ReificationStyle style) {
        return Factory.createGraphMem(style);
    }

    public static Graph createGraphMem() {
        return faster ? new GraphMemFaster() : new GraphMem();
    }

    public static Graph createGraphMem(ReificationStyle style) {
        return faster ? new GraphMemFaster(style) : new GraphMem(style);
    }
}

