/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TransitiveGraphCache
implements Finder {
    protected boolean cacheTriples = false;
    protected HashMap nodeMap = new HashMap();
    protected Node directPredicate;
    protected Node closedPredicate;
    protected Set deletesPending;
    protected Set originalTriples = new HashSet();

    public TransitiveGraphCache(Node directPredicate, Node closedPredicate) {
        this.directPredicate = directPredicate;
        this.closedPredicate = closedPredicate;
    }

    public Node getClosedPredicate() {
        return this.closedPredicate;
    }

    public Node getDirectPredicate() {
        return this.directPredicate;
    }

    public synchronized void addRelation(Triple t) {
        this.originalTriples.add(t);
        this.addRelation(t.getSubject(), t.getObject());
    }

    private void addRelation(Node start, Node end) {
        GraphNode endN;
        if (start.equals(end)) {
            return;
        }
        GraphNode startN = this.getLead(start);
        if (startN.pathTo(endN = this.getLead(end))) {
            return;
        }
        boolean needJoin = endN.pathTo(startN);
        HashSet<GraphNode> members = null;
        if (needJoin) {
            members = new HashSet<GraphNode>();
            members.add(endN);
            startN.visitPredecessors(new Visitor(){

                public void visit(GraphNode node, Object members, Object endN) {
                    if (((GraphNode)endN).pathTo(node)) {
                        ((Set)members).add(node);
                    }
                }
            }, members, endN);
            startN.makeLeadNodeFor(members);
            startN.propagateSCC();
        } else {
            startN.propagateAdd(endN);
            startN.assertLinkTo(endN);
        }
        if (needJoin) {
            // empty if block
        }
    }

    public void removeRelation(Triple t) {
        GraphNode endN;
        Node end;
        Node start = t.getSubject();
        if (start == (end = t.getObject())) {
            return;
        }
        GraphNode startN = this.getLead(start);
        if (startN != (endN = this.getLead(end)) && !startN.directPathTo(endN)) {
            return;
        }
        if (this.deletesPending == null) {
            this.deletesPending = new HashSet();
        }
        this.deletesPending.add(t);
    }

    private void processDeletes() {
        Iterator j;
        GraphNode n;
        HashSet<GraphNode> kernel = new HashSet<GraphNode>();
        Iterator i = this.deletesPending.iterator();
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            GraphNode start = (GraphNode)this.nodeMap.get(t.getSubject());
            kernel.add(start);
        }
        HashSet<GraphNode> pKernel = new HashSet<GraphNode>();
        pKernel.addAll(kernel);
        Iterator<Object> i2 = this.nodeMap.values().iterator();
        block1: while (i2.hasNext()) {
            n = (GraphNode)i2.next();
            j = kernel.iterator();
            while (j.hasNext()) {
                GraphNode target = (GraphNode)j.next();
                if (!n.pathTo(target)) continue;
                pKernel.add(n);
                continue block1;
            }
        }
        i2 = pKernel.iterator();
        while (i2.hasNext()) {
            n = (GraphNode)i2.next();
            j = n.succ.iterator();
            while (j.hasNext()) {
                GraphNode fringe = (GraphNode)j.next();
                if (pKernel.contains(fringe)) continue;
                fringe.pred.remove(n);
            }
            n.succ.clear();
            n.succClosed.clear();
            n.pred.clear();
        }
        this.originalTriples.removeAll(this.deletesPending);
        this.deletesPending.clear();
        i2 = this.originalTriples.iterator();
        while (i2.hasNext()) {
            Triple t = (Triple)i2.next();
            GraphNode n2 = (GraphNode)this.nodeMap.get(t.getSubject());
            if (!pKernel.contains(n2)) continue;
            this.addRelation(t);
        }
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        Node p = pattern.getPredicate();
        if (p.isVariable()) {
            return this.find(pattern).andThen(continuation.find(pattern));
        }
        if (p.equals(this.directPredicate) || p.equals(this.closedPredicate)) {
            return this.find(pattern);
        }
        return continuation.find(pattern);
    }

    public boolean contains(TriplePattern pattern) {
        ExtendedIterator it = this.find(pattern);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    public ExtendedIterator listAllSubjects() {
        return WrappedIterator.create(this.nodeMap.keySet().iterator());
    }

    public boolean isSubject(Node node) {
        return this.nodeMap.keySet().contains(node);
    }

    public boolean cacheAll(Finder graph, Node predicate) {
        ExtendedIterator it = graph.find(new TriplePattern(null, predicate, null));
        boolean foundsome = it.hasNext();
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            this.addRelation(triple);
        }
        it.close();
        return foundsome;
    }

    public ExtendedIterator find(TriplePattern pattern) {
        if (this.deletesPending != null && this.deletesPending.size() > 0) {
            this.processDeletes();
        }
        Node s = pattern.getSubject();
        Node p = pattern.getPredicate();
        Node o = pattern.getObject();
        if (p.isVariable() || p.equals(this.directPredicate) || p.equals(this.closedPredicate)) {
            boolean closed = !p.equals(this.directPredicate);
            Node pred = this.closedPredicate;
            if (s.isVariable()) {
                if (o.isVariable()) {
                    return new FullGraphWalker(closed, this.closedPredicate, this.nodeMap);
                }
                GraphNode gn_o = (GraphNode)this.nodeMap.get(o);
                if (gn_o == null) {
                    return NullIterator.instance;
                }
                return gn_o.listPredecessorTriples(closed, this);
            }
            GraphNode gn_s = (GraphNode)this.nodeMap.get(s);
            if (gn_s == null) {
                return NullIterator.instance;
            }
            if (o.isVariable()) {
                return gn_s.listTriples(closed, this);
            }
            GraphNode gn_o = (GraphNode)this.nodeMap.get(o);
            gn_s = gn_s.leadNode();
            if (gn_o == null) {
                return NullIterator.instance;
            }
            gn_o = gn_o.leadNode();
            if (closed ? gn_s.pathTo(gn_o) : gn_s.directPathTo(gn_o)) {
                return new SingletonIterator(new Triple(s, pred, o));
            }
            return NullIterator.instance;
        }
        return NullIterator.instance;
    }

    public TransitiveGraphCache deepCopy() {
        TransitiveGraphCache copy = new TransitiveGraphCache(this.directPredicate, this.closedPredicate);
        ExtendedIterator i = this.find(new TriplePattern(null, this.directPredicate, null));
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            copy.addRelation(t.getSubject(), t.getObject());
        }
        return copy;
    }

    public void clear() {
        this.nodeMap.clear();
    }

    public void setCaching(boolean enable) {
        if (!enable && this.cacheTriples) {
            Iterator i = this.nodeMap.values().iterator();
            while (i.hasNext()) {
                ((GraphNode)i.next()).clearTripleCache();
            }
        }
        this.cacheTriples = enable;
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.nodeMap.values().iterator();
        while (i.hasNext()) {
            GraphNode n = (GraphNode)i.next();
            sb.append(n.dump());
            sb.append("\n");
        }
        return sb.toString();
    }

    private GraphNode getLead(Node n) {
        GraphNode gn = (GraphNode)this.nodeMap.get(n);
        if (gn == null) {
            gn = new GraphNode(n);
            this.nodeMap.put(n, gn);
            return gn;
        }
        return gn.leadNode();
    }

    private static class FullGraphWalker
    extends NiceIterator
    implements ExtendedIterator {
        boolean closed;
        Iterator baseNodeIt;
        GraphNode node;
        Node nodeN;
        Node predicate;
        Iterator succIt = null;
        GraphNode succ;
        Iterator aliasesIt = null;
        Triple next;

        FullGraphWalker(boolean closed, Node predicate, HashMap nodes) {
            this.predicate = predicate;
            this.closed = closed;
            this.baseNodeIt = nodes.values().iterator();
            this.walkOne();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Triple toReturn = this.next;
            this.walkOne();
            return toReturn;
        }

        protected void walkOne() {
            if (this.aliasesIt != null) {
                while (this.aliasesIt.hasNext()) {
                    GraphNode al = (GraphNode)this.aliasesIt.next();
                    if (al == this.succ || al == this.node) continue;
                    this.next = new Triple(this.nodeN, this.predicate, al.rdfNode);
                    return;
                }
                this.aliasesIt = null;
            }
            if (this.succIt != null) {
                while (this.succIt.hasNext()) {
                    this.succ = (GraphNode)this.succIt.next();
                    if (this.succ == this.node) continue;
                    if (this.succ.aliases instanceof Set) {
                        this.aliasesIt = ((Set)this.succ.aliases).iterator();
                    }
                    this.next = new Triple(this.nodeN, this.predicate, this.succ.rdfNode);
                    return;
                }
                this.succIt = null;
            }
            if (this.baseNodeIt.hasNext()) {
                this.node = (GraphNode)this.baseNodeIt.next();
                this.nodeN = this.node.rdfNode;
                GraphNode lead = this.node.leadNode();
                this.succIt = (this.closed ? lead.succClosed : lead.succ).iterator();
                if (lead.aliases instanceof Set) {
                    this.succIt = new ConcatenatedIterator(this.succIt, ((Set)lead.aliases).iterator());
                }
                this.next = new Triple(this.nodeN, this.predicate, this.nodeN);
            } else {
                this.next = null;
            }
        }
    }

    private static class GraphWalker
    extends NiceIterator
    implements ExtendedIterator {
        boolean isDeep;
        GraphNode node;
        Node root;
        Node predicate;
        Iterator iterator = null;
        Iterator aliasIterator = null;
        ArrayList nodeStack = new ArrayList();
        ArrayList iteratorStack = new ArrayList();
        Triple next;
        HashSet visited = new HashSet();

        GraphWalker(GraphNode node, Node rdfNode, boolean closed, Node predicate) {
            this.isDeep = closed;
            this.node = node;
            this.root = rdfNode;
            this.predicate = predicate;
            this.iterator = node.pred.iterator();
            if (node.aliases instanceof Set) {
                this.aliasIterator = ((Set)node.aliases).iterator();
            }
            this.next = new Triple(this.root, predicate, this.root);
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Triple toReturn = this.next;
            this.walkOne();
            return toReturn;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void walkOne() {
            if (this.aliasIterator != null) {
                if (this.aliasIterator.hasNext()) {
                    GraphNode nextNode = (GraphNode)this.aliasIterator.next();
                    this.next = new Triple(nextNode.rdfNode, this.predicate, this.root);
                    return;
                }
                this.aliasIterator = null;
            }
            if (this.iterator.hasNext()) {
                GraphNode nextNode = (GraphNode)this.iterator.next();
                if (!this.visited.add(nextNode)) {
                    this.walkOne();
                    return;
                }
                if (this.isDeep) {
                    this.pushStack(nextNode);
                }
                this.next = new Triple(nextNode.rdfNode, this.predicate, this.root);
                if (!(nextNode.aliases instanceof Set)) return;
                this.aliasIterator = ((Set)nextNode.aliases).iterator();
                return;
            }
            if (this.nodeStack.isEmpty()) {
                this.next = null;
                return;
            }
            this.popStack();
            this.walkOne();
        }

        protected void pushStack(GraphNode next) {
            this.nodeStack.add(this.node);
            this.iteratorStack.add(this.iterator);
            this.iterator = next.pred.iterator();
            this.node = next;
        }

        protected void popStack() {
            int i = this.nodeStack.size() - 1;
            this.iterator = (Iterator)this.iteratorStack.remove(i);
            this.node = (GraphNode)this.nodeStack.remove(i);
        }
    }

    private static class GraphNode {
        protected Node rdfNode;
        protected Set succ = new HashSet();
        protected Set pred = new HashSet();
        protected Set succClosed = new HashSet();
        protected List succClosedTriples;
        protected Object aliases;

        public GraphNode(Node node) {
            this.rdfNode = node;
        }

        public boolean pathTo(GraphNode A) {
            if (this == A) {
                return true;
            }
            return this.succClosed.contains(A);
        }

        public boolean directPathTo(GraphNode A) {
            if (this == A) {
                return true;
            }
            return this.succ.contains(A);
        }

        public GraphNode leadNode() {
            if (this.aliases != null && this.aliases instanceof GraphNode) {
                return ((GraphNode)this.aliases).leadNode();
            }
            return this;
        }

        public void visitPredecessors(Visitor visitor, Object arg1, Object arg2) {
            visitor.visit(this, arg1, arg2);
            this.doVisitPredecessors(visitor, arg1, arg2, new HashSet());
        }

        private void doVisitPredecessors(Visitor visitor, Object arg1, Object arg2, Set seen) {
            if (seen.add(this)) {
                GraphNode pred;
                Iterator i = this.pred.iterator();
                while (i.hasNext()) {
                    pred = (GraphNode)i.next();
                    visitor.visit(pred, arg1, arg2);
                }
                i = this.pred.iterator();
                while (i.hasNext()) {
                    pred = (GraphNode)i.next();
                    pred.doVisitPredecessors(visitor, arg1, arg2, seen);
                }
            }
        }

        public Iterator iteratorOverSuccessors() {
            return this.succClosed.iterator();
        }

        public void assertLinkTo(GraphNode target) {
            if (this == target) {
                return;
            }
            this.succ.add(target);
            target.pred.add(this);
            this.clearTripleCache();
        }

        public void retractLinkTo(GraphNode target) {
            if (this == target) {
                return;
            }
            this.succ.remove(target);
            target.pred.remove(this);
            this.clearTripleCache();
        }

        public void assertIndirectLinkTo(GraphNode target) {
            this.succClosed.add(target);
            this.clearTripleCache();
        }

        public void clearTripleCache() {
            this.succClosedTriples = null;
        }

        public void propagateAdd(GraphNode target) {
            HashSet<GraphNode> sc = new HashSet<GraphNode>(target.succClosed);
            sc.add(target);
            this.visitPredecessors(new Visitor(){

                public void visit(GraphNode node, Object arg1, Object target) {
                    Set sc = (Set)arg1;
                    node.succClosed.addAll(sc);
                    Iterator i = node.succ.iterator();
                    while (i.hasNext()) {
                        GraphNode s = (GraphNode)i.next();
                        if (!sc.contains(s)) continue;
                        i.remove();
                        s.pred.remove(node);
                    }
                }
            }, sc, target);
        }

        public void propagateSCC() {
            HashSet<GraphNode> visited = new HashSet<GraphNode>();
            visited.add(this);
            this.doVisitPredecessors(new Visitor(){

                public void visit(GraphNode node, Object arg1, Object arg2) {
                    Set sc = (Set)arg1;
                    node.succClosed.addAll(sc);
                    Iterator i = node.succ.iterator();
                    while (i.hasNext()) {
                        GraphNode s = (GraphNode)i.next();
                        if (!sc.contains(s)) continue;
                        i.remove();
                        s.pred.remove(node);
                    }
                }
            }, this.succClosed, null, visited);
        }

        public void makeLeadNodeFor(Set members) {
            GraphNode n;
            HashSet newSucc = new HashSet();
            HashSet newSuccClosed = new HashSet();
            Iterator i = members.iterator();
            while (i.hasNext()) {
                n = (GraphNode)i.next();
                newSucc.addAll(n.succ);
                newSuccClosed.addAll(n.succClosed);
            }
            newSucc.removeAll(members);
            newSuccClosed.removeAll(members);
            this.succ = newSucc;
            this.succClosed = newSuccClosed;
            i = this.succ.iterator();
            while (i.hasNext()) {
                n = (GraphNode)i.next();
                n.pred.removeAll(members);
                n.pred.add(this);
            }
            HashSet done = new HashSet();
            HashSet<GraphNode> newAliases = new HashSet<GraphNode>();
            Iterator i2 = members.iterator();
            while (i2.hasNext()) {
                GraphNode m = (GraphNode)i2.next();
                if (m.aliases instanceof Set) {
                    newAliases.addAll((Set)m.aliases);
                    continue;
                }
                newAliases.add(m);
            }
            this.aliases = newAliases;
            i2 = members.iterator();
            while (i2.hasNext()) {
                GraphNode n2 = (GraphNode)i2.next();
                if (n2 == this) continue;
                this.pred.addAll(n2.pred);
                n2.relocateAllRefTo(this, done);
                n2.aliases = this;
            }
            this.pred.removeAll(members);
        }

        private void relocateAllRefTo(GraphNode lead, Set done) {
            this.visitPredecessors(new Visitor(){

                public void visit(GraphNode node, Object done, Object leadIn) {
                    if (((Set)done).add(node)) {
                        GraphNode lead = (GraphNode)leadIn;
                        Set members = (Set)lead.aliases;
                        int before = node.succ.size();
                        node.succ.removeAll(members);
                        node.succClosed.removeAll(members);
                        node.succClosed.add(lead);
                        if (node.succ.size() != before) {
                            node.succ.add(lead);
                        }
                    }
                }
            }, done, lead);
        }

        public ExtendedIterator listTriples(boolean closed, TransitiveGraphCache tgc) {
            if (tgc.cacheTriples) {
                return WrappedIterator.create(this.leadNode().triplesForSuccessors(this.rdfNode, closed, tgc).iterator());
            }
            return WrappedIterator.create(this.leadNode().triplesForSuccessors(this.rdfNode, closed, tgc).iterator());
        }

        private List triplesForSuccessors(Node base, boolean closed, TransitiveGraphCache tgc) {
            Set successors = closed ? this.succClosed : this.succ;
            ArrayList<Triple> result = new ArrayList<Triple>(successors.size() + 10);
            result.add(new Triple(base, tgc.closedPredicate, base));
            Iterator i = successors.iterator();
            while (i.hasNext()) {
                GraphNode s = (GraphNode)i.next();
                result.add(new Triple(base, tgc.closedPredicate, s.rdfNode));
                if (!(s.aliases instanceof Set)) continue;
                Iterator j = ((Set)s.aliases).iterator();
                while (j.hasNext()) {
                    result.add(new Triple(base, tgc.closedPredicate, ((GraphNode)j.next()).rdfNode));
                }
            }
            if (this.aliases instanceof Set) {
                Iterator j = ((Set)this.aliases).iterator();
                while (j.hasNext()) {
                    result.add(new Triple(base, tgc.closedPredicate, ((GraphNode)j.next()).rdfNode));
                }
            }
            return result;
        }

        public ExtendedIterator listPredecessorTriples(boolean closed, TransitiveGraphCache tgc) {
            return new GraphWalker(this.leadNode(), this.rdfNode, closed, tgc.closedPredicate);
        }

        public String toString() {
            return "[" + this.rdfNode.getLocalName() + "]";
        }

        public String dump() {
            String result = this.rdfNode.getLocalName();
            if (this.aliases != null) {
                result = this.aliases instanceof GraphNode ? result + " leader=" + this.aliases + ", " : result + " SCC=" + this.dumpSet((Set)this.aliases) + ", ";
            }
            return result + " succ=" + this.dumpSet(this.succ) + ", succClose=" + this.dumpSet(this.succClosed) + ", pred=" + this.dumpSet(this.pred);
        }

        private String dumpSet(Set s) {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            boolean started = false;
            Iterator i = s.iterator();
            while (i.hasNext()) {
                if (started) {
                    sb.append(", ");
                } else {
                    started = true;
                }
                sb.append(i.next().toString());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    static interface Visitor {
        public void visit(GraphNode var1, Object var2, Object var3);
    }
}

