% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_ParameterStateEvolution.R
\name{trace_ParameterStateEvolution}
\alias{trace_ParameterStateEvolution}
\title{Trace parameter state evolution}
\usage{
trace_ParameterStateEvolution(object, step = NULL, plot = TRUE, ...)
}
\arguments{
\item{object}{\link[Luminescence:RLum.Analysis-class]{Luminescence::RLum.Analysis} (\strong{required}): input object
created by the function \link{model_LuminescenceSignals}. The input can be a list of such
objects}

\item{step}{\link{character} (\emph{optional}): filter the input object to pick particular
steps, the input is passed to \link[Luminescence:get_RLum]{Luminescence::get_RLum}}

\item{plot}{\link{logical} (\emph{with default}): enables/disables plot output}

\item{...}{optional arguments to be passed to control the plot output. Supported
are \code{xlim}, \code{xlab}, \code{ylab}, \code{log}, \code{col}, \code{type}, \code{bg}, \code{main}, \code{norm} (\code{TRUE}/\code{FALSE}),
\code{grid} (\code{TRUE}/\code{FALSE}), \code{step_names} (\code{TRUE}/\code{FALSE})
Where meaningful, parameters can be provided as vectors. Vectors short than the number of plots are recycled.}
}
\value{
Returns a plot and \link{list} with \link{matrix} objects of the parameter evolution. If
\code{object} is a \link{list} the output is a nested \link{list}
}
\description{
Traces the evolution of the concentrations in the different
levels over different simulation steps. For instance, a sequence consisting
of one TL and one OSL step has two iterations. For each step the end concentration
is extracted. This way, the evolution of the system can be traced throughout
a sequence.
}
\section{Function version}{
 0.1.0
}

\examples{

sequence <-
list(
IRR = c(20, 10, 1),
TL = c(20, 400, 5),
IRR = c(20, 10, 1),
TL = c(20, 400, 5))

##model sequence
model.output <- model_LuminescenceSignals(
 sequence = sequence,
 verbose = FALSE,
 plot = FALSE,
 model = "Bailey2001")

## trace
trace_ParameterStateEvolution(model.output)

}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
} 

\section{How to cite}{
Kreutzer, S., 2022. trace_ParameterStateEvolution(): Trace parameter state evolution. Function version 0.1.0. In: Friedrich, J., Kreutzer, S., Schmidt, C., 2022. RLumModel: Solving Ordinary Differential Equations to Understand Luminescence. R package version 0.2.10. https://CRAN.R-project.org/package=RLumModel
}

