% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos.R
\name{CosValueOption}
\alias{CosValueOption}
\title{Approximate the Option Price with the COS Method}
\usage{
CosValueOption(ValueOption, GBMChf, r, tau, N, a, b, method = "integrate")
}
\arguments{
\item{ValueOption}{the value function of the option}

\item{GBMChf}{the characteristic function for GBM}

\item{r}{the \code{r} parameter of GBM}

\item{tau}{the \code{tau} parameter of GBM}

\item{N}{the number of cos term for summation}

\item{a}{the lower limit of the truncation interval}

\item{b}{the upper limit of the truncation interval}

\item{method}{how to calculate the integral, one of "integrate" and "jiahe"}
}
\value{
The approximated euro call option price
}
\description{
Approximate the standard European call option price with the COS method, an option pricing method based on the Fourier-cosine series.
}
\examples{
r <- 0.1
sigmaS0 <- 0.2
tau <- 10
S0 <- 1
K <- 1
mu <- log(S0) + (r - 0.5 * sigmaS0^2) * tau
sigma <- sigmaS0 * sqrt(tau)
a <- -10
b <- 10
N <- 64
GBMChf <- function(u){NormChf(u,mu,sigma)}
ValueOption <- function(x){EuroCallOption(x,K)}
CosValueOption(ValueOption, GBMChf,r,tau, N, a, b)
}
\references{
Fang F. and Oosterlee C.W. 2008. "A Novel Pricing Method for European Options Based on Fourier-Cosine Series Expansions", Siam Journal on Scientific Computing. 31(2): 826-848. doi: 10.1137/080718061.
}
