% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest.R
\name{RiskIndicators}
\alias{RiskIndicators}
\title{Calculate Useful Indicators for returns}
\usage{
RiskIndicators(ret, rb, rf = 0)
}
\arguments{
\item{ret}{vector of return}

\item{rb}{return of market portfolio}

\item{rf}{risk free rate}
}
\value{
A matrix of return and risk indicators
}
\description{
Calculate cumulative return, annualized return, max drawdown, annualized sharp ratio, calmar ratio, sortino ratio, alpha, beta and information ratio with returns.
}
\examples{
date <- as.Date("2015-01-01") + days(0:249)
ret <- as.xts(rnorm(250), date)
rb <- as.xts(rep(0, 250), date)
RiskIndicators(ret, rb = rb, rf = 0)
}
