% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gglineplot}
\alias{gglineplot}
\title{Plot the Time Series}
\usage{
gglineplot(data, x, y, date_labels = "\%Y/\%m/\%d", date_breaks = "2 weeks")
}
\arguments{
\item{data}{a tibble}

\item{x}{x}

\item{y}{y}

\item{date_labels}{the x label}

\item{date_breaks}{the period of the x label}
}
\value{
A ggplot figure of the time series
}
\description{
Plot the time series data beautifully with ggplot.
}
\examples{
date <- as.Date("2015-01-01") + days(0:180)
thero <- returns(rGbm("thero", date))[-1]
tthero <- tibble(x = date[-1], y = thero)
gglineplot(tthero, aes(x, y), "\%Y/\%m", "1 months")
}
