% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_fused_write_objects}
\alias{mvl_fused_write_objects}
\title{Write concatenated R objects and write result into MVL file.}
\usage{
mvl_fused_write_objects(MVLHANDLE, L, name = NULL, drop.rownames = TRUE)
}
\arguments{
\item{MVLHANDLE}{a handle to MVL file produced by \code{mvl_open()}}

\item{L}{a list of suitable R objects (vector, array, data.frame) or equivalent MVL objects.}

\item{name}{if specified add a named entry to MVL file directory}

\item{drop.rownames}{set to TRUE to prevent rownames from being written}
}
\value{
and object of class MVL_OFFSET that describes an offset into this MVL file. MVL offsets are vectors and can be concatenated. They can be written to MVL file directly, or as part of another object such as list.
}
\description{
This function can concatenate a mixture of R and MVL objects. For vectors it is the equivalent of \code{c()}. For array and matrices it works as \code{cbind()}
For data frames it works as \code{rbind}, but row names are always dropped.
}
