% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transaction.R
\docType{methods}
\name{transactions}
\alias{transactions}
\alias{dbBegin,MariaDBConnection-method}
\alias{dbCommit,MariaDBConnection-method}
\alias{dbRollback,MariaDBConnection-method}
\title{DBMS Transaction Management}
\usage{
\S4method{dbBegin}{MariaDBConnection}(conn, ...)

\S4method{dbCommit}{MariaDBConnection}(conn, ...)

\S4method{dbRollback}{MariaDBConnection}(conn, ...)
}
\arguments{
\item{conn}{a \linkS4class{MariaDBConnection} object, as produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{...}{Unused.}
}
\description{
Commits or roll backs the current transaction in an MariaDB connection.
Note that in MariaDB DDL statements (e.g. \code{CREATE TABLE}) cannot
be rolled back.
}
\examples{
if (mariadbHasDefault()) {
con <- dbConnect(RMariaDB::MariaDB(), dbname = "test")
df <- data.frame(id = 1:5)

dbWriteTable(con, "df", df)
dbBegin(con)
dbExecute(con, "UPDATE df SET id = id * 10")
dbGetQuery(con, "SELECT id FROM df")
dbRollback(con)

dbGetQuery(con, "SELECT id FROM df")

dbRemoveTable(con, "df")
dbDisconnect(con)
}
}
