/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

import scala.math.ScalaNumber;

public final class BoxesRunTime {
    private static final int CHAR = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int OTHER = 7;

    private static int typeCode(Object object) {
        if (object instanceof Integer) {
            return 3;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Character) {
            return 0;
        }
        if (object instanceof Long) {
            return 4;
        }
        if (object instanceof Double) {
            return 6;
        }
        if (object instanceof Short) {
            return 2;
        }
        if (object instanceof Float) {
            return 5;
        }
        return 7;
    }

    private static String boxDescription(Object object) {
        return "" + object.getClass().getSimpleName() + "(" + object + ")";
    }

    public static Boolean boxToBoolean(boolean bl) {
        return bl;
    }

    public static Character boxToCharacter(char c) {
        return Character.valueOf(c);
    }

    public static Byte boxToByte(byte by2) {
        return by2;
    }

    public static Short boxToShort(short s) {
        return s;
    }

    public static Integer boxToInteger(int n) {
        return n;
    }

    public static Long boxToLong(long l) {
        return l;
    }

    public static Float boxToFloat(float f) {
        return Float.valueOf(f);
    }

    public static Double boxToDouble(double d) {
        return d;
    }

    public static boolean unboxToBoolean(Object object) {
        return object == null ? false : (Boolean)object;
    }

    public static char unboxToChar(Object object) {
        return object == null ? (char)'\u0000' : ((Character)object).charValue();
    }

    public static byte unboxToByte(Object object) {
        return object == null ? (byte)0 : (Byte)object;
    }

    public static short unboxToShort(Object object) {
        return object == null ? (short)0 : (Short)object;
    }

    public static int unboxToInt(Object object) {
        return object == null ? 0 : (Integer)object;
    }

    public static long unboxToLong(Object object) {
        return object == null ? 0L : (Long)object;
    }

    public static float unboxToFloat(Object object) {
        return object == null ? 0.0f : ((Float)object).floatValue();
    }

    public static double unboxToDouble(Object object) {
        return object == null ? 0.0 : (Double)object;
    }

    private static int eqTypeCode(Number number) {
        if (number instanceof Integer || number instanceof Byte) {
            return 3;
        }
        if (number instanceof Long) {
            return 4;
        }
        if (number instanceof Double) {
            return 6;
        }
        if (number instanceof Short) {
            return 3;
        }
        if (number instanceof Float) {
            return 5;
        }
        return 7;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return BoxesRunTime.equals2(object, object2);
    }

    public static boolean equals2(Object object, Object object2) {
        if (object instanceof Number) {
            return BoxesRunTime.equalsNumObject((Number)object, object2);
        }
        if (object instanceof Character) {
            return BoxesRunTime.equalsCharObject((Character)object, object2);
        }
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static boolean equalsNumObject(Number number, Object object) {
        if (object instanceof Number) {
            return BoxesRunTime.equalsNumNum(number, (Number)object);
        }
        if (object instanceof Character) {
            return BoxesRunTime.equalsNumChar(number, (Character)object);
        }
        if (number == null) {
            return object == null;
        }
        return number.equals(object);
    }

    public static boolean equalsNumNum(Number number, Number number2) {
        int n = BoxesRunTime.eqTypeCode(number);
        int n2 = BoxesRunTime.eqTypeCode(number2);
        switch (n2 > n ? n2 : n) {
            case 3: {
                return number.intValue() == number2.intValue();
            }
            case 4: {
                return number.longValue() == number2.longValue();
            }
            case 5: {
                return number.floatValue() == number2.floatValue();
            }
            case 6: {
                return number.doubleValue() == number2.doubleValue();
            }
        }
        if (number2 instanceof ScalaNumber && !(number instanceof ScalaNumber)) {
            return number2.equals(number);
        }
        if (number == null) {
            return number2 == null;
        }
        return number.equals(number2);
    }

    public static boolean equalsCharObject(Character c, Object object) {
        if (object instanceof Character) {
            return c.charValue() == ((Character)object).charValue();
        }
        if (object instanceof Number) {
            return BoxesRunTime.equalsNumChar((Number)object, c);
        }
        if (c == null) {
            return object == null;
        }
        return c.equals(object);
    }

    private static boolean equalsNumChar(Number number, Character c) {
        char c2 = c.charValue();
        switch (BoxesRunTime.eqTypeCode(number)) {
            case 3: {
                return number.intValue() == c2;
            }
            case 4: {
                return number.longValue() == (long)c2;
            }
            case 5: {
                return number.floatValue() == (float)c2;
            }
            case 6: {
                return number.doubleValue() == (double)c2;
            }
        }
        if (number == null) {
            return c == null;
        }
        return number.equals(c);
    }

    public static int hashFromLong(Long l) {
        int n = l.intValue();
        if ((long)n == l) {
            return n;
        }
        return l.hashCode();
    }

    public static int hashFromDouble(Double d) {
        double d2;
        int n = d.intValue();
        if ((double)n == (d2 = d.doubleValue())) {
            return n;
        }
        long l = d.longValue();
        if ((double)l == d2) {
            return Long.valueOf(l).hashCode();
        }
        return d.hashCode();
    }

    public static int hashFromFloat(Float f) {
        float f2;
        int n = f.intValue();
        if ((float)n == (f2 = f.floatValue())) {
            return n;
        }
        long l = f.longValue();
        if ((float)l == f2) {
            return Long.valueOf(l).hashCode();
        }
        return f.hashCode();
    }

    public static int hashFromNumber(Number number) {
        if (number instanceof Long) {
            return BoxesRunTime.hashFromLong((Long)number);
        }
        if (number instanceof Double) {
            return BoxesRunTime.hashFromDouble((Double)number);
        }
        if (number instanceof Float) {
            return BoxesRunTime.hashFromFloat((Float)number);
        }
        return number.hashCode();
    }

    public static int hashFromObject(Object object) {
        if (object instanceof Number) {
            return BoxesRunTime.hashFromNumber((Number)object);
        }
        return object.hashCode();
    }

    public static Object add(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 + n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l + l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f + f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d + d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object subtract(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 - n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l - l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f - f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d - d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object multiply(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 * n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l * l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f * f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d * d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object divide(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 / n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l / l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f / f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d / d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeModulo(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 % n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l % l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToFloat(f % f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToDouble(d % d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftSignedRight(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3;
            int n4 = n3 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n2 <= 3) {
                int n5 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToInteger(n3 >> n5);
            }
            if (n2 <= 4) {
                long l = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToInteger(n3 >> (int)l);
            }
        }
        if (n <= 4) {
            long l;
            long l2 = l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            if (n2 <= 3) {
                int n6 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToLong(l >> n6);
            }
            if (n2 <= 4) {
                long l3 = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToLong(l >> (int)l3);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftSignedLeft(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3;
            int n4 = n3 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n2 <= 3) {
                int n5 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToInteger(n3 << n5);
            }
            if (n2 <= 4) {
                long l = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToInteger(n3 << (int)l);
            }
        }
        if (n <= 4) {
            long l;
            long l2 = l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            if (n2 <= 3) {
                int n6 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToLong(l << n6);
            }
            if (n2 <= 4) {
                long l3 = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToLong(l << (int)l3);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object shiftLogicalRight(Object object, Object object2) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        int n2 = BoxesRunTime.typeCode(object2);
        if (n <= 3) {
            int n3;
            int n4 = n3 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n2 <= 3) {
                int n5 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToInteger(n3 >>> n5);
            }
            if (n2 <= 4) {
                long l = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToInteger(n3 >>> (int)l);
            }
        }
        if (n <= 4) {
            long l;
            long l2 = l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            if (n2 <= 3) {
                int n6 = n2 == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return BoxesRunTime.boxToLong(l >>> n6);
            }
            if (n2 <= 4) {
                long l3 = n2 == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return BoxesRunTime.boxToLong(l >>> (int)l3);
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object negate(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            int n2 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            return BoxesRunTime.boxToInteger(-n2);
        }
        if (n <= 4) {
            long l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            return BoxesRunTime.boxToLong(-l);
        }
        if (n <= 5) {
            float f = n == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            return BoxesRunTime.boxToFloat(-f);
        }
        if (n <= 6) {
            double d = n == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            return BoxesRunTime.boxToDouble(-d);
        }
        throw new NoSuchMethodException();
    }

    public static Object positive(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            int n2 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            return BoxesRunTime.boxToInteger(n2);
        }
        if (n <= 4) {
            long l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            return BoxesRunTime.boxToLong(l);
        }
        if (n <= 5) {
            float f = n == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            return BoxesRunTime.boxToFloat(f);
        }
        if (n <= 6) {
            double d = n == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            return BoxesRunTime.boxToDouble(d);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeAnd(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
                throw new NoSuchMethodException();
            }
            return BoxesRunTime.boxToBoolean((Boolean)object & (Boolean)object2);
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 & n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l & l2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeOr(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
                throw new NoSuchMethodException();
            }
            return BoxesRunTime.boxToBoolean((Boolean)object | (Boolean)object2);
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 | n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l | l2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeXor(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
                throw new NoSuchMethodException();
            }
            return BoxesRunTime.boxToBoolean((Boolean)object ^ (Boolean)object2);
        }
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToInteger(n5 ^ n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToLong(l ^ l2);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeConditionalAnd(Object object, Object object2) throws NoSuchMethodException {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object != false && (Boolean)object2 != false);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeConditionalOr(Object object, Object object2) throws NoSuchMethodException {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object != false || (Boolean)object2 != false);
        }
        throw new NoSuchMethodException();
    }

    public static Object complement(Object object) throws NoSuchMethodException {
        int n = BoxesRunTime.typeCode(object);
        if (n <= 3) {
            int n2 = n == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            return BoxesRunTime.boxToInteger(~n2);
        }
        if (n <= 4) {
            long l = n == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            return BoxesRunTime.boxToLong(l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        throw new NoSuchMethodException();
    }

    public static Object takeNot(Object object) throws NoSuchMethodException {
        if (object instanceof Boolean) {
            return BoxesRunTime.boxToBoolean((Boolean)object == false);
        }
        throw new NoSuchMethodException();
    }

    public static Object testEqual(Object object, Object object2) throws NoSuchMethodException {
        return BoxesRunTime.boxToBoolean(object == object2);
    }

    public static Object testNotEqual(Object object, Object object2) throws NoSuchMethodException {
        return BoxesRunTime.boxToBoolean(object != object2);
    }

    public static Object testLessThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 < n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l < l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f < f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d < d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object testLessOrEqualThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 <= n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l <= l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f <= f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d <= d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object testGreaterOrEqualThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 >= n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l >= l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f >= f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d >= d2);
        }
        throw new NoSuchMethodException();
    }

    public static Object testGreaterThan(Object object, Object object2) throws NoSuchMethodException {
        int n;
        int n2;
        int n3 = BoxesRunTime.typeCode(object);
        int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
        if (n2 <= 3) {
            int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
            int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
            return BoxesRunTime.boxToBoolean(n5 > n6);
        }
        if (n2 <= 4) {
            long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
            long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
            return BoxesRunTime.boxToBoolean(l > l2);
        }
        if (n2 <= 5) {
            float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
            float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
            return BoxesRunTime.boxToBoolean(f > f2);
        }
        if (n2 <= 6) {
            double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
            double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
            return BoxesRunTime.boxToBoolean(d > d2);
        }
        throw new NoSuchMethodException();
    }

    public static Character toCharacter(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToShort(object));
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Byte toByte(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToShort(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Short toShort(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToShort(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToDouble(object));
        }
        throw new NoSuchMethodException();
    }

    public static Integer toInteger(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToInteger(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Long toLong(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToLong(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Float toFloat(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof Double) {
            return BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToDouble(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToFloat(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }

    public static Double toDouble(Object object) throws NoSuchMethodException {
        if (object instanceof Integer) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToInt(object));
        }
        if (object instanceof Float) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToFloat(object));
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Long) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToLong(object));
        }
        if (object instanceof Character) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToChar(object));
        }
        if (object instanceof Byte) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToByte(object));
        }
        if (object instanceof Short) {
            return BoxesRunTime.boxToDouble(BoxesRunTime.unboxToShort(object));
        }
        throw new NoSuchMethodException();
    }
}

