/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bson.io.Bits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Response {
    final ServerAddress _host;
    final int _len;
    final int _id;
    final int _responseTo;
    final int _operation;
    final int _flags;
    long _cursor;
    final int _startingFrom;
    final int _num;
    final List<DBObject> _objects;
    private static final int MAX_LENGTH = 0x2000000;

    Response(ServerAddress addr, DBCollection collection, InputStream in, DBDecoder decoder) throws IOException {
        this._host = addr;
        byte[] b = new byte[36];
        Bits.readFully(in, b);
        int pos = 0;
        this._len = Bits.readInt(b, pos);
        pos += 4;
        if (this._len > 0x2000000) {
            throw new IllegalArgumentException("response too long: " + this._len);
        }
        this._id = Bits.readInt(b, pos);
        this._responseTo = Bits.readInt(b, pos += 4);
        this._operation = Bits.readInt(b, pos += 4);
        this._flags = Bits.readInt(b, pos += 4);
        this._cursor = Bits.readLong(b, pos += 4);
        this._startingFrom = Bits.readInt(b, pos += 8);
        this._num = Bits.readInt(b, pos += 4);
        pos += 4;
        MyInputStream user = new MyInputStream(in, this._len - b.length);
        this._objects = this._num < 2 ? new LinkedList<DBObject>() : new ArrayList<DBObject>(this._num);
        for (int i = 0; i < this._num; ++i) {
            if (user._toGo < 5) {
                throw new IOException("should have more objects, but only " + user._toGo + " bytes left");
            }
            this._objects.add(decoder.decode((InputStream)user, collection));
        }
        if (user._toGo != 0) {
            throw new IOException("finished reading objects but still have: " + user._toGo + " bytes to read!' ");
        }
        if (this._num != this._objects.size()) {
            throw new RuntimeException("something is really broken");
        }
    }

    public int size() {
        return this._num;
    }

    public ServerAddress serverUsed() {
        return this._host;
    }

    public DBObject get(int i) {
        return this._objects.get(i);
    }

    public Iterator<DBObject> iterator() {
        return this._objects.iterator();
    }

    public boolean hasGetMore(int queryOptions) {
        if (this._cursor == 0L) {
            return false;
        }
        if (this._num > 0) {
            return true;
        }
        return (queryOptions & 2) != 0;
    }

    public long cursor() {
        return this._cursor;
    }

    public ServerError getError() {
        if (this._num != 1) {
            return null;
        }
        DBObject obj = this.get(0);
        if (ServerError.getMsg(obj, null) == null) {
            return null;
        }
        return new ServerError(obj);
    }

    public String toString() {
        return "flags:" + this._flags + " _cursor:" + this._cursor + " _startingFrom:" + this._startingFrom + " _num:" + this._num;
    }

    static class MyInputStream
    extends InputStream {
        final InputStream _in;
        private int _toGo;

        MyInputStream(InputStream in, int max2) {
            this._in = in;
            this._toGo = max2;
        }

        public int available() throws IOException {
            return this._in.available();
        }

        public int read() throws IOException {
            if (this._toGo <= 0) {
                return -1;
            }
            int val = this._in.read();
            --this._toGo;
            return val;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this._toGo <= 0) {
                return -1;
            }
            int n = this._in.read(b, off, Math.min(this._toGo, len));
            this._toGo -= n;
            return n;
        }

        public void close() {
            throw new RuntimeException("can't close thos");
        }
    }
}

