% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_design.R
\name{nhanes_survey_design}
\alias{nhanes_survey_design}
\title{Build survey objects for NHANES data}
\usage{
nhanes_survey_design(nhanes_data, weights_column = "")
}
\arguments{
\item{nhanes_data}{data frame containing NHANES data}

\item{weights_column}{name of the weights column}
}
\value{
a survey design object
}
\description{
Build survey objects for NHANES data
}
\examples{

\dontrun{
dat <- nhanes_load_data("UHG_G", "2011-2012", demographics = TRUE)

design <- nhanes_survey_design(dat, "WTSA2YR")

svymean(~RIDAGEYR, design)

svyglm(URXUHG ~ RIDAGEYR + RIAGENDR, design)
}

}

