% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{niftiHeader}
\alias{niftiHeader}
\alias{dumpNifti}
\alias{analyzeHeader}
\alias{print.niftiHeader}
\alias{print.analyzeHeader}
\title{Dump or construct a raw NIfTI or ANALYZE header}
\usage{
niftiHeader(image = list())

analyzeHeader(image = list())

\method{print}{niftiHeader}(x, ...)

\method{print}{analyzeHeader}(x, ...)
}
\arguments{
\item{image}{An image, in any acceptable form (see
\code{\link{retrieveNifti}}). A list containing partial header information
is acceptable, including an empty list, which returns defaults for every
field.}

\item{x}{A \code{"niftiHeader"} object.}

\item{...}{Ignored.}
}
\value{
For \code{niftiHeader}, a list of class \code{"niftiHeader"}, with
  named components corresponding to the elements in a raw NIfTI-1 header.
  For \code{analyzeHeader}, the equivalent for ANALYZE-7.5.
}
\description{
These functions extract the contents of a NIfTI-1 or ANALYZE-7.5 header,
closely approximating how it is (or would be) stored on disk. Defaults will
be used where information is missing, but no processing is performed on the
metadata.
}
\details{
The NIfTI-1 standard was originally formulated as a roughly backwards-
compatible improvement on the ANALYZE format. Both formats use a binary
header structure of 348 bytes, but the field names and their interpretation
is often non-equivalent. These functions dump these fields, without regard
to whether or not the result makes proper sense.

\code{dumpNifti} is an alias of \code{niftiHeader}, but the former is now
soft-deprecated.
}
\note{
Several medical image analysis packages, such as SPM and FSL, use the
  ANALYZE \code{originator} field to store a coordinate origin. This
  interpretation is also returned, in the \code{origin} field.
}
\examples{
niftiHeader(system.file("extdata", "example.nii.gz", package="RNifti"))

# Default header for a standard R array
niftiHeader(array(0L, dim=c(10,10)))

}
\references{
The NIfTI-1 standard (\url{http://www.nitrc.org/docman/view.php/26/64/nifti1.h}).
}
\seealso{
\code{\link{niftiVersion}}
}
\author{
Jon Clayden <code@clayden.org>
}
