% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgb.R
\name{rgbArray}
\alias{rgbArray}
\alias{as.character.rgbArray}
\title{RGB arrays}
\usage{
rgbArray(red, green, blue, alpha, max = NULL, dim = NULL, ...)

\method{as.character}{rgbArray}(x, flatten = TRUE, ...)
}
\arguments{
\item{red}{A numeric vector (or array) of red channel values. If this is the
only channel argument, it can also be a character vector of colour values
(including alpha, if required), or a numeric array whose last dimension is
2 (for grey + alpha), 3 (for RGB) or 4 (for RGBA).}

\item{green, blue, alpha}{Numeric vectors (or arrays) containing values for
the appropriate channel. These will be combined with the \code{red} values
using \code{cbind}, and hence recycled as necessary. Alpha, or green and
blue, can be missing.}

\item{max}{The maximum possible value for any channel. The default
is 255 when the data is of integer mode, and 1 otherwise. Values above
this, or below zero, will be clipped to the appropriate extreme.}

\item{dim}{An integer vector of dimensions for the final array. The
dimensions of \code{red} are used if this is \code{NULL}.}

\item{...}{For \code{rgbArray}, additional attributes to set on the result,
such as \code{pixdim}. These are passed directly to
\code{\link{structure}}. For the \code{as.character} method, this argument
is ignored.}

\item{x}{An \code{rgbArray} object.}

\item{flatten}{Logical value. If \code{FALSE}, the dimensions of \code{x}
will be retained in the result. The default is \code{TRUE}, for
consistency with the usual behaviour of \code{as.character}, which strips
all attributes.}
}
\value{
\code{rgbArray} returns an integer-mode array of class
  \code{"rgbArray"}. The \code{as.character} method returns a character-mode
  vector of colour strings.
}
\description{
The \code{rgbArray} function constructs an integer array whose values are
byte-packed representations of 8-bit RGBA colour values. The \code{channels}
attribute (with value 3 or 4) indicates how many channels are being used.
The resulting array can be used to construct an RGB(A) NIfTI image, or
converted to standard R colour strings using the \code{as.character} method.
}
\note{
The values of an \code{"rgbArray"} are not easily interpreted, and
  may depend on the endianness of the platform. For manipulation or use as
  colours they should generally be converted to character mode, or the
  channels extracted using the \code{\link{channels}} function.
}
\author{
Jon Clayden <code@clayden.org>
}
