% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksplot.R
\name{ksplot.rocit}
\alias{ksplot.rocit}
\title{KS Plot}
\usage{
\method{ksplot}{rocit}(object, col = c("#26484F", "#BEBEBE", "#FFA54F"),
  lty = c(1, 1, 1), legend = T, legendpos = "bottomright",
  values = T, ... = NULL)
}
\arguments{
\item{object}{An object of class \code{"rocit"}, returned by
\code{\link{rocit}} function.}

\item{col}{Colors to be used for plot. Minimum three colors need
to be supplied for F(c), G(c) and KS Stat mark.}

\item{lty}{Line types of the plots.}

\item{legend}{A logical value indicating whether legends to
appear in the plot.}

\item{legendpos}{Position of the legend. A single keyword from
\code{"bottomright"}, \code{"bottom"},
\code{"bottomleft"}, \code{"left"}, \code{"topleft"},
\code{"top"}, \code{"topright"}, \code{"right"} and \code{"center"},
as in \code{\link[graphics]{legend}}. Ignored if
\code{legend} is \code{FALSE}.}

\item{values}{A logical value, indicating whether values to be returned.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
If \code{values = TRUE}, then  Cutoff, F(c), G(c), KS stat,
KS Cutoff  are returned silently.
}
\description{
Generates  cumulative density of
diagnostic variable in positive and negative responses.
}
\details{
This function plots the cumulative density functions
$F(c)$ and $G(c) of the
diagnostic variable in the negative and positive populations.
If the positive population have higher value then
negative curve ($F(c)$) ramps up quickly. The KS statistic is the maximum
difference of $F(c)$ and $G(c)$.
}
\note{
Customized plots can be made by using the
returned values of the function.
}
\examples{
data("Diabetes")
logistic.model <- glm(as.factor(dtest)~chol+age+bmi,
                      data = Diabetes,family = "binomial")
class <- logistic.model$y
score <- logit(logistic.model$fitted.values)
# -------------------------------------------------------------
roc_emp <- rocit(score = score, class = class) # default method empirical
# -------------------------------------------------------------
kplot1 <- ksplot(roc_emp)
message("KS Stat (empirical) : ", kplot1$`KS stat`)
message("KS Stat (empirical) cutoff : ", kplot1$`KS Cutoff`)


}
