## status_codes <- c("TERMINAL_LIST_ELEMENT", "SUCCESSFUL_RETURN", "RET_DIV_BY_ZERO", "RET_INDEX_OUT_OF_BOUNDS", "RET_INVALID_ARGUMENTS", "RET_ERROR_UNDEFINED", "RET_WARNING_UNDEFINED", "RET_INFO_UNDEFINED", "RET_EWI_UNDEFINED", "RET_AVAILABLE_WITH_LINUX_ONLY", "RET_UNKNOWN_BUG", "RET_PRINTLEVEL_CHANGED", "RET_NOT_YET_IMPLEMENTED", "RET_INDEXLIST_MUST_BE_REORDERD", "RET_INDEXLIST_EXCEEDS_MAX_LENGTH", "RET_INDEXLIST_CORRUPTED", "RET_INDEXLIST_OUTOFBOUNDS", "RET_INDEXLIST_ADD_FAILED", "RET_INDEXLIST_INTERSECT_FAILED", "RET_INDEX_ALREADY_OF_DESIRED_STATUS", "RET_ADDINDEX_FAILED", "RET_REMOVEINDEX_FAILED", "RET_SWAPINDEX_FAILED", "RET_NOTHING_TO_DO", "RET_SETUP_BOUND_FAILED", "RET_SETUP_CONSTRAINT_FAILED", "RET_MOVING_BOUND_FAILED", "RET_MOVING_CONSTRAINT_FAILED", "RET_SHIFTING_FAILED", "RET_ROTATING_FAILED", "RET_QPOBJECT_NOT_SETUP", "RET_QP_ALREADY_INITIALISED", "RET_NO_INIT_WITH_STANDARD_SOLVER", "RET_RESET_FAILED", "RET_INIT_FAILED", "RET_INIT_FAILED_TQ", "RET_INIT_FAILED_CHOLESKY", "RET_INIT_FAILED_HOTSTART", "RET_INIT_FAILED_INFEASIBILITY", "RET_INIT_FAILED_UNBOUNDEDNESS", "RET_INIT_FAILED_REGULARISATION", "RET_INIT_SUCCESSFUL", "RET_OBTAINING_WORKINGSET_FAILED", "RET_SETUP_WORKINGSET_FAILED", "RET_SETUP_AUXILIARYQP_FAILED", "RET_NO_CHOLESKY_WITH_INITIAL_GUESS", "RET_NO_EXTERN_SOLVER", "RET_QP_UNBOUNDED", "RET_QP_INFEASIBLE", "RET_QP_NOT_SOLVED", "RET_QP_SOLVED", "RET_UNABLE_TO_SOLVE_QP", "RET_INITIALISATION_STARTED", "RET_HOTSTART_FAILED", "RET_HOTSTART_FAILED_TO_INIT", "RET_HOTSTART_FAILED_AS_QP_NOT_INITIALISED", "RET_ITERATION_STARTED", "RET_SHIFT_DETERMINATION_FAILED", "RET_STEPDIRECTION_DETERMINATION_FAILED", "RET_STEPLENGTH_DETERMINATION_FAILED", "RET_OPTIMAL_SOLUTION_FOUND", "RET_HOMOTOPY_STEP_FAILED", "RET_HOTSTART_STOPPED_INFEASIBILITY", "RET_HOTSTART_STOPPED_UNBOUNDEDNESS", "RET_WORKINGSET_UPDATE_FAILED", "RET_MAX_NWSR_REACHED", "RET_CONSTRAINTS_NOT_SPECIFIED", "RET_INVALID_FACTORISATION_FLAG", "RET_UNABLE_TO_SAVE_QPDATA", "RET_STEPDIRECTION_FAILED_TQ", "RET_STEPDIRECTION_FAILED_CHOLESKY", "RET_CYCLING_DETECTED", "RET_CYCLING_NOT_RESOLVED", "RET_CYCLING_RESOLVED", "RET_STEPSIZE", "RET_STEPSIZE_NONPOSITIVE", "RET_SETUPSUBJECTTOTYPE_FAILED", "RET_ADDCONSTRAINT_FAILED", "RET_ADDCONSTRAINT_FAILED_INFEASIBILITY", "RET_ADDBOUND_FAILED", "RET_ADDBOUND_FAILED_INFEASIBILITY", "RET_REMOVECONSTRAINT_FAILED", "RET_REMOVEBOUND_FAILED", "RET_REMOVE_FROM_ACTIVESET", "RET_ADD_TO_ACTIVESET", "RET_REMOVE_FROM_ACTIVESET_FAILED", "RET_ADD_TO_ACTIVESET_FAILED", "RET_CONSTRAINT_ALREADY_ACTIVE", "RET_ALL_CONSTRAINTS_ACTIVE", "RET_LINEARLY_DEPENDENT", "RET_LINEARLY_INDEPENDENT", "RET_LI_RESOLVED", "RET_ENSURELI_FAILED", "RET_ENSURELI_FAILED_TQ", "RET_ENSURELI_FAILED_NOINDEX", "RET_ENSURELI_FAILED_CYCLING", "RET_BOUND_ALREADY_ACTIVE", "RET_ALL_BOUNDS_ACTIVE", "RET_CONSTRAINT_NOT_ACTIVE", "RET_BOUND_NOT_ACTIVE", "RET_HESSIAN_NOT_SPD", "RET_HESSIAN_INDEFINITE", "RET_MATRIX_SHIFT_FAILED", "RET_MATRIX_FACTORISATION_FAILED", "RET_PRINT_ITERATION_FAILED", "RET_NO_GLOBAL_MESSAGE_OUTPUTFILE", "RET_DISABLECONSTRAINTS_FAILED", "RET_ENABLECONSTRAINTS_FAILED", "RET_ALREADY_ENABLED", "RET_ALREADY_DISABLED", "RET_NO_HESSIAN_SPECIFIED", "RET_USING_REGULARISATION", "RET_EPS_MUST_BE_POSITVE", "RET_REGSTEPS_MUST_BE_POSITVE", "RET_HESSIAN_ALREADY_REGULARISED", "RET_CANNOT_REGULARISE_IDENTITY", "RET_CANNOT_REGULARISE_SPARSE", "RET_NO_REGSTEP_NWSR", "RET_FEWER_REGSTEPS_NWSR", "RET_CHOLESKY_OF_ZERO_HESSIAN", "RET_ZERO_HESSIAN_ASSUMED", "RET_CONSTRAINTS_ARE_NOT_SCALED", "RET_INITIAL_BOUNDS_STATUS_NYI", "RET_ERROR_IN_CONSTRAINTPRODUCT", "RET_FIX_BOUNDS_FOR_LP", "RET_USE_REGULARISATION_FOR_LP", "RET_UPDATEMATRICES_FAILED", "RET_UPDATEMATRICES_FAILED_AS_QP_NOT_SOLVED", "RET_UNABLE_TO_OPEN_FILE", "RET_UNABLE_TO_WRITE_FILE", "RET_UNABLE_TO_READ_FILE", "RET_FILEDATA_INCONSISTENT", "RET_OPTIONS_ADJUSTED", "RET_UNABLE_TO_ANALYSE_QPROBLEM", "RET_NWSR_SET_TO_ONE", "RET_UNABLE_TO_READ_BENCHMARK", "RET_BENCHMARK_ABORTED", "RET_INITIAL_QP_SOLVED", "RET_QP_SOLUTION_STARTED", "RET_BENCHMARK_SUCCESSFUL", "RET_NO_DIAGONAL_AVAILABLE", "RET_DIAGONAL_NOT_INITIALISED", "RET_ENSURELI_DROPPED", "RET_KKT_MATRIX_SINGULAR", "RET_QR_FACTORISATION_FAILED", "RET_INERTIA_CORRECTION_FAILED", "RET_NO_SPARSE_SOLVER", "RET_SIMPLE_STATUS_P1", "RET_SIMPLE_STATUS_P0", "RET_SIMPLE_STATUS_M1", "RET_SIMPLE_STATUS_M2", "RET_SIMPLE_STATUS_M3")
## 
## names(status_codes) <-  -1:150
## 
## status_code_to_text <- function(i) {
## 	status <- status_codes[as.character(i)]
## 	if ( is.na(status) )
## 		return(NULL)
## 	status
## }

qpoases_status_codes <- list(
    list(symbol = 'TERMINAL_LIST_ELEMENT', id = -1, msg = 'Terminal list element, internal usage only!'),
    list(symbol = 'SUCCESSFUL_RETURN', id = 0, msg = 'Successful return.'),
    list(symbol = 'RET_DIV_BY_ZERO', id = 1, msg = 'Division by zero.'),
    list(symbol = 'RET_INDEX_OUT_OF_BOUNDS', id = 2, msg = 'Index out of bounds.'),
    list(symbol = 'RET_INVALID_ARGUMENTS', id = 3, msg = 'At least one of the arguments is invalid.'),
    list(symbol = 'RET_ERROR_UNDEFINED', id = 4, msg = 'Error number undefined.'),
    list(symbol = 'RET_WARNING_UNDEFINED', id = 5, msg = 'Warning number undefined.'),
    list(symbol = 'RET_INFO_UNDEFINED', id = 6, msg = 'Info number undefined.'),
    list(symbol = 'RET_EWI_UNDEFINED', id = 7, msg = 'Error/warning/info number undefined.'),
    list(symbol = 'RET_AVAILABLE_WITH_LINUX_ONLY', id = 8, msg = 'This function is available under Linux only.'),
    list(symbol = 'RET_UNKNOWN_BUG', id = 9, msg = 'The error occured is not yet known.'),
    list(symbol = 'RET_PRINTLEVEL_CHANGED', id = 10, msg = 'Print level changed.'),
    list(symbol = 'RET_NOT_YET_IMPLEMENTED', id = 11, msg = 'Requested function is not yet implemented in this version of qpOASES.'),
    list(symbol = 'RET_INDEXLIST_MUST_BE_REORDERD', id = 12, msg = 'Index list has to be reordered. (12)'),
    list(symbol = 'RET_INDEXLIST_EXCEEDS_MAX_LENGTH', id = 13, msg = 'Index list exceeds its maximal physical length.'),
    list(symbol = 'RET_INDEXLIST_CORRUPTED', id = 14, msg = 'Index list corrupted.'),
    list(symbol = 'RET_INDEXLIST_OUTOFBOUNDS', id = 15, msg = 'Physical index is out of bounds.'),
    list(symbol = 'RET_INDEXLIST_ADD_FAILED', id = 16, msg = 'Adding indices from another index set failed.'),
    list(symbol = 'RET_INDEXLIST_INTERSECT_FAILED', id = 17, msg = 'Intersection with another index set failed.'),
    list(symbol = 'RET_INDEX_ALREADY_OF_DESIRED_STATUS', id = 18, msg = 'Index is already of desired status. (18)'),
    list(symbol = 'RET_ADDINDEX_FAILED', id = 19, msg = 'Adding index to index set failed.'),
    list(symbol = 'RET_REMOVEINDEX_FAILED', id = 20, msg = 'Removing index from index set failed.'),
    list(symbol = 'RET_SWAPINDEX_FAILED', id = 21, msg = 'Cannot swap between different indexsets.'),
    list(symbol = 'RET_NOTHING_TO_DO', id = 22, msg = 'Nothing to do.'),
    list(symbol = 'RET_SETUP_BOUND_FAILED', id = 23, msg = 'Setting up bound index failed.'),
    list(symbol = 'RET_SETUP_CONSTRAINT_FAILED', id = 24, msg = 'Setting up constraint index failed.'),
    list(symbol = 'RET_MOVING_BOUND_FAILED', id = 25, msg = 'Moving bound between index sets failed.'),
    list(symbol = 'RET_MOVING_CONSTRAINT_FAILED', id = 26, msg = 'Moving constraint between index sets failed.'),
    list(symbol = 'RET_SHIFTING_FAILED', id = 27, msg = 'Shifting of bounds/constraints failed.'),
    list(symbol = 'RET_ROTATING_FAILED', id = 28, msg = 'Rotating of bounds/constraints failed.'),
    list(symbol = 'RET_QPOBJECT_NOT_SETUP', id = 29, msg = 'The QP object has not been setup correctly, use another constructor. (29)'),
    list(symbol = 'RET_QP_ALREADY_INITIALISED', id = 30, msg = 'QProblem has already been initialised.'),
    list(symbol = 'RET_NO_INIT_WITH_STANDARD_SOLVER', id = 31, msg = 'Initialisation via extern QP solver is not yet implemented.'),
    list(symbol = 'RET_RESET_FAILED', id = 32, msg = 'Reset failed.'),
    list(symbol = 'RET_INIT_FAILED', id = 33, msg = 'Initialisation failed.'),
    list(symbol = 'RET_INIT_FAILED_TQ', id = 34, msg = 'Initialisation failed due to TQ factorisation.'),
    list(symbol = 'RET_INIT_FAILED_CHOLESKY', id = 35, msg = 'Initialisation failed due to Cholesky decomposition.'),
    list(symbol = 'RET_INIT_FAILED_HOTSTART', id = 36, msg = 'Initialisation failed! QP could not be solved!'),
    list(symbol = 'RET_INIT_FAILED_INFEASIBILITY', id = 37, msg = 'Initial QP could not be solved due to infeasibility!'),
    list(symbol = 'RET_INIT_FAILED_UNBOUNDEDNESS', id = 38, msg = 'Initial QP could not be solved due to unboundedness!'),
    list(symbol = 'RET_INIT_FAILED_REGULARISATION', id = 39, msg = 'Initialisation failed as Hessian matrix could not be regularised.'),
    list(symbol = 'RET_INIT_SUCCESSFUL', id = 40, msg = 'Initialisation done.'),
    list(symbol = 'RET_OBTAINING_WORKINGSET_FAILED', id = 41, msg = 'Failed to obtain working set for auxiliary QP. (40)'),
    list(symbol = 'RET_SETUP_WORKINGSET_FAILED', id = 42, msg = 'Failed to setup working set for auxiliary QP.'),
    list(symbol = 'RET_SETUP_AUXILIARYQP_FAILED', id = 43, msg = 'Failed to setup auxiliary QP for initialised homotopy.'),
    list(symbol = 'RET_NO_EXTERN_SOLVER', id = 44, msg = 'No extern QP solver available.'),
    list(symbol = 'RET_QP_UNBOUNDED', id = 45, msg = 'QP is unbounded.'),
    list(symbol = 'RET_QP_INFEASIBLE', id = 46, msg = 'QP is infeasible.'),
    list(symbol = 'RET_QP_NOT_SOLVED', id = 47, msg = 'Problems occured while solving QP with standard solver.'),
    list(symbol = 'RET_QP_SOLVED', id = 48, msg = 'QP successfully solved.'),
    list(symbol = 'RET_UNABLE_TO_SOLVE_QP', id = 49, msg = 'Problems occured while solving QP.'),
    list(symbol = 'RET_INITIALISATION_STARTED', id = 50, msg = 'Starting problem initialisation.'),
    list(symbol = 'RET_HOTSTART_FAILED', id = 51, msg = 'Unable to perform homotopy due to internal error. (50)'),
    list(symbol = 'RET_HOTSTART_FAILED_TO_INIT', id = 52, msg = 'Unable to initialise problem.'),
    list(symbol = 'RET_HOTSTART_FAILED_AS_QP_NOT_INITIALISED', id = 53, msg = 'Unable to perform homotopy as previous QP is not solved.'),
    list(symbol = 'RET_ITERATION_STARTED', id = 54, msg = 'Iteration...'),
    list(symbol = 'RET_SHIFT_DETERMINATION_FAILED', id = 55, msg = 'Determination of shift of the QP data failed.'),
    list(symbol = 'RET_STEPDIRECTION_DETERMINATION_FAILED', id = 56, msg = 'Determination of step direction failed.'),
    list(symbol = 'RET_STEPLENGTH_DETERMINATION_FAILED', id = 57, msg = 'Determination of step direction failed.'),
    list(symbol = 'RET_OPTIMAL_SOLUTION_FOUND', id = 58, msg = 'Optimal solution of neighbouring QP found.'),
    list(symbol = 'RET_HOMOTOPY_STEP_FAILED', id = 59, msg = 'Unable to perform homotopy step.'),
    list(symbol = 'RET_HOTSTART_STOPPED_INFEASIBILITY', id = 60, msg = 'Premature homotopy termination because QP is infeasible.'),
    list(symbol = 'RET_HOTSTART_STOPPED_UNBOUNDEDNESS', id = 61, msg = 'Premature homotopy termination because QP is unbounded. (60)'),
    list(symbol = 'RET_WORKINGSET_UPDATE_FAILED', id = 62, msg = 'Unable to update working sets according to initial guesses.'),
    list(symbol = 'RET_MAX_NWSR_REACHED', id = 63, msg = 'Maximum number of working set recalculations performed.'),
    list(symbol = 'RET_CONSTRAINTS_NOT_SPECIFIED', id = 64, msg = "Problem does comprise constraints! You also have to specify new constraints' bounds."),
    list(symbol = 'RET_INVALID_FACTORISATION_FLAG', id = 65, msg = 'Invalid factorisation flag.'),
    list(symbol = 'RET_UNABLE_TO_SAVE_QPDATA', id = 66, msg = 'Unable to save QP data.'),
    list(symbol = 'RET_STEPDIRECTION_FAILED_TQ', id = 67, msg = 'Abnormal termination due to TQ factorisation.'),
    list(symbol = 'RET_STEPDIRECTION_FAILED_CHOLESKY', id = 68, msg = 'Abnormal termination due to Cholesky factorisation.'),
    list(symbol = 'RET_CYCLING_DETECTED', id = 69, msg = 'Cycling detected.'),
    list(symbol = 'RET_CYCLING_NOT_RESOLVED', id = 70, msg = 'Cycling cannot be resolved, QP probably infeasible.'),
    list(symbol = 'RET_CYCLING_RESOLVED', id = 71, msg = 'Cycling probably resolved. (70)'),
    list(symbol = 'RET_STEPSIZE', id = 72, msg = 'For displaying performed stepsize.'),
    list(symbol = 'RET_STEPSIZE_NONPOSITIVE', id = 73, msg = 'For displaying non-positive stepsize.'),
    list(symbol = 'RET_SETUPSUBJECTTOTYPE_FAILED', id = 74, msg = 'Setup of SubjectToTypes failed.'),
    list(symbol = 'RET_ADDCONSTRAINT_FAILED', id = 75, msg = 'Addition of constraint to working set failed.'),
    list(symbol = 'RET_ADDCONSTRAINT_FAILED_INFEASIBILITY', id = 76, msg = 'Addition of constraint to working set failed (due to QP infeasibility).'),
    list(symbol = 'RET_ADDBOUND_FAILED', id = 77, msg = 'Addition of bound to working set failed.'),
    list(symbol = 'RET_ADDBOUND_FAILED_INFEASIBILITY', id = 78, msg = 'Addition of bound to working set failed (due to QP infeasibility).'),
    list(symbol = 'RET_REMOVECONSTRAINT_FAILED', id = 79, msg = 'Removal of constraint from working set failed.'),
    list(symbol = 'RET_REMOVEBOUND_FAILED', id = 80, msg = 'Removal of bound from working set failed.'),
    list(symbol = 'RET_REMOVE_FROM_ACTIVESET', id = 81, msg = 'Removing from active set... (80)'),
    list(symbol = 'RET_ADD_TO_ACTIVESET', id = 82, msg = 'Adding to active set...'),
    list(symbol = 'RET_REMOVE_FROM_ACTIVESET_FAILED', id = 83, msg = 'Removing from active set failed.'),
    list(symbol = 'RET_ADD_TO_ACTIVESET_FAILED', id = 84, msg = 'Adding to active set failed.'),
    list(symbol = 'RET_CONSTRAINT_ALREADY_ACTIVE', id = 85, msg = 'Constraint is already active.'),
    list(symbol = 'RET_ALL_CONSTRAINTS_ACTIVE', id = 86, msg = 'All constraints are active, no further constraint can be added.'),
    list(symbol = 'RET_LINEARLY_DEPENDENT', id = 87, msg = 'New bound/constraint is linearly dependent.'),
    list(symbol = 'RET_LINEARLY_INDEPENDENT', id = 88, msg = 'New bound/constraint is linearly independent.'),
    list(symbol = 'RET_LI_RESOLVED', id = 89, msg = 'Linear indepence of active contraint matrix successfully resolved.'),
    list(symbol = 'RET_ENSURELI_FAILED', id = 90, msg = 'Failed to ensure linear indepence of active contraint matrix.'),
    list(symbol = 'RET_ENSURELI_FAILED_TQ', id = 91, msg = 'Abnormal termination due to TQ factorisation. (90)'),
    list(symbol = 'RET_ENSURELI_FAILED_NOINDEX', id = 92, msg = 'QP is infeasible.'),
    list(symbol = 'RET_ENSURELI_FAILED_CYCLING', id = 93, msg = 'QP is infeasible.'),
    list(symbol = 'RET_BOUND_ALREADY_ACTIVE', id = 94, msg = 'Bound is already active.'),
    list(symbol = 'RET_ALL_BOUNDS_ACTIVE', id = 95, msg = 'All bounds are active, no further bound can be added.'),
    list(symbol = 'RET_CONSTRAINT_NOT_ACTIVE', id = 96, msg = 'Constraint is not active.'),
    list(symbol = 'RET_BOUND_NOT_ACTIVE', id = 97, msg = 'Bound is not active.'),
    list(symbol = 'RET_HESSIAN_NOT_SPD', id = 98, msg = 'Projected Hessian matrix not positive definite.'),
    list(symbol = 'RET_HESSIAN_INDEFINITE', id = 99, msg = 'Hessian matrix is indefinite.'),
    list(symbol = 'RET_MATRIX_SHIFT_FAILED', id = 100, msg = 'Unable to update matrices or to transform vectors.'),
    list(symbol = 'RET_MATRIX_FACTORISATION_FAILED', id = 101, msg = 'Unable to calculate new matrix factorisations. (100)'),
    list(symbol = 'RET_PRINT_ITERATION_FAILED', id = 102, msg = 'Unable to print information on current iteration.'),
    list(symbol = 'RET_NO_GLOBAL_MESSAGE_OUTPUTFILE', id = 103, msg = 'No global message output file initialised.'),
    list(symbol = 'RET_DISABLECONSTRAINTS_FAILED', id = 104, msg = 'Unable to disbable constraints.'),
    list(symbol = 'RET_ENABLECONSTRAINTS_FAILED', id = 105, msg = 'Unable to enbable constraints.'),
    list(symbol = 'RET_ALREADY_ENABLED', id = 106, msg = 'Bound or constraint is already enabled.'),
    list(symbol = 'RET_ALREADY_DISABLED', id = 107, msg = 'Bound or constraint is already disabled.'),
    list(symbol = 'RET_NO_HESSIAN_SPECIFIED', id = 108, msg = 'No Hessian matrix has been specified.'),
    list(symbol = 'RET_USING_REGULARISATION', id = 109, msg = 'Using regularisation as Hessian matrix is not positive definite.'),
    list(symbol = 'RET_EPS_MUST_BE_POSITVE', id = 110, msg = 'Eps for regularisation must be sufficiently positive.'),
    list(symbol = 'RET_REGSTEPS_MUST_BE_POSITVE', id = 111, msg = 'Maximum number of regularisation steps must be non-negative. (110)'),
    list(symbol = 'RET_HESSIAN_ALREADY_REGULARISED', id = 112, msg = 'Hessian has been already regularised.'),
    list(symbol = 'RET_CANNOT_REGULARISE_IDENTITY', id = 113, msg = 'Identity Hessian matrix cannot be regularised.'),
    list(symbol = 'RET_CANNOT_REGULARISE_SPARSE', id = 114, msg = 'Sparse matrix cannot be regularised as diagonal entry is missing.'),
    list(symbol = 'RET_NO_REGSTEP_NWSR', id = 115, msg = 'No additional regularisation step could be performed due to limits.'),
    list(symbol = 'RET_FEWER_REGSTEPS_NWSR', id = 116, msg = 'Fewer additional regularisation steps have been performed due to limits.'),
    list(symbol = 'RET_CHOLESKY_OF_ZERO_HESSIAN', id = 117, msg = 'Cholesky decomposition of (unregularised) zero Hessian matrix.'),
    list(symbol = 'RET_CONSTRAINTS_ARE_NOT_SCALED', id = 118, msg = 'When defining __MANY_CONSTRAINTS__, l1 norm of each constraint must be not greater than one.'),
    list(symbol = 'RET_ERROR_IN_CONSTRAINTPRODUCT', id = 119, msg = 'Error in user-defined constraint product function.'),
    list(symbol = 'RET_UPDATEMATRICES_FAILED', id = 120, msg = 'Unable to update QP matrices.'),
    list(symbol = 'RET_UPDATEMATRICES_FAILED_AS_QP_NOT_SOLVED', id = 121, msg = 'Unable to update matrices as previous QP is not solved.'),
    list(symbol = 'RET_UNABLE_TO_OPEN_FILE', id = 122, msg = 'Unable to open file. (120)'),
    list(symbol = 'RET_UNABLE_TO_WRITE_FILE', id = 123, msg = 'Unable to write into file.'),
    list(symbol = 'RET_UNABLE_TO_READ_FILE', id = 124, msg = 'Unable to read from file.'),
    list(symbol = 'RET_FILEDATA_INCONSISTENT', id = 125, msg = 'File contains inconsistent data.'),
    list(symbol = 'RET_UNABLE_TO_ANALYSE_QPROBLEM', id = 126, msg = 'Unable to analyse (S)QProblem(B) object.'),
    list(symbol = 'RET_NWSR_SET_TO_ONE', id = 127, msg = 'Maximum number of working set changes was set to 1.'),
    list(symbol = 'RET_UNABLE_TO_READ_BENCHMARK', id = 128, msg = 'Unable to read benchmark data.'),
    list(symbol = 'RET_BENCHMARK_ABORTED', id = 129, msg = 'Benchmark aborted.'),
    list(symbol = 'RET_INITIAL_QP_SOLVED', id = 130, msg = 'Initial QP solved.'),
    list(symbol = 'RET_QP_SOLUTION_STARTED', id = 131, msg = 'Solving QP...'),
    list(symbol = 'RET_BENCHMARK_SUCCESSFUL', id = 132, msg = 'Benchmark terminated successfully. (130)'),
    list(symbol = 'RET_NO_DIAGONAL_AVAILABLE', id = 133, msg = 'Sparse matrix does not have entries on full diagonal.'),
    list(symbol = 'RET_ENSURELI_DROPPED', id = 134, msg = ''))
