% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPhosFate.R
\name{erosion,RPhosFate-method}
\alias{erosion,RPhosFate-method}
\alias{erosion}
\title{Erosion}
\usage{
\S4method{erosion}{RPhosFate}(x)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Calculates and writes (R)USLE erosion to disk.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method call
x <- erosionPrerequisites(x)

x <- erosion(x)}

}
\references{
\cite{Renard, K.G., Foster, G.R., Weesies, G.A., McCool, D.K., Yoder, D.C.,
1997. Predicting soil erosion by water: a guide to conservation planning with
the Revised Universal Soil Loss Equation (RUSLE), Agriculture Handbook. U.S.
Government Printing Office, Washington, DC.}

\cite{Wischmeier, W.H., Smith, D.D., 1978. Predicting rainfall erosion
losses. A guide to conservation planning, Agriculture Handbook. U.S.
Government Printing Office, Washington, DC.}
}
\seealso{
\code{\link{firstRun}}, \code{\link{subsequentRun}}
}
