% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Presto.R, R/dbConnect.R, R/dbDisconnect.R
\docType{methods}
\name{Presto}
\alias{Presto}
\alias{dbConnect,PrestoDriver-method}
\alias{dbDisconnect,PrestoConnection-method}
\title{Connect to a Presto database}
\usage{
Presto(...)

\S4method{dbConnect}{PrestoDriver}(drv, catalog, schema, user,
  host = "localhost", port = 8080, source = getPackageName(),
  session.timezone = "UTC", parameters = list(), ...)

\S4method{dbDisconnect}{PrestoConnection}(conn)
}
\arguments{
\item{...}{currently ignored}

\item{drv}{A driver object generated by \code{\link{Presto}}}

\item{catalog}{The catalog to be used}

\item{schema}{The schema to be used}

\item{user}{The current user}

\item{host}{The presto host to connect to}

\item{port}{Port to use for the connection}

\item{source}{Source to specify for the connection}

\item{session.timezone}{Time zone to use for the connection. Presto returns
timestamps without time zones with respect to this value. The time
arithmetic (e.g. adding hours) will also be done in the given time
zone. See the session.timezone tests for examples.}

\item{parameters}{A \code{\link{list}} of extra parameters to be passed in
the \sQuote{X-Presto-Session} header}

\item{conn}{A \code{\linkS4class{PrestoConnection}} object}
}
\value{
[Presto] A \code{\linkS4class{PrestoDriver}} object

[dbConnect] A \code{\linkS4class{PrestoConnection}} object

[dbDisconnect] A \code{\link{logical}} value indicating success
}
\description{
Connect to a Presto database
}
\examples{
\dontrun{
  conn <- dbConnect(Presto(), catalog = 'hive', schema = 'default',
                    user = 'onur', host = 'localhost', port = 8080,
                    session.timezone='US/Eastern')
  dbListTables(conn, '\%_iris')
  dbDisconnect(conn)
}
}
