% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Eriksson.R
\name{Eriksson}
\alias{Eriksson}
\title{Eriksson model}
\usage{
Eriksson(z,p,mu,sigma,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p}{probability of direct response}

\item{mu}{mean of the scramble variable \eqn{S}}

\item{sigma}{standard deviation of the scramble variable \eqn{S}}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Eriksson model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Eriksson model.
The function can also return the transformed variable.
The Eriksson model was proposed by Eriksson in 1973.
}
\details{
The randomized response given by the person labelled \eqn{i} is \eqn{y_i} with probability \eqn{p} and a discrete uniform variable \eqn{S} with probabilities \eqn{q_1,q_2,...,q_j}
verifying \eqn{q_1+q_2+...+q_j=1-p}.
}
\examples{
N=53376
data(ErikssonData)
dat=with(ErikssonData,data.frame(z,Pi))
p=0.5
mu=mean(c(0,1,3,5,8))
sigma=sqrt(4/5*var(c(0,1,3,5,8)))
cl=0.95
Eriksson(dat$z,p,mu,sigma,dat$Pi,"mean",cl,N)
}
\references{
Eriksson, S.A. (1973).
\emph{A new model for randomized response.}
International Statistical Review 41, 40-43.
}
\seealso{
\code{\link{ErikssonData}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{Eriksson}
\keyword{Estimation}
\keyword{Quantitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

