% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMommy.R
\name{getMommy}
\alias{getMommy}
\title{Upward tip or node to root path}
\usage{
getMommy(tree,N)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric and
fully dichotomous.}

\item{N}{the number of node or tip to perform the function on. The function also works with tip/node labels.}
}
\value{
The function produces a vector of node numbers as integers, collated
  from a node or a tip towards the tree root.
}
\description{
This function is a wrapper around \pkg{phytools}
  \code{getDescendants} (\cite{Revell 2012}). It returns the node path from a
  given node or species to the root of the phylogeny.
}
\examples{
data("DataApes")
DataApes$Tstage->Tstage

getMommy(tree=Tstage,N=12)->gm
}
\references{
Revell, L. J. (2012). phytools: An R package for phylogenetic
comparative biology (and other things). \emph{Methods in Ecology and
Evolution}, 3: 217-223.doi:10.1111/j.2041-210X.2011.00169.x
}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro
  Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco
  Carotenuto
}
