#' Another data set on motive congruence.
#' 
#' A dataset containing the explicit intimacy motive, implicit affiliation/intimacy motive and self ratings of affective valence.
#' The variables are as follows:
#' 
#' \itemize{
#'   \item EM Explicit intimacy motive, measured with a questionnaire (Unified Motive Scales, Schönbrodt & Gerstenberg, 2012). Raw values have been z standardized.
#'   \item IM Implicit affiliation/intimacy motive, measured with picture story exercise (6 pictures). Raw motive scores have been controlled for word count and z standardized.
#'   \item VA z standardized valence rating. Consists of two bipolar items from the PANAVA questionnaire (Schallberger, 2005): `zufrieden ... unzufrieden' (satisfied ... unsatisfied) and `ungluecklich ... gluecklich' (unhappy ... happy).
#' }
#' 
#' @references Schallberger, U. (2005). \emph{Kurzskala zur Erfassung der Positiven Aktivierung, Negativen Aktivierung und Valenz in Experience Sampling Studien (PANAVA-KS) [Short scales for the assessment of positive affect, negative affect, and valence in experience sampling studies]}. University of Zurich.
#' @references Schönbrodt, F. D., & Gerstenberg, F. X. R. (2012). An IRT analysis of motive questionnaires: The Unified Motive Scales. \emph{Journal of Research in Personality, 46}, 725-742. doi:10.1016/j.jrp.2012.08.010
#' @docType data
#' @keywords datasets
#' @format A data frame with 362 rows and 3 variables
#' @name motcon2
NULL