% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.kmeans.R
\name{sym.kmeans}
\alias{sym.kmeans}
\title{Symbolic k-Means}
\usage{
sym.kmeans(sym.data, k = 3, iter.max = 10, nstart = 1,
algorithm = c('Hartigan-Wong', 'Lloyd', 'Forgy', 'MacQueen'))
}
\arguments{
\item{sym.data}{Symbolic data table.}

\item{k}{The number of clusters.}

\item{iter.max}{Maximun number of iterations.}

\item{nstart}{As in R kmeans function.}

\item{algorithm}{The method to be use, as in kmeans R function.}
}
\value{
This function return the following information: \cr

K-means clustering with 3 clusters of sizes 2, 2, 4\cr

Cluster means:\cr

  GRA     FRE     IOD    SAP\cr

1 0.93300 -13.500 193.500 174.75\cr

2 0.86300  30.500  54.500 195.25\cr

3 0.91825  -6.375  95.375 191.50\cr


Clustering vector:\cr

  L  P Co  S Ca  O  B  H \cr

1  1  3  3  3  3  2  2 \cr

Within cluster sum of squares by cluster:\cr

  [1] 876.625 246.125 941.875\cr

(between_SS / total_SS =  92.0 %) \cr

Available components:\cr

  [1] 'cluster'      'centers'      'totss'        'withinss'     'tot.withinss' 'betweenss'  \cr

[7] 'size'        \cr
}
\description{
This is a function is to carry out a k-means overs a interval symbolic data matrix.
}
\examples{
data(oils)
sk<-sym.kmeans(oils,k=3)
sk$cluster
}
\references{
Carvalho F., Souza R.,Chavent M., and Lechevallier Y. (2006)
Adaptive Hausdorff distances and dynamic clustering of symbolic interval data. Pattern
Recognition Letters Volume 27, Issue 3, February 2006, Pages 167-179
}
\seealso{
sym.hclust
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Kmeans}
\keyword{Symbolic}
