% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_objects.R
\name{var}
\alias{var}
\alias{var.default}
\alias{var.symbolic_interval}
\title{Symbolic Variance}
\usage{
var(x, ...)

\method{var}{default}(x, y = NULL, na.rm = FALSE, use, ...)

\method{var}{symbolic_interval}(x, method = c("centers", "interval",
  "billard"), na.rm = FALSE, ...)
}
\arguments{
\item{x}{A symbolic interval.}

\item{...}{As in R median function.}

\item{y}{NULL (default) or a vector, matrix or data frame with
compatible dimensions to x. The default is equivalent to y = x (but more efficient).}

\item{na.rm}{logical. Should missing values be removed?}

\item{use}{an optional character string giving a method for computing covariances
in the presence of missing values. This must be (an abbreviation of) one of the
strings 'everything', 'all.obs', 'complete.obs', 'na.or.complete',
or 'pairwise.complete.obs'.}

\item{method}{The method to be use.}
}
\description{
Compute the symbolic variance.
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{Variance}
