% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.smet.R
\docType{methods}
\name{print.smet}
\alias{print}
\alias{print.smet}
\alias{show}
\alias{show,smet-method}
\title{"Print" and "Show" method for "smet-class" object}
\usage{
\method{print}{smet}(x, date.field = "timestamp",
  date.format = "\%Y-\%m-\%dT\%H:\%M:\%S", file = NULL,
  print.all = !identical(file, NULL), max.records = 20, ...)

\S4method{show}{smet}(object)
}
\arguments{
\item{x, object}{a \code{smet-class} object}

\item{date.field}{field neme used for date and time. Default is \code{"timestamp"}.}

\item{date.format}{format used for date and time. Default is \code{"\%Y-\%m-\%dT\%H:\%M:\%S"}.}

\item{file}{filename where to print the \code{smet-class} object \code{x} as an ASCII file. It is equal to \code{"internal"}, the filename is taken from \code{slot(x,"file")} (internally defined in \code{x}).}

\item{print.all}{logical value. If it is \code{FALSE} exceeding lines are omitted for a better human readibility.}

\item{max.records}{maximum printable number of records. Default is 20 and it is activated only if \code{print.all==FALSE}. ,}

\item{...}{further argumnents for \code{writeLines}}
}
\description{
It prints or shows a \code{smet-class} directly on terminal or on an external file.
}
\examples{

file <- system.file("examples/test.smet",package="RSMET")
sm <- smet(file)
print(sm)

}
\seealso{
\code{\link{smet-class}}, \code{\link{smet}},\code{\link{writeLines}},\code{\link{print.meteoioini}}
}

